#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/68HC12/CCoptions/Sections.ui
#   root     is the parent window for this user interface

proc Sections_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#2

	frame $base.frame#1

	label $base.labelTEXT \
		-text Code:

	entry $base.entryTEXTVALUE \
		-textvariable "Sections($base,TEXTVALUE)" \
		-width 10

	label $base.labelFTEXT \
		-text {Far code:}

	entry $base.entryFTEXTVALUE \
		-textvariable "Sections($base,FTEXTVALUE)" \
		-width 10

	label $base.labelDATA \
		-text Data:

	entry $base.entryDATAVALUE \
		-textvariable "Sections($base,DATAVALUE)" \
		-width 10

	label $base.labelBSS \
		-text Bss:

	entry $base.entryBSSVALUE \
		-textvariable "Sections($base,BSSVALUE)" \
		-width 10

	label $base.labelSTRING \
		-text Strings:

	entry $base.entrySTRINGVALUE \
		-textvariable "Sections($base,STRINGVALUE)" \
		-width 10

	label $base.labelCONST \
		-text Constants:

	entry $base.entryCONSTVALUE \
		-textvariable "Sections($base,CONSTVALUE)" \
		-width 10

	label $base.labelMOD1 \
		-text Mod1:

	entry $base.entryMOD1VALUE \
		-textvariable "Sections($base,MOD1VALUE)" \
		-width 10

	label $base.labelMOD2 \
		-text Mod2:

	entry $base.entryMOD2VALUE \
		-textvariable "Sections($base,MOD2VALUE)" \
		-width 10

	label $base.labelBASE \
		-text Base:

	entry $base.entryBASEVALUE \
		-textvariable "Sections($base,BASEVALUE)" \
		-width 10


	# Geometry management

	grid $base.frame#2 -in $root	-row 1 -column 3 
	grid $base.frame#1 -in $root	-row 1 -column 1 
	grid $base.labelTEXT -in $base.frame#1	-row 1 -column 1  \
		-sticky w
	grid $base.entryTEXTVALUE -in $base.frame#1	-row 1 -column 2 
	grid $base.labelFTEXT -in $base.frame#2	-row 1 -column 1  \
		-sticky w
	grid $base.entryFTEXTVALUE -in $base.frame#2	-row 1 -column 2 
	grid $base.labelDATA -in $base.frame#1	-row 2 -column 1  \
		-sticky w
	grid $base.entryDATAVALUE -in $base.frame#1	-row 2 -column 2 
	grid $base.labelBSS -in $base.frame#1	-row 3 -column 1  \
		-sticky w
	grid $base.entryBSSVALUE -in $base.frame#1	-row 3 -column 2 
	grid $base.labelSTRING -in $base.frame#1	-row 4 -column 1  \
		-sticky w
	grid $base.entrySTRINGVALUE -in $base.frame#1	-row 4 -column 2 
	grid $base.labelCONST -in $base.frame#1	-row 5 -column 1  \
		-sticky w
	grid $base.entryCONSTVALUE -in $base.frame#1	-row 5 -column 2 
	grid $base.labelMOD1 -in $base.frame#1	-row 6 -column 1  \
		-sticky w
	grid $base.entryMOD1VALUE -in $base.frame#1	-row 6 -column 2 
	grid $base.labelMOD2 -in $base.frame#1	-row 7 -column 1  \
		-sticky w
	grid $base.entryMOD2VALUE -in $base.frame#1	-row 7 -column 2 
	grid $base.labelBASE -in $base.frame#1	-row 8 -column 1  \
		-sticky w
	grid $base.entryBASEVALUE -in $base.frame#1	-row 8 -column 2 

	# Resize behavior management

	grid rowconfigure $base.frame#2 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 4 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 5 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 6 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 7 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 8 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 2 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 0 -minsize 30
	grid columnconfigure $root 4 -weight 1 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 4 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 5 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 6 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 7 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 8 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 2 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    return
}

# get window and options
set w [lindex $args 0]

global Sections
global options

set options($w) [lindex $args 2]
set Sections($base,setfunction) [lindex $args 1]

set Sections($base,list) {
  TEXT -at .text FTEXT -aft .ftext DATA -ad .data
  BSS -ab .bss STRING -as .strings
  CONST -ac .const MOD1 -a1 .mod1 MOD2 -a2 .mod2
  BASE -ap .base
}

# remove any old definitions
foreach "name opt value" $Sections($base,list) {
    set Sections($base,${name}VALUE) {}
}

# get options
foreach option $options($w) {
    set value {}
    regexp {(-.*)=(.*)} $option all option value
    switch -- $option {
        -at {
            set Sections($base,TEXT) -at
            set Sections($base,TEXTVALUE) $value
        }
        -aft {
            set Sections($base,FTEXT) -aft
            set Sections($base,FTEXTVALUE) $value
        }
        -ad {
            set Sections($base,DATA) -ad
            set Sections($base,DATAVALUE) $value
        }
        -ab {
            set Sections($base,BSS) -ab
            set Sections($base,BSSVALUE) $value
        }
        -as {
            set Sections($base,STRING) -as
            set Sections($base,STRINGVALUE) $value
        }
        -ac {
            set Sections($base,CONST) -ac
            set Sections($base,CONSTVALUE) $value
        }
        -a1 {
            set Sections($base,MOD1) -a1
            set Sections($base,MOD1VALUE) $value
        }
        -a2 {
            set Sections($base,MOD2) -a2
            set Sections($base,MOD2VALUE) $value
        }
         -ap {
            set Sections($base,BASE) -ap
            set Sections($base,BASEVALUE) $value
        }
   }
}

# set default values
foreach "name opt value" $Sections($base,list) {
    if {$Sections($base,${name}VALUE) == {}} {
        set Sections($base,${name}VALUE) $value
    }
    bind $base.entry${name}VALUE <FocusOut> "SectionsSave $base"
    bind $base.entry${name}VALUE <Return> "SectionsSave $base"
}

code::help $w $base.labelTEXT "Program executable code"
code::help $w $base.entryTEXTVALUE "Program executable code"
code::help $w $base.labelFTEXT "Program far (banked) executable code"
code::help $w $base.entryFTEXTVALUE "Program far (banked) executable code"
code::help $w $base.labelDATA "Writeable initialized variables"
code::help $w $base.entryDATAVALUE "Writeable initialized variables"
code::help $w $base.labelBSS "Uninitialized variables"
code::help $w $base.entryBSSVALUE "Uninitialized variables"
code::help $w $base.labelSTRING "String literals"
code::help $w $base.entrySTRINGVALUE "String literals"
code::help $w $base.labelCONST "Read only constants"
code::help $w $base.entryCONSTVALUE "Read only constants"
code::help $w $base.labelMOD1 "__mod1__ variables"
code::help $w $base.entryMOD1VALUE "__mod1__ variables"
code::help $w $base.labelMOD2 "__mod2__ variables"
code::help $w $base.entryMOD2VALUE "__mod2__ variables"
code::help $w $base.labelBASE "Base page variables"
code::help $w $base.entryBASEVALUE "Base page variables"

proc ::SectionsSave {base} {
    global Sections
    global options

    set w [winfo toplevel $base]
    foreach "var val def" $Sections($base,list) {
	if {$Sections($base,${var}VALUE) != $def} {
            # variable is changed
	    set index [lsearch $options($w) $val*]
            if {$index == -1} {

		lappend options($w) $val=$Sections($base,${var}VALUE)
            } else {
		set options($w) [lreplace $options($w) $index $index $val=$Sections($base,${var}VALUE)]
            }
        } else {
            # variable is clear
	    set index [lsearch $options($w) $val*]
	    if {$index != -1} {
		set options($w) [lreplace $options($w) $index $index]
            }
        }
    }
    eval $Sections($base,setfunction) [list $options($w)]
}        
return "Define compiler section usage"



# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Sections_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Sections_ui"
	    Sections_ui .
	}
    }
}
