#
#	Build - application builder
#

# the main Build options
array set code::Build {
    initialized 0
    whenchanged 0
    rebuild 0
    relink 0
    project {}
    interp {}
    pwd {}
    PROCESSOR {}
    TARGET {}
    stop 0
    cancelbox 0
    cancelboxafter {}
    cancelboxtext {}
    oldGrab {}
}

#
# BUILD - the non GUI project builder
#
proc code::BUILD {project} {
    global env
    variable INTROL

    set INTROL [eval file join [file split $env(INTROL)]]
    Preferences $project
    if {[catch {Build none build $project} result]} {
	# build errors have occured
	puts stderr "In project [lindex $result 3],"
	puts stderr "the command \"[lindex $result 0]\""
	puts stderr "failed with the following error(s):"
	if {[lindex $result 1] == "ERROR"} {
	    puts stderr [lindex $result 2]
	} else {
	    # PROCESS (for now)
	    puts stderr [lindex $result 2]
	}
	exit 1
    }
    puts "Built $result"
    exit 0
}

proc code::Build {w command {files {}} {force 0}} {
    variable INTROL
    variable Build
    variable BuildRules
    variable BuildSuffixes
    variable BuildDefines
    variable UI

    if {!$Build(initialized)} {
        # first Entry of Build

        set Build(initialized) 1
	
	set oldproc $Build(PROCESSOR)
	foreach proc [PreferenceProcessorInfo]  {
	    set Build(PROCESSOR) $proc
	    set oext [BuildSubstitute {${XO}${E}}]
	    set sext [BuildSubstitute {${XS}${E}}]
	    set asmext [BuildSubstitute {${XASM}${E}}]
	    set ddfext [BuildSubstitute {${XDDF}${E}}]
	    set mcdext [BuildSubstitute {${XMCD}${E}}]
	    set ccdext [BuildSubstitute {${XCCD}${E}}]
	    set mcuext [BuildSubstitute {${XMCU}${E}}]
	    set cext [BuildSubstitute {${XC}${E}}]
	    set eext [BuildSubstitute {${XE}${E}}]
	    set aext [BuildSubstitute {${XA}${E}}]
	    set Build($proc) [BuildSubstitute {${E}}]
	    set Build($proc,O) $oext
	    set Build($oext) $proc
	    set Build($sext) $proc
	    set Build($asmext) $proc
	    set Build($ddfext) $proc
	    set Build($eext) $proc
	    set Build($aext) $proc
	    set Build($cext) $proc
	    set Build($mcdext) $proc
	    set Build($ccdext) $proc
	    set Build($mcuext) $proc

	    # the following are build rules:
	    # should they be moved to preferences?
            set icode [BuildBoolean [BuildSubstitute {${UseIcode}}]]
	    if {$icode} {
		    set Build($cext$oext) CompileIcode
		    set Build($cext.check) CompileIcodeCheck
	    } else {
		    set Build($cext$oext) Compile
		    set Build($cext.check) CompileCheck
	    }
	    set Build(PROCESSCompile) "Build errors"
	    set Build(ERRORSCompile) BuildIntrolErrors
	    set Build(PROCESSCompileCheck) "Build errors"
	    set Build(ERRORSCompileCheck) BuildIntrolErrors
	    set Build(PROCESSCompileIcode) "Build errors"
	    set Build(ERRORSCompileIcode) BuildIntrolErrors
	    set Build(PROCESSCompileIcodeCheck) "Build errors"
	    set Build(ERRORSCompileIcodeCheck) BuildIntrolErrors
	    set Build($oext$oext) {} ;# object files need no processing
	    set Build($aext$oext) {} ;# library files need no processing
	    set Build($eext$oext) {} ;# executable files need no processing
	    set Build($sext$oext) Assemble
	    set Build($sext.check) AssembleCheck
	    set Build($asmext$oext) Assemble
	    set Build($asmext.check) AssembleCheck
	    set Build($ddfext$oext) Assemble
	    set Build($ddfext.check) AssembleCheck
	    set Build(PROCESSAssemble) "Build errors"
	    set Build(ERRORSAssemble) BuildIntrolErrors
	    set Build(PROCESSAssembleCheck) "Build errors"
	    set Build(ERRORSAssembleCheck) BuildIntrolErrors
	    set Build(PROCESSLink) "Build errors"
	    set Build(ERRORSLink) BuildIntrolErrors
	    set Build(PROCESSLinkIcode) "Build errors"
	    set Build(ERRORSLinkIcode) BuildIntrolErrors
	    set Build($mcdext.$ccdext) CompileMCD
	    set Build($mcdext.check) CompileMCDCheck
	    set Build(PROCESSCompileMCD) "Build errors"
	    set Build(ERRORSCompileMCD) BuildIntrolErrors
	    set Build(PROCESSCompileMCDCheck) "Build errors"
	    set Build(ERRORSCompileMCDCheck) BuildIntrolErrors
	    set Build($mcuext.check) CompileMCUCheck
	    set Build(PROCESSCompileMCUCheck) "Build errors"
	    set Build(ERRORSCompileMCUCheck) BuildIntrolErrors
	}

	set Build(PROCESSOR) $oldproc
	# set up the object file directory
	set Build(OBJECT) [BuildRealFileName [Preference Build OBJECT]]
	if {!$Build(whenchanged)} {
	    # Build depends on several preferences
	    PreferenceWhenChanged System $w "set code::Build(initialized) 0; \
		set code::Build(relink) 1"
	    PreferenceWhenChanged Module $w "set code::Build(initialized) 0; \
		set code::Build(relink) 1"
	    PreferenceWhenChanged Build $w "set code::Build(initialized) 0; \
		set code::Build(rebuild) 1"
	    PreferenceWhenChanged Registers $w "set code::Build(initialized) 0; \
		set code::Build(relink) 1"
	    PreferenceWhenChanged Prescript $w "set code::Build(initialized) 0; \
		set code::Build(rebuild) 1"
	    PreferenceWhenChanged Postscript $w "set code::Build(initialized) 0; \
		set code::Build(rebuild) 1"
	    set Build(whenchanged) 1
	}
    }

    switch -exact $command {
    setproc {
	# just initialize
	set Build(PROCESSOR) [lindex $files 0]
	set file {}
	foreach part [file split $INTROL] {
	    set file [file join $file $part]
	}
        set Build(INTROL) $file
	set Build(relink) 0
	set Build(rebuild) 0
	return
    }
    ldfile {
	# return the current linker command file for a processor

	return [BuildLdFile [lindex $files 0]
    }
    generateld {
	# save the generated linker command file to a file
	set Build(NAME) [Preference Build name]
	set file [BuildLdFile $files]
	set name [BuildSubstitute [Preference Build ldfilename]]
	set name [tk_getSaveFile -initialdir [pwd] -initialfile $name]
	if {$name == ""} {
	    return
	}
	if {[catch {open $name w} fd]} {
	    # error opening file
	    tk_messageBox -parent $w -icon error \
	        -message "$fd" -type ok
	    return
	} else {
	    puts -nonewline $fd $file
	    close $fd
	}
        DirectoryRefresh
    }
    viewld {
	# look at the generated linker command file in the editor

	set Build(NAME) [Preference Build name]
	set name [BuildRealFileName [Preference Build ldfilename]]
        if {[Preference Build ldfile]} {
	    # edit a user-specified ld file
	    OpenFile $name
	    return
	}

	set proc [Preference Build processor]
        if {$proc == {}} {
            tk_messageBox \
		-parent $w \
	        -icon error \
	        -message "You have to select a processor first." \
	        -type ok
	        return
        }

	EDITview $name {} 0 "BuildLdFile $proc"
    }
    errors {
	# handle arbitrary build errors
	set errors $files
	if {[llength $errors] == 2 && [lindex $errors 1] == {}} {
	    EDITview "Build Errors" [lindex $errors 0] 1 {}
	} else {
	    EDITerrors $errors
	}
    }
    buildforce {
	# rebuild the entire project
	set result [Build $w build {} 1]
	return $result
    }
    generatemakefile {
	# save the generated makefile to a file
	set Build(NAME) [Preference Build name]
	set file [Build $w getmakefile]
	set name [BuildSubstitute [Preference Build makefilename]]
	set name [tk_getSaveFile -initialdir [pwd] -initialfile $name]
	if {$name == ""} {
	    return
	}
	if {[catch {open $name w} fd]} {
	    # error opening file
	    tk_messageBox -parent $w -icon error \
	        -message "$fd" -type ok
	    return
	} else {
	    puts -nonewline $fd $file
	    close $fd
	}
        DirectoryRefresh
    }
    makefile {
	set Build(NAME) [Preference Build name]
	set name [BuildRealFileName [Preference Build makefilename]]
        if {[Preference Build makefile]} {
	    # edit a user-specified makefile
	    OpenFile $name
	    return
	}

	EDITview $name {} 0 "Build $w getmakefile"
    }
    getmakefile {
	# Generate a makefile from a project
	set Build(makefile) 1
	# use ${INTROL} for the install directory
        set Build(introl) $Build(INTROL)
        set Build(INTROL) %%{INTROL}
	set result [Build $w build {} 1]
        set Build(INTROL) $Build(introl)
	unset Build(makefile)
	return $result
    }
    build {
	# build the current project

	set name [Preference Build name]
	set Build(NAME) $name
	if {[Preference Build makefile]} {
	    # use an external make program
	    set line [BuildSubstitute [Preference General BUILD]]
	    set notdone 1
	    while {$notdone} {
		# keep trying until cancel or no error
		set result [BuildExecute $w $line {}]
		if {$result != ""} {
		    # errors occured in build
		    if {$w == "none"} {
			catch {unset Build(ccoptions)}
			catch {unset Build(asoptions)}
			return -code error -errorcode CODEBUILD $result
		    }

		    # handle errors in the windowing environment
		    # turn off the cancel box
		    BuildCancelBox $w
		    if {0 && [lindex $result 0] == "PROCESS"} {
			set query [tk_messageBox -icon error \
			    -parent $w \
			    -message "Build of $name failed." -type abortretryignore]
		    } else {
			set query [tk_messageBox -icon error \
			    -parent $w \
			    -message "Build of $name failed - [lindex $result 1]" -type abortretryignore]
		    }
		    if {$query == "abort"} {
			return ""
		    } elseif {$query == "ignore"} {
			set notdone 0
		    }
		} else {
		    set notdone 0
		}
	    }
	    if {$w != "none"} {
		# update a potential directory display
		code::DirectoryRefresh
	    }
	    return ""
	}
	BuildCancelBox $w Starting "$name"
	set Build(stop) 0
	if {[catch {Build $w subbuild {} $force} result]} {
	    variable BuildActive

	    catch {unset BuildActive}
	    set Build(stop) 0
	    BuildCancelBox $w
	    error $result
	}
	set Build(stop) 0
	# turn off the cancel box
	BuildCancelBox $w
	return $result
    }
    subbuild {
	# build a project or subproject

	set name [Preference Build name]
	if {$UI} {
	    # save any open variables
	    EDITprebuild
	}
        set script [Preference Build prescript]
	if {$script != {}} {
	    # run the prescript
	    BuildScript $w $script "pre-build script"
	}

	if {$w != "none" && $name == ""} {
	    # ask for a project name
	    if {[BuildProjectName] == {}} {
		return {}
	    }
	    set name [Preference Build name]
	}

	set Build(NAME) $name
	# build any subprojects
	set subprojects {}
	foreach subproject [Preference Build subprojects] {
	    set result [BuildSubproject $w [BuildRealFileName $subproject] $force]
	    if {$result == {}} {
		return
	    }
	    set subprojects [concat $subprojects $result]
	}

	set filelist [concat [Preference Build files] $subprojects]
	if {$filelist == {}} {
	    error "no files in project"
	}
        set target [Preference Build target]
	if {$target != {}} {
	    # make the object directory in case it doesn't exist
	    if {![info exists Build(makefile)] && $Build(OBJECT) != {}} {
	        file mkdir $Build(OBJECT)
	    }
	    set result [Build $w $target $filelist $force]
	    if {$UI && $result != {}} {
	        DebuggerCheckTime $result
	    }
	} else {
	    # subprojects only
	    set result $subprojects
            set Build(TARGET) $result
	}
        set script [Preference Build postscript]
	if {$result != {} && $script != {}} {
	    BuildScript $w $script "post-build script"
	}
	BuildScriptClose
        set Build(TARGET) {}
	return $result
    }
    projectfiles {
	# return a list of the current project files
	set filelist [Preference Build files]
	set files {}
	set dependencies {}
	foreach srcinfo $filelist {
            # get the file name
            set src [lindex $srcinfo 0]
	    lappend files [BuildSubstitute $src]
            # get file dependencies
            set depends [lindex $srcinfo 2]
	    foreach depend [BuildSubstitute $depends] {
		if {[lsearch -exact $dependencies $depend] == -1} {
		    lappend dependencies $depend
		}
	    }
	}
        if {$dependencies != {}} {
	    lappend files {}
	    foreach depend $dependencies {
	        lappend files $depend
	    }
        }
        return $files
    }
    generatestartup {
	# save the generated startup code to a file
	set Build(NAME) [Preference Build name]
	set name [BuildSubstitute [Preference System startfilename]]
	set file [DdfGetStartFile $name]
	set name [tk_getSaveFile -initialdir [pwd] -initialfile $name]
	if {$name == ""} {
	    return
	}
	if {[catch {open $name w} fd]} {
	    # error opening file
	    tk_messageBox -parent $w -icon error \
	        -message "$fd" -type ok
	    return
	} else {
	    puts -nonewline $fd $file
	    close $fd
	}
        DirectoryRefresh
    }
    program {
	# build a program from files

	if {[Preference Build processor] != {} && \
	  [Preference System definestartup] && \
	  ![Preference System startfile]} {
	    set startname [BuildSubstitute [Preference System startfilename]]
            if {$Build(rebuild) || $Build(relink) || ![file exists $startname]} {
	        # the project has changed
	        # re-create the startup code
	        DdfStartFile
	        # check to see if the startfile is in the file list
	        set has 0
	        foreach arg $files {
		    if {[BuildSubstitute $arg] == $startname} {
			set has 1
			break
		    }
                }
		if {!$has} {
		    lappend files $startname
		}
	    }
        }

	set targets {}
	set Build(rules) ""
	catch {unset BuildRules}
	catch {unset BuildSuffixes}
	set Build(depends) ""
        if {$Build(rebuild)} {
	    # the project has changed
	    set force 1
	    set Build(rebuild) 0
        }
	if {$UI} {
	    set progress 0.0
	    if {[catch {expr 1.0 / [llength $files].0} increment]} {
		set increment 0.0
	    }
	}
	foreach arg $files {
	    set arg [BuildSubstitute $arg]
	    set result [BuildObject $w $arg $force]
	    if {$result == {}} {
		return {}
	    }
	    lappend targets $result
	    if {$UI} {
	        set progress [expr $progress + $increment]
		.status configure -progress $progress
	    }
	}
	if {$UI} {
	    .status configure -progress 0.0
	}
	set result [BuildProgram $w $targets $force]
	if {$result != {} && $Build(TARGET) != {}} {
	    if {[Preference System Srecord]} {
	        # want S-records
		set Build(FILENAME) [Preference System Srecordfile]
		set Build(ENTRY) [Preference System Srecordentry]
                if {[info exists Build(makefile)]} {
		    set temp $Build(TARGET)
		    set Build(TARGET) %%{TARGET}
		    append result "\n\t[BuildTarget $w Srecords $result]"
		    set Build(TARGET) $temp
		} else {
		    BuildTarget $w Srecords $result
		}
	    }
	    if {[Preference System Intelhex]} {
	        # want Intel hex
		set Build(FILENAME) [Preference System Intelhexfile]
		set Build(ENTRY) [Preference System Intelhexentry]
                if {[info exists Build(makefile)]} {
		    set temp $Build(TARGET)
		    set Build(TARGET) %%{TARGET}
		    append result "\n\t[BuildTarget $w Intelhex $result]"
		    set Build(TARGET) $temp
		} else {
		    BuildTarget $w Intelhex $result
		}
	    }
	    if {[Preference System Ieee695]} {
	        # want an IEEE-695 object file
		set Build(FILENAME) [Preference System Ieee695file]
		set Build(ENTRY) [Preference System Ieee695entry]
                if {[info exists Build(makefile)]} {
		    set temp $Build(TARGET)
		    set Build(TARGET) %%{TARGET}
		    append result "\n\t[BuildTarget $w IEEE695 $result]"
		    set Build(TARGET) $temp
		} else {
		    BuildTarget $w IEEE695 $result
		}
	    }
	}
        if {[info exists Build(makefile)]} {
	    return [BuildMakefile $result $targets]
	}
	return $result
    }
    library {
	set targets {}
	set Build(rules) ""
	catch {unset BuildRules}
	catch {unset BuildSuffixes}
	set Build(depends) ""
        if {$Build(rebuild)} {
	    # the project has changed
	    set force 1
	    set Build(rebuild) 0
        }
	if {$UI} {
	    set progress 0.0
	    if {[catch {expr 1.0 / [llength $files].0} increment]} {
		set increment 0.0
	    }
	}
	foreach arg $files {
	    set arg [BuildFileName $arg]
	    set result [BuildObject $w $arg $force]
	    if {$result == {}} {
		return {}
	    }
	    lappend targets $result
	    if {$UI} {
	        set progress [expr $progress + $increment]
		.status configure -progress $progress
	    }
	}
	if {$UI} {
	    .status configure -progress 0.0
	}
	set result [BuildLibrary $w $targets $force]
        if {[info exists Build(makefile)]} {
	    return [BuildMakefile $result $targets]
	}
	return $result
    }
    headers {
	# build header files from a ddf file

	foreach arg $files {
	    set name [BuildFileName $arg]
	    set header [DdfMakeHeader $name files]
	    foreach file $files {
		# write out the files
		set f [open $file w]
		puts -nonewline $f [DdfMakeVariantHeader $file $name]
		puts -nonewline $f $header
	        DirectoryRefresh
		close $f
	    }
	    set header [DdfMakeAsmHeader $name files]
	    foreach file $files {
		# write out the files
		set f [open $file w]
		puts -nonewline $f [DdfMakeVariantHeader $file $name 1]
		puts -nonewline $f $header
	        DirectoryRefresh
		close $f
	    }
	}
    }
    check {
	# check syntax of object
	set targets {}

	if {$UI} {
	    # save any open variables
	    EDITprebuild
	}
	foreach arg $files {
	    # is this in the current project?
	    set arg [BuildFileName $arg]
	    foreach file [Preference Build files] {
	        if {$arg == [lindex $file 0]} {
		    # use options
		    set arg $file
		    break
	        }
	    }
	    set result [BuildObject $w $arg 1 .check]
	    if {$result == {}} {
		return {}
	    }
	    lappend targets $result
	}
	BuildScriptClose
	return $result
    }
    object {
	# build object files from arg
	set targets {}

	if {$UI} {
	    # save any open variables
	    EDITprebuild
	}
	foreach arg $files {
	    # is this in the current project?
	    set arg [BuildFileName $arg]
	    foreach file [Preference Build files] {
	        if {$arg == [lindex $file 0]} {
		    # use options
		    set arg $file
		    break
	        }
	    }
	    set result [BuildObject $w $arg 1]
	    if {$result == {}} {
		return {}
	    }
	    lappend targets $result
	}
	BuildScriptClose
	return $result
    }
    execute {
	if {[llength $files]} {
	    # this builds a set of files into a program and executes it
	    set target [Build $w program $files $force]
	} else {
	    # this builds the current project into a program and executes it
	    set target [Build $w build $force]
	}
	if {$target != {}} {
	    if {$w == "none"} {
	        error "Build can't execute in a non-windowed environment"
	    }

	    set target [file join $Build(OBJECT) $target]
	    Debugger $w execute $target
	}
    }
    default {
	if {$w != "none"} {
            tk_messageBox -icon error \
		-parent $w \
	        -message "Build doesn't understand $command" -type ok
	} else {
	        error "Build doesn't understand $command"
	}
    }
    }
}

# 
# BuildMakefile - make a makefile from a project
#
proc code::BuildMakefile {result targets} {
    variable Build
    variable BuildRules
    variable BuildSuffixes

    # building a makefile
    set project [BuildMakeName $Build(PROJECT)]
    set object [BuildMakeName $Build(OBJECT)]
    if {[string compare $project $object] == 0} {
	set object ""
    } else {
	set object [BuildMakeName [BuildFileName $Build(OBJECT)]]
    }
    set makefile "#
# Makefile generated by CODE for $Build(NAME)
#\n\n"

    # add project notes to the makefile
    set notes [Preference Build notes]
    if {$notes != {}} {
        set notes [split $notes \n]
        foreach note $notes {
            append makefile "# $note\n"
        }
    }

    append makefile "
# The Introl install directory
INTROL = [BuildMakeName $Build(introl)]

# The project directory
PROJECT = $project

# The object file directory
OBJECT = $object\n\n"

	    append makefile "# The project file
TARGET = [BuildMakeName $Build(TARGET)]\n\n"
	    append makefile "# Object files that make up the project
"
    set line "OBJS ="
    foreach target $targets {
	# escape spaces
	if {$object == {}} {
	    set thisfile " $target"
	} else {
	    set thisfile " \${OBJECT}/$target"
	}
	if {[string length "$line$thisfile \\"] > 80} {
	    append makefile "$line \\\n"
	    set line "      $thisfile"
	} else {
	    append line $thisfile
	}
    }
    append makefile "$line\n\n"

    # rule to build the project
    regsub -all {%%} $result {$} result
    append makefile "# Build the project
\${TARGET}: \${OBJS}
\t$result\n\n"

    # define suffixes
    set suffixes [array names BuildSuffixes]
    if {$suffixes != {}} {
	append makefile "# File extensions\n"
	append makefile ".SUFFIXES:"
	foreach suffix $suffixes {
	    append makefile " $suffix"
	}
	append makefile "\n\n"
    }
    # default build rules
    set rules [array names BuildRules]
    if {$rules != {}} {
	append makefile "# Default build rules\n"
        foreach rule [array names BuildRules] {
	    regsub -all {%%} $BuildRules($rule) {$} cmd
	    append makefile "$rule:\n\t$cmd\n\n"
        }
    }
    if {$Build(rules) != ""} {
        regsub -all {%%} $Build(rules) {$} rules
	append makefile "# File specific build rules\n$rules\n"
    }
    if {$Build(depends) != ""} {
	regsub -all {%%} $Build(depends) {$} depends
	append makefile "# Dependencies\n$depends\n"
    }
    return $makefile
}

#
# BuildMakeName - make a filename usable in a makefile
#
proc code::BuildMakeName {name} {
    regsub -all {([ :])} $name {\\\0} name
    return $name
}
#
# BuildCancelBox - create the build cancel box
#
proc code::BuildCancelBox {w {text {}} {title {}}} {
    variable Build
    variable UI

    if {!$UI || [info exists Build(makefile)]} {
	return 0
    }

    if {$Build(stop) || $text == {}} {
	# get rid of the box
	catch {after cancel $Build(cancelboxafter)}
	set Build(cancelboxafter) {}
	set Build(cancelbox) 0
        catch {focus $Build(oldFocus)}
        catch {grab release .buildcancel}
	catch {destroy .buildcancel}
        if {$Build(oldGrab) != ""} {
	    if {$grabStatus == "global"} {
	        grab -global $Build(oldGrab)
	    } else {
	        grab $Build(oldGrab)
	    }
        }
	set Build(oldGrab) {}
	return 1
    }

    set Build(cancelboxtext) $text
    update

    if {$Build(cancelbox)} {
	# already created
	return 0
    }

    if {$Build(cancelboxafter) != {}} {
	# still waiting to start up the box
	return 0
    }

    if {$title == {}} {
	return 0
    }

    # wait a second in case we won't need it
    set Build(cancelboxafter) [after 1000 "code::BuildMakeCancel $w $title"]
    return 0
}

#
# BuildMakeCancel - make the build cancel box
#
proc code::BuildMakeCancel {w title} {
    variable Build

    set box .buildcancel
    toplevel $box 
    wm protocol $box WM_DELETE_WINDOW "# nothing"
    wm transient $box $w
    set f [frame $box.buttons]
    set cancelBtn [button $f.cancel -text Cancel -width 6 \
        -command "code::BuildCancel $w"]
    grid $cancelBtn -in $f -row 0 -column 1 
    grid $f -in $box -row 2 -column 0 -sticky ew -padx 5 -pady 5
    set ll [label $box.label -textvariable code::Build(cancelboxtext) -width 40]
    grid $ll -in $box -row 1 -column 0 -sticky ew -padx 5 -pady 5

    set Build(cancelboxafter) {}
    set Build(cancelbox) 1
    wm title $box "Building $title"

    set Build(oldFocus) [focus]
    set Build(oldGrab) [grab current $box]
    if {$Build(oldGrab) != ""} {
	set Build(grabStatus) [grab status $Build(oldGrab)]
    }
    grab $box
    focus $cancelBtn
    update idletasks
    placewindow $box widget $w
}

#
# BuildCancel - stop a build
#
proc code::BuildCancel {w} {
    variable Build

    set Build(stop) 1
}

#
# BuildSubproject - build a sub-project of this project
#
proc code::BuildSubproject {w name force} {
    global auto_path
    variable UI
    variable INTROL

    if {[BuildSubActive $name]} {
	error "$name is being built recursively" 
	return {}
    }

    # remember the project directory
    set pwd [pwd]

    # create the sub-build interpreter
    set i [interp create]

    # set up the auto_path
    interp eval $i set auto_path [list $auto_path]

    # set up aliases so our user interface handles the sub-interpreter
    $i alias code::DirectoryRefresh code::DirectoryRefresh
    $i alias code::OpenFile code::OpenFile
    $i alias code::EDITsavefile code::EDITsavefile
    $i alias code::EDITprebuild code::EDITprebuild
    $i alias code::Title code::Title
    $i alias code::isCurrent code::isCurrent
    $i alias code::status code::status
    $i alias code::slave code::slave
    $i alias code::CommandAdd code::CommandAdd
    $i alias update update
    $i alias .status .status
    if {$UI} {
        load {} Tk $i
        interp eval $i wm withdraw .
    }
    # load required packages
    load {} Code $i
    load {} Dbg $i

    interp eval $i set code::INTROL \"$INTROL\"

    # open the project
    interp eval $i code::Preferences $name 0 0 1

    # these have to be aliased after Build is loaded
    $i alias code::BuildCancelBox code::BuildCancelBox
    $i alias code::BuildMakeCancel code::BuildMakeCancel
    $i alias code::BuildCancel code::BuildCancel
    $i alias code::BuildSubActive code::BuildSubActive
    $i alias code::BuildSubDone code::BuildSubDone

    if {$UI} {
        status $w "Building subproject [file rootname [file tail $name]]"
        update idletasks
    }

    # do the build
    set result [interp eval $i code::Build $w subbuild {} $force]
    if {$result != {}} {
        set realresult {}
	foreach one $result {
	    lappend realresult [interp eval $i code::BuildRealFileName $one]
	}
	set result $realresult
    }

    # destroy the interpreter
    interp delete $i

    BuildSubDone $name

    # restore project directory
    cd $pwd
    return $result
}

#
# BuildSubActive - keep track of active subprojects
#
proc code::BuildSubActive {name} {
    variable BuildActive

    if {[info exists BuildActive] && [lsearch $BuildActive $name] != -1} {
	unset BuildActive
	return 1
    }

    lappend BuildActive $name
    return 0
}

#
# BuildSubDone - keep track of active subprojects
#
proc code::BuildSubDone {name} {
    variable BuildActive

    set BuildActive [lremove $BuildActive $name]
}

#
# BuildScript - run a build script
#
proc code::BuildScript {w script type} {
    variable Build

    if {[info exists Build(makefile)]} {
        tk_messageBox -icon warning \
            -parent $w \
	    -message "The $type cannot be used in a Makefile." \
	    -type ok
	    return
	    }
    if {$Build(interp) == {}} {
	set interp [interp create]
	set Build(interp) $interp

	# add aliases for commands
	interp alias $interp Preference {} code::Preference
    } else {
	set interp $Build(interp)
    }

    # update variables if they are defined
    if {[catch {interp eval $interp set PROCESSOR "$Build(PROCESSOR)"}]} {
	interp eval $interp {set PROCESSOR {}}
    }
    if {[catch {interp eval $interp set FILES \"$Build(FILES)\"}]} {
	interp eval $interp {set FILES {}}
    } else {
	# if FILES is a single file, define ROOTNAME
	if {[llength $Build(FILES)] == 1} {
	    interp eval $interp {set ROOTNAME [file rootname $FILES]}
	}
    }
    if {[catch {interp eval $interp set TARGET \"$Build(TARGET)\"}]} {
	interp eval $interp {set TARGET {}}
    }
    if {[catch {interp eval $interp set INTROL \"$Build(INTROL)\"}]} {
	interp eval $interp {set INTROL {}}
    }
    if {[catch {interp eval $interp set OBJECT \"$Build(OBJECT)\"}]} {
	interp eval $interp {set OBJECT {}}
    }
    if {[catch {interp eval $interp set PROJECT \"$Build(PROJECT)\"}]} {
	interp eval $interp {set PROJECT {}}
    }
    if {[catch {interp eval $interp set NAME \"$Build(NAME)\"}]} {
	interp eval $interp {set NAME {}}
    }
    set pwd [pwd]
    if {$Build(pwd) != {}} {
	# go to script directory
	cd $Build(pwd)
    }
    # evaluate the script
    interp eval $interp $script
    if {$pwd != [pwd]} {
	# restore project directory
	set Build(pwd) $pwd
    }
    cd $pwd

    # update variables in case they changed
    set Build(PROCESSOR) [interp eval $interp set PROCESSOR]
    set Build(FILES) [interp eval $interp set FILES]
    set Build(TARGET) [interp eval $interp set TARGET]
    set Build(INTROL) [interp eval $interp set INTROL]
    set Build(OBJECT) [interp eval $interp set OBJECT]
    set Build(PROJECT) [interp eval $interp set PROJECT]
    set Build(NAME) [interp eval $interp set NAME]
}

#
# BuildScriptClose - delete the script interpreter, if any
#
proc code::BuildScriptClose {} {
    variable Build

    if {$Build(interp) == {}} {
	return
    }
    interp delete $Build(interp)
    set Build(interp) {}
}

#
# BuildCOptions - get options associated with a file, if in a project
#
proc code::BuildCOptions {file} {
    # is this in the current project?
    set file [BuildFileName $file]
    foreach list [Preference Build files] {
        if {$file == [lindex $list 0]} {
   	    # use options
	    set file $list
	    break
        }
    }
    if {[lindex $file 1] != {}} {
	# has local options
	return [lindex $file 1]
    }
    # no local options
    return [Preference Build [Preference Build processor]ccoptions]
}

#
# BuildCIncludes - get the include directories used for a file
#
proc code::BuildCIncludes {file} {
    variable INTROL
    set includes {}
    foreach option [BuildCOptions $file] {
	if {[regexp -- {-[i]*=(.*)} $option all name]} {
	    lappend includes $name
	}
    }
    lappend includes [file join $INTROL include]
    return $includes
}

#
# BuildCDefines - get the #defines used for a file
#
proc code::BuildCDefines {file} {
    set defines {}
    foreach option [BuildCOptions $file] {
	if {[regexp -- {-D(.*)=(.*)} $option all name value]} {
	    lappend defines [list $name $value]
	} elseif {[regexp -- {-D(.*)} $option all name]} {
	    lappend defines [list $name 1]
	}
    }
    return $defines
}

#
# BuildProjectName - name a project
#
proc code::BuildProjectName {} {
    variable Build

    set w .
    set box .projectname
    toplevel $box 
    wm transient $box $w
    set f [frame $box.buttons]
    set okBtn [button $f.ok -text Ok -width 6 \
        -command code::BuildSetProjectName]
    set cancelBtn [button $f.cancel -text Cancel -width 6 \
        -command "set code::Build(project) {}"]
    grid $okBtn -in $f -row 0 -column 0 
    grid $cancelBtn -in $f -row 0 -column 1 
    grid $f -in $box -row 2 -column 0 -sticky ew -padx 5 -pady 5
    set Build(projectentry) [Preference Build name]
    set e [entry $box.entry -textvariable code::Build(projectentry) -width 30]
    bind $e <Key-Return> code::BuildSetProjectName
    grid $e -in $box -row 1 -column 0 -sticky ew -padx 5 -pady 5
    set l [label $box.l -text "Enter the project name"]
    grid $l -in $box -row 0 -column 0 -sticky ew -padx 5 -pady 5

    placewindow $box widget $w
    wm title $box "Project Name"

    set oldFocus [focus]
    set oldGrab [grab current $box]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    grab $box
    focus $e

    tkwait variable code::Build(project)
    catch {focus $oldFocus}
    grab release $box
    destroy $box
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    if {$Build(project) == {}} {
	return {}
    }
    Preference Build name $Build(project)
    return $Build(project)
}

#
# BuildSetProjectName - set the name of a project from the entry varoable
#
proc code::BuildSetProjectName {} {
    global code::Build

    set Build(project) $Build(projectentry)
}

#
# BuildRealFileName - get the full real name of a file
#
proc code::BuildRealFileName {file} {
    variable Build

    set file [BuildSubstitute $file]
    if {$file == {}} {
	return {}
    }
    if {[file dirname $file] == "."} {
	set file [file join $Build(PROJECT) $file]
    }

    return $file
}

#
# BuildFileName - return just the base name of a file in the current directory
#
proc code::BuildFileName {file} {
    variable Build

    set found 0

    if {![file isdirectory $file] && [file dirname $file] == $Build(PROJECT)} {
	set file [file tail $file]
	set found 1
    }
    if {!$found && $Build(PROJECT) != {}} {
	# try to find files in the PROJECT hierarchy

	set project $Build(PROJECT)
	set head $file
	set tail {}
	set oldhead {}
	while {$head != $oldhead} {
	    set tail [file join [file tail $head] $tail]
	    set oldhead $head
	    set head [file dirname $head]
	    if {$head == $project} {
		set file [file join \${PROJECT} $tail]
		set found 1
		break
	    }
	}
    }

    if {!$found} {
	# try to find files in the INTROL hierarchy

	set head $file
	set tail {}
	set oldhead {}
	while {$head != $oldhead} {
	    set tail [file join [file tail $head] $tail]
	    set oldhead $head
	    set head [file dirname $head]
	    if {$head == $Build(INTROL)} {
		set file [file join \${INTROL} $tail]
		break
	    }
	}
    }

    set ext [string tolower [file extension $file]]
    regexp {(\..*)([0-9][0-9])} $ext all front e
    if {[info exists e] && "[BuildLookup E]" == "$e"} {
	set file [file rootname $file]$front\${E}
    }
    return $file
}

#
# BuildProgram - link object files into a program
#
proc code::BuildProgram {w files force} {
    variable Build
    variable UI

    set all ""
    set match 1
    foreach src $files {
        set ext [string tolower [file extension $src]]
	if {$all == ""} {
	    set all $ext
	} elseif {$all != $ext} {
	    set match 0
	}
    }

    if {![info exists Build($ext)]} {
	set ext [set ext]$Build([Preference Build processor])
        if {![info exists Build($ext)]} {
	    error "can't make program"
	}
    } 
    if {$Build(relink)} {
	# the System preferences have changed: force a re-link
	set force 1
	set Build(relink) 0
    }

    set proc [Preference Build processor]
    set Build(PROCESSOR) $proc
    set root [BuildProgramName $files]
    set fullroot [file join $Build(OBJECT) $root]
    set ldfile [BuildSubstitute [Preference Build ldfilename]]
    if {$UI && [Preference Build ldfile]} {
        EDITsavefile $ldfile 
    }
    if {!$force && [file exists $fullroot]} {
	# check to see if this file should be built

	set mtime [file mtime $fullroot]
        if {[Preference Build ldfile] && [file exists $ldfile]} {
	    # using a linker command file
	    if {$mtime < [file mtime $ldfile]} {
		 set force 1
	    }
	}
	if {!$force} {
	    foreach file $files {
                if {[BuildCancelBox $w "Checking [file tail $file]"]} {
		    return {}
	        }
	        set tryfile [file join $Build(OBJECT) $file]
                if {![file exists $tryfile]} {
		    set tryfile [BuildRealFileName $file]
                    if {![file exists $tryfile]} {
		        continue
		    }
	        }
	        if {$mtime < [file mtime $tryfile]} {
		    # target file is older than object, re-build
		    set force 1
		    break
	        }
	    }
	}
	if {!$force} {
	    # no need to rebuild
	    return $fullroot
	}
    }

    if {[info exists Build(makefile)]} {
        set Build(FILES) %%{OBJS}
        set Build(TARGET) %%{TARGET}
    } else {
        set Build(FILES) $files
        set Build(TARGET) $fullroot
    }
    set stdin {}
    if {$proc != "Other"} {
        if {![Preference Build ldfile]} {
	    # generate the linker command file
	    set Build(LDFILE) [BuildLookup LDFILEG]
	    set stdin [BuildLdFile $proc]
            if {[info exists Build(makefile)]} {
                tk_messageBox -icon warning \
		    -parent $w \
	            -message "You should specify an external linker command file to use this Makefile." \
		    -type ok
	    }
        } elseif {[Preference Build ldfilename] != {}} {
	    set Build(LDFILE) [BuildSubstitute [Preference Build ldfilename]]
        }
        if {[Preference Build largemodel]} {
	    # use large model libraries
	    set Build(LIBS) [Preference Build ${proc}LLIBS]
        } else {
	    set Build(LIBS) [Preference Build ${proc}LIBS]
	}
    }

    set script [Preference Build prelinkscript]
    if {$script != {}} {
        # run the prelinkscript
        BuildScript $w $script "pre-link script"
    }
    set icode [BuildBoolean [BuildSubstitute {${UseIcode}}]]
    if {$icode} {
        set result [BuildTarget $w LinkIcode $root $stdin]
    } else {
        set result [BuildTarget $w Link $root $stdin]
    }
    if {$result == {}} {
        file delete $fullroot
    }
    if {[info exists Build(makefile)]} {
        set Build(FILES) $files
        set project [BuildMakeName $Build(PROJECT)]
        set object [BuildMakeName $Build(OBJECT)]
        if {[string compare $project $object] == 0} {
            set Build(TARGET) $root
	} else {
            set Build(TARGET) [file join \${OBJECT} $root]
	}
    }
    return $result
}

#
# BuildBoolean - return 0 or non-zero for a string or number
#
proc code::BuildBoolean {value} {
    set value [string tolower $value]
    if {$value != {}} {
	if {![string is integer $value]} {
	    switch -exact $value {
		yes -
		true -
		ok -
		y {
	            set value 1
		}
		no -
		false -
		n {
		    set value 0
		}
	    }
	}
    } else {
	set value 0
    }
    return $value
}

#
# BuildProgramName - get the name a a project's program
#
proc code::BuildProgramName {{files {}}} {
    if {[Preference Build target] != "program"} {
	return ""
    }
    set name [Preference Build name]
    if {$name != {}} {
	set root [BuildSubstitute "$name\${XE}\${E}"]
    } elseif {[llength $files] == 1} {
	# use the name of the single file
	set root [BuildSubstitute \
	    "[file tail [file rootname $files]]\${XE}\${E}"]
    } else {
	# use the default name
        set root [BuildSubstitute {${LDOUT}}]
    }
    set Build(FILES) {}
    return $root
}

#
# BuildLibrary - Build a library from files
#
proc code::BuildLibrary {w files force} {
    global code::Build

    set all ""
    set match 1
    foreach src $files {
        set ext [string tolower [file extension $src]]
	if {$all == ""} {
	    set all $ext
	} elseif {$all != $ext} {
	    set match 0
	}
    }

    if {![info exists Build($ext)]} {
	set ext [set ext]$Build([Preference Build processor])
        if {![info exists Build($ext)]} {
	    error "can't make library file"
	}
    } 
    set proc [Preference Build processor]
    set Build(PROCESSOR) $proc
    set Build(ARSUBNAME) [Preference Build name]
    set root [BuildSubstitute {${ARNAME}}]
    set fullroot [file join $Build(OBJECT) $root]
    if {$Build(relink)} {
	# the System preferences have changed: force a re-link
	set force 1
	set Build(relink) 0
    }
    if {!$force && [file exists $fullroot]} {
	# check to see if this file should be built

	set mtime [file mtime $fullroot]
	foreach file $files {
            if {[BuildCancelBox $w "Checking [file tail $file]"]} {
		return {}
	    }
	    set tryfile [file join $Build(OBJECT) $file]
            if {![file exists $tryfile]} {
		set tryfile [BuildRealFileName $file]
                if {![file exists $tryfile]} {
		    continue
		}
	    }
	    if {$mtime < [file mtime $tryfile]} {
		# target file is older than object, re-build
		set force 1
		break
	    }
	}
	if {!$force} {
	    # no need to rebuild
	    return $fullroot
	}
    }
    if {[info exists Build(makefile)]} {
        set Build(FILES) %%{OBJS}
        set Build(TARGET) %%{TARGET}
    } else {
        set Build(FILES) $files
        set Build(TARGET) $fullroot
    }
    set result [BuildTarget $w Archive $root]
    if {$result == {}} {
        file delete $fullroot
    }
    if {[info exists Build(makefile)]} {
        set Build(FILES) $files
        set Build(TARGET) [file join \${OBJECT} $root]
    }
    set Build(FILES) {}
    set Build(ARSUBNAME) {}
    return $result
}

#
# BuildObject - object files from source
#
proc code::BuildObject {w srcinfo force {oext {}}} {
    variable Build
    variable BuildRules
    variable BuildSuffixes
    variable UI

    # get the file name
    set src [lindex $srcinfo 0]
    # get file options
    set opts [lindex $srcinfo 1]
    # get file dependencies
    set depends [lindex $srcinfo 2]

    set proc [Preference Build processor]
    if {[string match $proc ""]} {
	error "you must select a processor first"
    }
    set Build(PROCESSOR) $proc

    if {$UI} {
        # make sure any edited file is saved
        EDITsavefile $src
        foreach depend $depends {
	    set depend [BuildRealFileName $depend]
            EDITsavefile $depend
        }
    }

    if {[string match {${PROJECT}/*} $src]} {
	# we remove the project prefix, for more portable names in the
	# object file.
	regexp {\$\{PROJECT\}/(.*)} $src all realsrc
    } else {
	set realsrc $src
    }
    set realsrc [BuildSubstitute $realsrc]
    set initialext [string tolower [file extension $realsrc]]
    set ext [set initialext]$Build([Preference Build processor])
    if {![info exists Build($ext)]} {
        set ext $initialext
        if {![info exists Build($ext)]} {
            error "don't understand files of with $realsrc's extension"
	}
    }

    if {$oext == {}} {
	# find the target extension
        set oext $Build($proc,O)
    }
    set object [file tail [file rootname $realsrc]]
    set object $object$oext
    set fromto $ext$oext
    if {![info exists Build($fromto)]} {
	    error "don't know how to process $realsrc"
    }

    if {[BuildCancelBox $w "Checking $realsrc"]} {
	return {}
    }
    if {[info exists Build(makefile)]} {
	# building a makefile, return the object file name
        set myfromto $initialext$oext
	if {[string compare $Build(OBJECT) $Build(PROJECT)] == 0 && $opts == {}} {
	    if {![info exists BuildRules($myfromto)]} {
	        # have a new default rule

	        set BuildSuffixes($initialext) 1
	        set BuildSuffixes($oext) 1
                set Build(PROCESSOR) $proc
                set Build(FILES) "%%<"
                set Build(TARGET) "%%@"
	        set result [BuildTarget $w $Build($fromto) $realsrc {} $opts]
	        set BuildRules($myfromto) $result
	    }
	} else {
	    # A soure file specific rule

	    set BuildSuffixes($initialext) 1
	    set BuildSuffixes($oext) 1
	    set Build(PROCESSOR) $proc
	    set Build(FILES) [list $realsrc]
	    if {[string compare $Build(OBJECT) $Build(PROJECT)] == 0} {
	        set Build(TARGET) $object
	        set result [BuildTarget $w $Build($fromto) $realsrc {} $opts]
	        append Build(rules) "$object: $realsrc\n\t$result\n"
	    } else {
	        set Build(TARGET) "%%{OBJECT}/$object"
	        set result [BuildTarget $w $Build($fromto) $realsrc {} $opts]
	        append Build(rules) "\${OBJECT}/$object: $realsrc\n\t$result\n"
	    }
	}

	if {$depends != {}} {
	    if {[string compare $Build(OBJECT) $Build(PROJECT)] == 0} {
	        set line "$object:"
	    } else {
	        set line "\${OBJECT}/$object:"
	    }
	    foreach depend $depends {
		set name "[BuildMakeName $depend]"
		if {$line == ""} {
		    set line "\t"
		}
		if {[string length "$line $name"] > 80} {
		    append Build(depends) "$line \\\n"
		    set line "\t$name"
		} else {
		    append line " $name"
		}
	    }
	    append Build(depends) "$line\n"
	}
	# check for pre- and post- build scripts
        set script [Preference Build pretranslatescript]
        if {$script != {}} {
            # complain about the pretranslatescript
            BuildScript $w $script "pre-translate script"
        }
        # get the file specific prescript
        set script [Preference Prescript $src]
        if {$script != {}} {
	    BuildScript $w $script "pre-translate script for $realsrc"
        }
        set script [Preference Postscript $src]
        if {$script != {}} {
            # complain about the file specific postscript
	    BuildScript $w $script "post-translate script for $realsrc"
        }
        set script [Preference Build posttranslatescript]
        if {$script != {}} {
            # complain about the posttranslatescript
            BuildScript $w $script "post-translate script"
        }
	return $object
    }
    set object [file join $Build(OBJECT) $object]
    if {!$force && [file exists $object] && [file exists $realsrc]} {
	# check to see if this file should be built

	set mtime [file mtime $object]
	if {$mtime > [file mtime $realsrc]} {
	    # source file is older than object file, check for dependencies
	    foreach depend $depends {
		set depend [BuildRealFileName $depend]
		if {![file exists $depend]} {
	            error "cannot find dependency $depend for file $realsrc"
		}
		if {$mtime <= [file mtime $depend]} {
		    # object file is older than dependency, re-translate
		    set force 1
		    break
		}
	    }

	    if {!$force} {
		# no need to rebuild
		return $object
	    }
	}
    }

    set Build(PROCESSOR) $proc
    set Build(FILES) [list $realsrc]
    set Build(TARGET) $object

    if {[string tolower [file extension $realsrc]] == [BuildSubstitute {${XDDF}}]} {
	# building a .ddf file. Make C headers
	set pwd [pwd]
	set header [DdfMakeHeader $realsrc files]
	if {$Build(OBJECT) != {}} {
	    cd $Build(OBJECT)
	}
	foreach file $files {
	    # write out the files into the object directory
	    set f [open $file w]
	    puts -nonewline $f [DdfMakeVariantHeader $file $realsrc]
	    puts -nonewline $f $header
	    if {$UI} {
	        DirectoryRefresh
	    }
	    close $f
	}
	cd $pwd
	# Make assembly headers
	set header [DdfMakeAsmHeader $realsrc files]
	if {$Build(OBJECT) != {}} {
	    cd $Build(OBJECT)
	}
	foreach file $files {
	    # write out the files into the object directory
	    set f [open $file w]
	    puts -nonewline $f [DdfMakeVariantHeader $file $realsrc 1]
	    puts -nonewline $f $header
	    if {$UI} {
	        DirectoryRefresh
	    }
	    close $f
	}
	cd $pwd
    }

    set script [Preference Build pretranslatescript]
    if {$script != {}} {
        # run the pretranslatescript
        BuildScript $w $script "pre-translate script"
    }
    # get the file specific prescript
    set script [Preference Prescript $src]
    if {$script != {}} {
	BuildScript $w $script "pre-translate script for $realsrc"
    }
    set result [BuildTarget $w $Build($fromto) $realsrc {} $opts]
    if {$result != {}} {
        set script [Preference Postscript $src]
        if {$script != {}} {
            # run the file specific postscript
	    BuildScript $w $script "post-translate script for $realsrc"
        }
        set script [Preference Build posttranslatescript]
        if {$script != {}} {
            # run the posttranslatescript
            BuildScript $w $script "post-translate script"
        }

    }
    set Build(FILES) {}
    set Build(TARGET) {}
    return $result
}

#
# BuildTarget - build a target from a source
#
proc code::BuildTarget {w cmd name {stdin {}} {options {}}} {
    variable Build

    if {$cmd == {}} {
	# no translation needed
        return $name
    }
    # get translation command
    set info "$cmd $name"
    if {[BuildCancelBox $w $info]} {
	return {}
    }
    if {$options != {}} {
	# local options
        switch -exact $cmd {
	    Compile {
	      set Build(ccoptions) $options
	    }
	    Assemble {
	      set Build(asoptions) $options
	    }
        }
    }
    set line [BuildLookup $cmd]
    set line [BuildSubstitute $line]
    if {[info exists Build(makefile)]} {
	# building a makefile, return the command line

	return $line
    }

    set notdone 1
    while {$notdone} {
	# keep trying until cancel or no error
        set result [BuildExecute $w $line $info $stdin]
        if {$result != ""} {
	    # errors occured in build
            if {$w == "none"} {
		catch {unset Build(ccoptions)}
		catch {unset Build(asoptions)}
	        return -code error -errorcode CODEBUILD $result
	    }

	    # handle errors in the windowing environment
	    # turn off the cancel box
	    BuildCancelBox $w
	    if {[lindex $result 0] == "PROCESS"} {
		set action [BuildSubstitute \$\{PROCESS$cmd\}]
		if {$action != {}} {
		    set errors [[BuildSubstitute \$\{ERRORS$cmd\}] \
			[lindex $result 1]]
		    if {$errors == {}} {
			set action {}
		    }
		}
		if {$action != {}} {
		    # a defined action exists
		    set query [code::[lindex $action 0] $w [lindex $action 1] \
			$errors]
                    catch {unset Build(ccoptions)}
                    catch {unset Build(asoptions)}
		    return ""
		} else {
                    set query [tk_messageBox -icon error \
		         -parent $w \
	            -message "$cmd of $name failed." -type abortretryignore]
		}
	    } else {
                set query [tk_messageBox -icon error \
		    -parent $w \
	            -message "$cmd of $name failed - [lindex $result 1]" -type abortretryignore]
	    }
	    if {$query == "abort"} {
                catch {unset Build(ccoptions)}
                catch {unset Build(asoptions)}
	        return ""
	    } elseif {$query == "ignore"} {
	        set notdone 0
	    }
	    set Build(stop) 0
	    BuildCancelBox $w Continuing [Preference Build name]
        } else {
	    set notdone 0
	}
    }
    if {$w != "none"} {
	# update a potential directory display
	code::DirectoryRefresh
    }
    catch {unset Build(ccoptions)}
    catch {unset Build(asoptions)}
    return $Build(TARGET)
}

#
# BuildSubstitute - substute macro names in a command line
#
proc code::BuildSubstitute {line {count 0}} {
    set done ""
    while {1} {
        # perform macro substitutions
        set startindex [string first {$} $line]
        if {$startindex == -1} {
	    return [append done $line]
	}
	incr count
        if {$count > 100} {
            error "too much recursion in build"
        }
	append done [string range $line 0 [expr $startindex - 1]]
	set line [string range $line $startindex end]
	set char [string index $line 1]
	if {$char == ""} {
	    return [append done {$}]
	}
	if {$char != "\{" && $char != "("} {
	    append done \$$char
	    set line [string range $line 2 end]
	    continue
	}
	if {$char == "\{"} {
	    set end "\}"
	} else {
	    set end ")"
	}
        set endindex [string first $end $line]
	if {$endindex == -1} {
            error "malformed variable in build"
	}
	set var [string range $line 2 [expr $endindex - 1]]
	set var [BuildSubstitute $var $count]

	set var [BuildLookup $var]
	set rest [string range $line [expr $endindex + 1] end]
	set line $var
	append line $rest
    }
}

#
# BuildLookup - look up a macro name
#
proc code::BuildLookup {var} {
    global code::Build code::Preferences

    if {![info exists Build(PROCESSOR)]} {
	# get a default processor
	set Build(PROCESSOR) [Preference Build processor]
    }
    # look for Build variables, then processor specific ones, then general ones
    if {[info exists Build($var)]} {
       set value $Build($var)
       # need to hide spaces
       if {$var == "TARGET"} {
	   regsub -all " " $value "\\ " value
       }
       if {$var == "FILES"} {
	   set result ""
	   foreach file $value {
	       regsub -all " " $file "\\ " file
	       if {$result != ""} {
		   append result " "
	       }
	       append result $file
	   }
	   set value $result
       }
    } elseif {[info exists Preferences(Build,$Build(PROCESSOR)$var)]} {
        set value [Preference Build $Build(PROCESSOR)$var]
    } else {
        set value [Preference Build $var]
    }
    return $value
}

#
# BuildExecute - execute a command line
#
proc code::BuildExecute {w line info {stdin {}}} {
    variable Build
    variable UI
    variable PreferenceFile

    if {$UI && $info != {}} {
	if {[BuildCancelBox $w $info]} {
	    return
	}
    }

    if {[Preference Build fake]} {
	# just show commands
	CommandAdd $line
	return
    }

    set result ""
    if {$stdin != {}} {
	# send somthing to the program's standard input
        set pipe [open  "| $line" r+]
	puts -nonewline $pipe $stdin
	flush $pipe
    } else {
        set pipe [open  "| $line" r]
    }
    while {![eof $pipe]} {
	# gather program output
	append result [read $pipe]
    }
    if {[catch {close $pipe} msg]} {
	variable BuildActive

	catch {unset BuildActive}
        if {$UI && [Preference Command history]} {
	    CommandAdd $line $result $msg
        }
	if {$result == ""} {
	    # just stderr returned
	    regsub -all {^.*:.*Copyright .* Introl Corp.$} $msg "" msg
	    if {[string equal $msg ""]} {
		# only version info
		return ""
	    }
	    if {!$UI} {
		return [list $line ERROR $msg $PreferenceFile]
	    }
	    return [list ERROR $msg]
	}
	if {!$UI} {
	    return [list $line PROCESS $result $PreferenceFile]
	}
	return [list PROCESS $result]
    }
    if {$UI && [Preference Command history]} {
	CommandAdd $line $result $msg
    }
    return ""
}

#
# BuildIntrolErrors - build an error list from Introl standard error messages
#
proc code::BuildIntrolErrors {output} {
    set result {}
    set originaloutput $output
    set output [split $output "\n"]
    set junk 0
    foreach line $output {
	if {$line == {}} {
	    continue
	}
	set file ""
	set fileend [string first ":" $line]
	while {$fileend != -1 && \
	       [string index $line [expr $fileend + 1]] != " "} {
	    append file [string range $line 0 $fileend]
	    set line [string range $line [expr $fileend + 1] end]
	    set fileend [string first ":" $line]
	}
	if {$fileend == -1} {
	    # can't find the file
	    set junk 1
	    continue
	}
	append file [string range $line 0 [expr $fileend - 1]]
	if {![file exists $file]} {
	    # can't find the file
	    set junk 1
	    continue
	}
	regexp {[ ]*([0-9:.]*)[ ]*([^- ]*)[- ]*(.*)} \
	    [string range $line [expr $fileend + 1] end] \
	    all line warn msg

	if {![info exists files($file)]} {
	    set files($file) [list [list $line $warn $msg]]
	} else {
	    lappend files($file) [list $line $warn $msg]
	}
    }
    if {$junk} {
	# unparsable errors
	return [list $originaloutput {}]
    }
    foreach file [array names files] {
	lappend result [list $file $files($file)]
    }
    return $result
}

#
# BuildLdFile - build a linker command file for the given processor
#
proc code::BuildLdFile {proc} {
    global code::Build

    # get the memory map
    set memory [ConfigureGetMap Default $proc]
    if {![Preference System definestartup] && [Preference System definevectors]} {
        set vectors [ConfigureGetValue System vectors $proc]
    } else {
	set vectors {}
    }
    if {![Preference Build ldfile]} {
        set variables [ConfigureGetValue System variables $proc]
    } else {
	set variables {}
    }
    set variant [Preference Build variant]
    if {$variant != {}} {
	# no variant defined
        set modules [Preference Build [Preference Build variant]import]
    } else {
	set modules {}
    }
    foreach "cat elt" [PreferenceSearch Module *] {
	set module [Preference $cat $elt]
	if {$module == {}} {
	    continue
	}
	lappend modules $module
    }
    set extras {}
    set objects {}
    set libraries [Preference Build libraries]

    set result "//
// This linker command file was created by Introl-CODE.
//
"
    # remove startup related modules
    foreach module {stackinit bssinit fbssinit datainit fdatainit load_k interruptinit onexit chipinit} {
        if {![catch {Preference Module $module} symbol] && $symbol != {}} {
	    set modules [lremove $modules $symbol]
	}
    }
    if {$modules != {}} {
        append result "\n// Library modules used by this program\n"
	# check to see which modules are defined
        foreach module $modules {
	    if {[lindex [lindex $module 0] 0] == {}} {
		continue
	    }
	    set name [lindex [lindex $module 0] 0]
	    # we are using this module
	    set havemodule($name) 1
	}
        foreach module $modules {
	    set name [lindex [lindex $module 0] 0]
	    if {$name == {}} {
		continue
	    }
	    set not 0
	    foreach need [lrange [lindex $module 0] 1 end] {
		# check for multiple needs
		set has 0
		foreach one $need {
		    if {[info exists havemodule($one)]} {
		        set has 1
		        break
		    }
		}
		if {!$has} {
		    # doesn't have any
		    set not 1
		    break
		}
	    }
	    if {$not} {
	       # a module needed by this module does not exist
	       continue
	    }
	    foreach "variable value" [lrange $module 1 end] {
                append result "set $variable = $value;\n"
	    }
            append result "import [lindex [lindex $module 0] 0];\n"
        }
    }
    set count 0
    if {$vectors != {}} {
        append result "\n// Definitions of processor vectors\n"

        set vectorsimport [Preference Build vectorsimport]
        if {$vectorsimport == {}} {
            set vectorsimport [Preference Build ${variant}vectorsimport]
            if {$vectorsimport == {}} {
                set vectorsimport "__vectors"
	    }
        } 
        append result "import $vectorsimport;\t// Import the vector table\n"

        foreach "variable value description" $vectors {
            append result "set $variable = $value;\t// $description\n"
	    incr count
        }
        append result "set __VECNUM = $count;\n"
    }

    if {$memory != {}} {
        append result "\n// Program memory groups\n"
	foreach group $memory {
            set name [lindex $group 0]
	    regsub -all " " $name "" Build(GROUP)
            set flags [lindex $group 1]
	    set oldfill $Build(FILL)
	    if {[lsearch -exact $flags fill] == -1} {
		# no fill section wanted
		set Build(FILL) {}
	    }
            set start [lindex $group 2]
            set end [lindex $group 3]
            set sections [lindex $group 4]
	    if {[lindex $flags 0] == "window"} {
		# this is a bank window

		set count [lindex $flags 1]
		set flags [lrange $flags 2 end]
		if {[lindex $flags 0] == "near"} {
		    # this is the near bank
		    append result "set __near_bank = [expr $start >> 16];\n"
		    set flags [lrange $flags 1 end]
		}
		set dorigin [lsearch $flags dorigin]
		if {$dorigin != -1} {
		    # have a dorigin
		    set doriginvalue [lindex $flags [expr $dorigin + 1]]
		    set flags [lreplace $flags $dorigin [expr $dorigin + 1]]
		    set dorigin 1
		} else {
		    set dorigin 0
		}
                append result "window [BuildQuote $name] $flags origin $start maxsize $end-$start;\n\n"
		for {set i 0} {$i < $count} {incr i} {
		    set Build(PAGE) .page$i
                    append result "group [BuildQuote $name.page$i] window [BuildQuote $name]"
		    if {$dorigin} {
			append result " dorigin $doriginvalue"
			incr doriginvalue [expr $end - $start]
			set doriginvalue [format 0x%04X $doriginvalue]
		    }
		    append result ";\n"
		    if {$sections == {}} {
			append result "    section [BuildQuote .[string tolower $name$i]];\n"
		    } else {
		        append result [ConfigureTrim [BuildSubstitute $sections] "    "]
		    }
                    append result "group [BuildQuote $name.page$i];\n\n"
		}
	    } else {
		# non-banked group
		if {[lindex $flags 0] == "near"} {
		    # this is the near bank
		    append result "set __near_bank = [expr $start >> 16];\n"
		    set flags [lrange $flags 1 end]
		}
                append result "group [BuildQuote $name] $flags origin $start maxsize $end-$start;\n"
		set sections [string trim $sections]
		if {$sections == {}} {
		    set secname [BuildQuote .[string tolower $name]]
		    append result "    section $secname;\n"
		} else {
		    set Build(PAGE) {}
		    append result [ConfigureTrim [BuildSubstitute $sections] "    "]
		}
                append result "group [BuildQuote $name];\n\n"
	    }
            append result "set [BuildQuote __${name}start] = $start;\n"
            append result "set [BuildQuote __${name}end] = $end;\n"
            append result "set [BuildQuote __${name}size] = $end-$start;\n\n"
	    set Build(FILL) $oldfill
	}
    }

    if {$extras != {}} {
        append result "// Extra sections\n"
	foreach extra $extras {
	    set name [lindex $extra 0]
	    append result "section $name"
	    set flags [lindex $extra 1]
	    if {$flags != {}} {
	        append result " $flags"
	    }
	    append result " origin [lindex $extra 2];\n"
            set size [lindex $extra 3]
	    if {$size != {}} {
		append result "check sizeof($name) > $size fatal \"Section $name too large\";\n"
            }

	}
    }

    if {$variables != {}} {
        append result "\n// Link time variable definitions\n"
	append result $variables
    }
    append result "\n"

    if {$objects == {}} {
        append result "readline;	// Read files from the command line\n"
    } else {
        foreach object $objects {
            append result "'$object'\n"
        }
    }

    if {$libraries != {}} {
        append result "\n// Load libraries\n"
	foreach library $libraries {
	    set library [lindex $library 0]
	    set library [BuildSubstitute $library]
	    if {![string match -* $library]} {
                append result "'$library'\n"
	    } else {
                append result "$library\n"
	    }
	}
    }
    append result "\nend;\n"
    return $result
}
    
#
# BuildQuote - put quotes around a name with spaces in it
#
proc code::BuildQuote {name} {
    if {[string first " " $name] != -1} {
	set name \"$name\"
    }
    return $name
}

#
# lremove - remove items from a list
# OPTS:	-all	remove all instances of each item
# ARGS:	l	a list to remove items from
#	args	items to remove
#
proc code::lremove {args} {
  set all 0
  if [string match \-a* [lindex $args 0]] {
    set all 1
    set args [lreplace $args 0 0]
  }
  set l [lindex $args 0]
  set is [lreplace $args 0 0]
  foreach i $is {
    if {[set ix [lsearch -exact $l $i]] == -1} continue
    set l [lreplace $l $ix $ix]
    if $all {
      while {[set ix [lsearch -exact $l $i]] != -1} {
	set l [lreplace $l $ix $ix]
      }
    }
  }
  return $l
}

