#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/CREX.ui
#   root     is the parent window for this user interface

proc CREX_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#6 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#9 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#7

	frame $base.frame#10

	frame $base.frame#8

	checkbutton $base.checkbuttonUseCREX \
		-command CREXSave \
		-offvalue {} \
		-onvalue __crex \
		-text {Use CREX} \
		-variable CREX(crex)

	checkbutton $base.checkbuttonTimeout \
		-command CREXSave \
		-offvalue {} \
		-onvalue __cxtimeout \
		-text {Use the timeout module} \
		-variable CREX(cxtimeout)

	checkbutton $base.checkbuttonClock \
		-command CREXSave \
		-offvalue {} \
		-onvalue __cxclock \
		-state active \
		-text { Use the clock module} \
		-variable CREX(cxclock)

	label $base.labelPreallocated \
		-text Preallocated:

	entry $base.entryPreallocated \
		-textvariable CREX(CX_TIMEOUTS) \
		-width 6

	label $base.labelTicks \
		-text {Ticks/Time slice:}

	entry $base.entryTicks \
		-cursor {} \
		-textvariable CREX(CX_TICK) \
		-width 6


	# Geometry management

	grid $base.frame#6 -in $root	-row 2 -column 1  \
		-sticky n
	grid $base.frame#9 -in $root	-row 2 -column 2  \
		-sticky n
	grid $base.frame#7 -in $base.frame#6	-row 1 -column 1 
	grid $base.frame#10 -in $base.frame#9	-row 2 -column 1  \
		-sticky e
	grid $base.frame#8 -in $base.frame#7	-row 2 -column 1  \
		-sticky e
	grid $base.checkbuttonUseCREX -in $root	-row 1 -column 1  \
		-sticky w
	grid $base.checkbuttonTimeout -in $base.frame#9	-row 1 -column 1  \
		-sticky w
	grid $base.checkbuttonClock -in $base.frame#7	-row 1 -column 1  \
		-sticky w
	grid $base.labelPreallocated -in $base.frame#10	-row 1 -column 1 
	grid $base.entryPreallocated -in $base.frame#10	-row 1 -column 2 
	grid $base.labelTicks -in $base.frame#8	-row 1 -column 1 
	grid $base.entryTicks -in $base.frame#8	-row 1 -column 2 

	# Resize behavior management

	grid rowconfigure $base.frame#6 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#7 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#7 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#8 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#8 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#8 2 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 0 -minsize 30
	grid rowconfigure $root 3 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 1 -minsize 30

	grid rowconfigure $base.frame#9 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#9 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#9 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#10 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#10 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#10 2 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
 
    proc ::CREXSave {} {}
    return
}

set w [lindex $args 0]

global CREX
set CREX(crex) [code::Preference Module crex]
set m [code::Preference Module cxclock]
set CREX(cxclock) [lindex [lindex $m 0] 0]
foreach "name value" [lrange $m 1 end] {
    set CREX($name) $value
}
set m [code::Preference Module cxtimeout]
set CREX(cxtimeout) [lindex [lindex $m 0] 0]
foreach "name value" [lrange $m 1 end] {
    set CREX($name) $value
}

code::help $w $base.checkbuttonUseCREX "Use the CREX realtime executive"
code::help $w $base.checkbuttonClock "Use the clock module for timeslicing"
code::help $w $base.labelTicks "The number of RTI interrupts between thread switches"
code::help $w $base.entryTicks "Change the number of RTI interrupts between thread switches"
bind $base.entryTicks <FocusOut> CREXSave
bind $base.entryTicks <Return> CREXSave

code::help $w $base.checkbuttonTimeout "Use the timeout module for time measuring"
code::help $w $base.labelPreallocated "The number of preallocated timeouts"
code::help $w $base.entryPreallocated "Change the number of preallocated timeouts"
bind $base.entryPreallocated <FocusOut> CREXSave
bind $base.entryPreallocated <Return> CREXSave

proc ::CREXSave {} {
    global CREX
    global IO

    set oldm [code::Preference Module cxtimeout]
    set changed 0
    set m [concat [list $CREX(cxtimeout)] [lrange [lindex $oldm 0] 1 end]]
    if {$m != [lindex $oldm 0]} {
        set changed 1
    }
    if {$changed && [lindex $m 0] != {}} {
        set CREX(crex) __crex
        set CREX(cxclock) __cxclock
    }
    set n {}
    foreach "name value" [lrange $oldm 1 end] {
        set newvalue $CREX($name)
        lappend n $name $newvalue
        if {$newvalue != $value} {
            set changed 1
        }
    }
    if {$changed} {
        code::Preference Module cxtimeout [concat [list $m] $n]  1
    }

    set oldm [code::Preference Module cxclock]
    set changed 0
    set m [concat [list $CREX(cxclock)] [lrange [lindex $oldm 0] 1 end]]
    if {$m != [lindex $oldm 0]} {
        set changed 1
    }
    if {$changed && [lindex $m 0] != {}} {
        set CREX(crex) __crex
    }
    set n {}
    foreach "name value" [lrange $oldm 1 end] {
        set newvalue $CREX($name)
        lappend n $name $newvalue
        if {$newvalue != $value} {
            set changed 1
        }
    }
    if {$changed} {
        code::Preference Module cxclock [concat [list $m] $n] 1
    }

    if {$CREX(crex) != [code::Preference Module crex]} {
        code::Preference Module crex $CREX(crex) 1
    }
    if {$CREX(crex) == {} && $IO(Stdioselect) == "__crexio"} {
        set IO(Stdioselect) __serialio
        IOSave
    }
 
}

return "Configure the CREX realtime executive"



# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	CREX_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing CREX_ui"
	    CREX_ui .
	}
    }
}
