#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/CS.ui
#   root     is the parent window for this user interface

proc CS_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#19

	frame $base.frame#25

	frame $base.frame#16

	frame $base.frame#18

	frame $base.frameMode

	frame $base.frameByte

	frame $base.frameRW

	frame $base.frameStrobe

	frame $base.frameSpace

	frame $base.frameIPL

	frame $base.frameDSACK

	frame $base.frameSize

	frame $base.framePinassignment

	label $base.labelNAME \
		-anchor w \
		-justify left \
		-textvariable "SIM($base,NAME)" \
		-width 25

	label $base.labelPinassignment \
		-text {Pin assignment:}

	label $base.labelBaseaddress \
		-text {Base address:}

	entry $base.entryBaseaddress \
		-textvariable "SIM($base,BASEADDRESS)"

	label $base.labelSize \
		-text Size:

	label $base.labelMode \
		-text Mode:

	label $base.labelByte \
		-text Byte:

	label $base.labelRW \
		-text R/W:

	label $base.labelStrobe \
		-text Strobe:

	label $base.labelDSACK \
		-text DSACK:

	label $base.labelSpace \
		-text Space:

	label $base.labelIPL \
		-text {Interrupt priority:}

	checkbutton $base.checkbuttonEnableautovector \
		-text {Enable autovector} \
		-variable "SIM($base,AVEC)"


	# Geometry management

	grid $base.frame#19 -in $root	-row 3 -column 1  \
		-sticky w
	grid $base.frame#25 -in $root	-row 4 -column 1  \
		-sticky w
	grid $base.frame#16 -in $root	-row 1 -column 1  \
		-sticky w
	grid $base.frame#18 -in $root	-row 2 -column 1  \
		-sticky w
	grid $base.frameMode -in $base.frame#19	-row 1 -column 2 
	grid $base.frameByte -in $base.frame#19	-row 1 -column 4 
	grid $base.frameRW -in $base.frame#19	-row 1 -column 6 
	grid $base.frameStrobe -in $base.frame#19	-row 1 -column 8 
	grid $base.frameSpace -in $base.frame#25	-row 1 -column 4 
	grid $base.frameIPL -in $base.frame#25	-row 1 -column 6 
	grid $base.frameDSACK -in $base.frame#25	-row 1 -column 2 
	grid $base.frameSize -in $base.frame#18	-row 1 -column 4 
	grid $base.framePinassignment -in $base.frame#16	-row 1 -column 3 
	grid $base.labelNAME -in $base.frame#16	-row 1 -column 1  \
		-sticky w
	grid $base.labelPinassignment -in $base.frame#16	-row 1 -column 2 
	grid $base.labelBaseaddress -in $base.frame#18	-row 1 -column 1 
	grid $base.entryBaseaddress -in $base.frame#18	-row 1 -column 2 
	grid $base.labelSize -in $base.frame#18	-row 1 -column 3 
	grid $base.labelMode -in $base.frame#19	-row 1 -column 1 
	grid $base.labelByte -in $base.frame#19	-row 1 -column 3 
	grid $base.labelRW -in $base.frame#19	-row 1 -column 5 
	grid $base.labelStrobe -in $base.frame#19	-row 1 -column 7 
	grid $base.labelDSACK -in $base.frame#25	-row 1 -column 1 
	grid $base.labelSpace -in $base.frame#25	-row 1 -column 3 
	grid $base.labelIPL -in $base.frame#25	-row 1 -column 5 
	grid $base.checkbuttonEnableautovector -in $root	-row 5 -column 1  \
		-sticky w

	# Resize behavior management

	grid rowconfigure $base.frame#19 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#19 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#19 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#19 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#19 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#19 5 -weight 0 -minsize 30
	grid columnconfigure $base.frame#19 6 -weight 0 -minsize 30
	grid columnconfigure $base.frame#19 7 -weight 0 -minsize 30
	grid columnconfigure $base.frame#19 8 -weight 0 -minsize 30

	grid rowconfigure $base.frame#16 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#16 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#16 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#16 3 -weight 0 -minsize 30

	grid rowconfigure $base.frame#25 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#25 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#25 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#25 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#25 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#25 5 -weight 0 -minsize 30
	grid columnconfigure $base.frame#25 6 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 0 -minsize 30
	grid rowconfigure $root 3 -weight 0 -minsize 30
	grid rowconfigure $root 4 -weight 0 -minsize 30
	grid rowconfigure $root 5 -weight 0 -minsize 30
	grid rowconfigure $root 6 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 1 -minsize 30

	grid rowconfigure $base.frame#18 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#18 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#18 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#18 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#18 4 -weight 0 -minsize 30
# additional interface code
# a dummy definition until all values are initialized
proc ::CSSave {base} {}

if {$base == {}} {
    # testing
 
    return
}

global SIM
global code::Configure

set w [lindex $args 0]
set title [lindex $args 1]
set SIM($base,NAME) "Chip Select [lindex $title 3]"
#$base.labelNAME config -font [$base.checkbuttonSIMinit cget -font]
set SIM($base,CSPARNAME) [lindex $args 2]
set SIM($base,CSPAROFFSET) [lindex $args 3]
set SIM($base,CSBARNAME) [lindex $args 4]
set SIM($base,CSORNAME) [lindex $args 5]

foreach name "$SIM($base,CSPARNAME) $SIM($base,CSBARNAME) $SIM($base,CSORNAME)" {
    set SIM($name) $Configure(Registers,$name)
    if {$SIM($name) == {}} {
        set SIM($name) 0
    }
}

# get initial values

set index [expr ($SIM($SIM($base,CSPARNAME)) >> $SIM($base,CSPAROFFSET)) & 3]
set list {
    "Discrete Output" "Alternate Function"
    "8-bit Chip Select" "16-bit Chip Select"
}
set SIM($base,PAR) [lindex $list $index]
combobox $base.framePinassignment.combo \
    -maxheight 0 \
    -textvariable SIM($base,PAR) \
    -width 18 \
    -editable false \
    -command "CSSave $base; #"

grid $base.framePinassignment.combo -in $base.framePinassignment
foreach number $list {
    $base.framePinassignment.combo list insert end $number
}
code::help $w $base.framePinassignment.combo "Assignment of the chip select pin"
code::help $w $base.labelPinassignment "Assignment of the chip select pin"

set SIM($base,BASEADDRESS) [format 0x%08X \
    [expr ($SIM($SIM($base,CSBARNAME))  & ~7) << 8]]
code::help $w $base.entryBaseaddress "Base address of the selected area"
code::help $w $base.labelBaseaddress "Base address of the selected area"

set index [expr $SIM($SIM($base,CSBARNAME))  & 7]
set list {
    2K 8K 16K 64K 128K 256K 512K 1M
}
set SIM($base,SIZE) [lindex $list $index]
combobox $base.frameSize.combo \
    -maxheight 0 \
    -textvariable SIM($base,SIZE) \
    -width 4 \
    -editable false \
    -command "CSSave $base; #"

grid $base.frameSize.combo -in $base.frameSize
foreach number $list {
    $base.frameSize.combo list insert end $number
}
code::help $w $base.frameSize.combo "Block size of the selected area"
code::help $w $base.labelSize "Block size of the selected area"

set index [expr ($SIM($SIM($base,CSORNAME))  >> 15) & 1]
set list {
    Asynchronous Synchronous
}
set SIM($base,MODE) [lindex $list $index]
combobox $base.frameMode.combo \
    -maxheight 0 \
    -textvariable SIM($base,MODE) \
    -width 12 \
    -editable false \
    -command "CSSave $base; #"

grid $base.frameMode.combo -in $base.frameMode
foreach number $list {
    $base.frameMode.combo list insert end $number
}
code::help $w $base.frameMode.combo "Asynchronous/synchronous mode"
code::help $w $base.labelMode "Asynchronous/synchronous mode"

set index [expr ($SIM($SIM($base,CSORNAME))  >> 13) & 3]
set list {
    Disable Lower Upper Both
}
set SIM($base,BYTE) [lindex $list $index]
combobox $base.frameByte.combo \
    -maxheight 0 \
    -textvariable SIM($base,BYTE) \
    -width 7 \
    -editable false \
    -command "CSSave $base; #"

grid $base.frameByte.combo -in $base.frameByte
foreach number $list {
    $base.frameByte.combo list insert end $number
}
code::help $w $base.frameByte.combo "The upper/lower byte option"
code::help $w $base.labelByte "The upper/lower byte option"

set index [expr ($SIM($SIM($base,CSORNAME))  >> 11) & 3]
set list {
    Reserved Read Write Both
}
set SIM($base,RW) [lindex $list $index]
combobox $base.frameRW.combo \
    -maxheight 0 \
    -textvariable SIM($base,RW) \
    -width 8 \
    -editable false \
    -command "CSSave $base; #"

grid $base.frameRW.combo -in $base.frameRW
foreach number $list {
    $base.frameRW.combo list insert end $number
}
code::help $w $base.frameRW.combo "Read/write strobe control"
code::help $w $base.labelRW "Read/write strobe control"

set index [expr ($SIM($SIM($base,CSORNAME))  >> 10) & 1]
set list {
    Address Data
}
set SIM($base,STROBE) [lindex $list $index]
combobox $base.frameStrobe.combo \
    -maxheight 0 \
    -textvariable SIM($base,STROBE) \
    -width 7 \
    -editable false \
    -command "CSSave $base; #"

grid $base.frameStrobe.combo -in $base.frameStrobe
foreach number $list {
    $base.frameStrobe.combo list insert end $number
}
code::help $w $base.frameStrobe.combo "Address/data stobe control"
code::help $w $base.labelStrobe "Address/data strobe control"

set index [expr ($SIM($SIM($base,CSORNAME))  >> 6) & 15]
set list {
    "0 wait" "1 wait" "2 wait" "3 wait" "4 wait" "5 wait"
    "6 wait" "7 wait" "8 wait" "9 wait" "10 wait" "11 wait"
    "12 wait" "13 wait" "Fast termination" "External"  
}
set SIM($base,DSACK) [lindex $list $index]
combobox $base.frameDSACK.combo \
    -maxheight 0 \
    -textvariable SIM($base,DSACK) \
    -width 14 \
    -editable false \
    -command "CSSave $base; #"

grid $base.frameDSACK.combo -in $base.frameDSACK
foreach number $list {
    $base.frameDSACK.combo list insert end $number
}
code::help $w $base.frameDSACK.combo "Data strobe acknowledge and wait states"
code::help $w $base.labelDSACK "Data strobe acknowledge and wait states"

set index [expr ($SIM($SIM($base,CSORNAME))  >> 4) & 3]
set list {
     "CPU" "User" "Superviser" "Supervise/User" 
}
set SIM($base,SPACE) [lindex $list $index]
combobox $base.frameSpace.combo \
    -maxheight 0 \
    -textvariable SIM($base,SPACE) \
    -width 14 \
    -editable false \
    -command "CSSave $base; #"

grid $base.frameSpace.combo -in $base.frameSpace
foreach number $list {
    $base.frameSpace.combo list insert end $number
}
code::help $w $base.frameSpace.combo "Chip select address space"
code::help $w $base.labelSpace "Chip select address space"

set index [expr ($SIM($SIM($base,CSORNAME))  >> 1) & 7]
set list {
     All 1 2 3 4 5 6 7
}
set SIM($base,IPL) [lindex $list $index]
combobox $base.frameIPL.combo \
    -maxheight 0 \
    -width 3 \
    -textvariable SIM($base,IPL) \
    -editable false \
    -command "CSSave $base; #"

grid $base.frameIPL.combo -in $base.frameIPL
foreach number $list {
    $base.frameIPL.combo list insert end $number
}
code::help $w $base.frameIPL.combo "Interrupt acknowledge priority level"
code::help $w $base.labelIPL "Interrupt acknowledge priority level"

set SIM($base,AVEC) [expr $SIM($SIM($base,CSORNAME)) & 1]

bind $base.entryBaseaddress <FocusOut> "CSSave $base"
bind $base.entryBaseaddress <Return> "CSSave $base"

proc ::CSSave {base} {
    global SIM
    global code::Configure

    set list {
        "Discrete Output" "Alternate Function"
        "8-bit Chip Select" "16-bit Chip Select"
    }
    set index [lsearch $list $SIM($base,PAR)]
    set SIM($SIM($base,CSPARNAME)) [expr $SIM($SIM($base,CSPARNAME)) & ~(3 << $SIM($base,CSPAROFFSET))]
    set SIM($SIM($base,CSPARNAME)) [expr $SIM($SIM($base,CSPARNAME)) | ($index << $SIM($base,CSPAROFFSET))]

    set index [expr $SIM($SIM($base,CSBARNAME))  & 7]
    set list {
        2K 8K 16K 64K 128K 256K 512K 1M
    }
    set size $SIM($base,SIZE)
    switch $size {
        2K { set mask 0xFFF800 }
        8K { set mask 0xFFE000 }
        16K { set mask 0xFFC000 }
        64K { set mask 0xFF0000 }
        128K { set mask 0xFE0000 }
        256K { set mask 0xFC0000 }
        512K { set mask 0xF80000 }
        1M { set mask 0xF00000 }
    }
    if {$SIM($base,BASEADDRESS) & 0xFF000000} {
        tk_messageBox \
            -icon error \
            -parent $base \
            -message "This base address ($SIM($base,BASEADDRESS)) is too large" \
            -type ok
        set SIM($base,BASEADDRESS) [format 0x%08X \
            [expr $SIM($base,BASEADDRESS) & 0x00FFFFFF]]
    }
    if {($SIM($base,BASEADDRESS) & $mask) != \
      $SIM($base,BASEADDRESS)} {
        # low order bits have been lost
        tk_messageBox \
            -icon error \
            -parent $base \
            -message "This base address ($SIM($base,BASEADDRESS)) is invalid for the specified size ($size): low order bits are unused" \
            -type ok
    }
    set SIM($base,BASEADDRESS) [format 0x%08X \
        [expr ($SIM($base,BASEADDRESS) & $mask)]]

    set index [lsearch $list $SIM($base,SIZE)]
    set SIM($SIM($base,CSBARNAME)) [expr ($SIM($base,BASEADDRESS) >> 8) | $index]

    # build up the option register
    set SIM($SIM($base,CSORNAME)) 0

    set list {
        Asynchronous Synchronous
    }
    set index [lsearch $list $SIM($base,MODE)]
    set SIM($SIM($base,CSORNAME)) [expr $SIM($SIM($base,CSORNAME)) | ($index << 15)]
    set list {
        Disable Lower Upper Both
    }
    set index [lsearch $list $SIM($base,BYTE)]
    set SIM($SIM($base,CSORNAME)) [expr $SIM($SIM($base,CSORNAME)) | ($index << 13)]
    set list {
        Reserved Read Write Both
    }
    set index [lsearch $list $SIM($base,RW)]
    set SIM($SIM($base,CSORNAME)) [expr $SIM($SIM($base,CSORNAME)) | ($index << 11)]
    set list {
        Address Data
    }
    set index [lsearch $list $SIM($base,STROBE)]
    set SIM($SIM($base,CSORNAME)) [expr $SIM($SIM($base,CSORNAME)) | ($index << 10)]
    set list {
        "0 wait" "1 wait" "2 wait" "3 wait" "4 wait" "5 wait"
        "6 wait" "7 wait" "8 wait" "9 wait" "10 wait" "11 wait"
        "12 wait" "13 wait" "Fast termination" "External"  
    }
    set index [lsearch $list $SIM($base,DSACK)]
    set SIM($SIM($base,CSORNAME)) [expr $SIM($SIM($base,CSORNAME)) | ($index << 6)]
    set list {
         "CPU" "User" "Superviser" "Supervise/User" 
    }
    set index [lsearch $list $SIM($base,SPACE)]
    set SIM($SIM($base,CSORNAME)) [expr $SIM($SIM($base,CSORNAME)) | ($index << 4)]
    set list {
         All 1 2 3 4 5 6 7
    }
    set index [lsearch $list $SIM($base,IPL)]
    set SIM($SIM($base,CSORNAME)) [expr $SIM($SIM($base,CSORNAME)) | $SIM($base,AVEC)]
    foreach name "$SIM($base,CSPARNAME) $SIM($base,CSBARNAME) $SIM($base,CSORNAME)" {
        if {$SIM($name) != 0 || $Configure(Registers,$name) != {}} {
            code::DdfSetRegister $name SIM($name)
            set Configure(Registers,$name) $SIM($name)
        }
    }
}

CSSave $base
return $title




# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	CS_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing CS_ui"
	    CS_ui .
	}
    }
}
