#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Common/ASoptions/General.ui
#   root     is the parent window for this user interface

proc General_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#1

	checkbutton $base.checkbuttonDEBUG \
		-command "ASGeneralSave $base" \
		-offvalue {} \
		-onvalue -l \
		-text {Generate debug information} \
		-variable "ASGeneral($base,DEBUG)"

	checkbutton $base.checkbuttonNOOPT \
		-command "ASGeneralSave $base" \
		-offvalue {} \
		-onvalue -t \
		-state active \
		-text {Turn off branch optimizer} \
		-variable "ASGeneral($base,NOOPT)"

	checkbutton $base.checkbuttonIMPORT \
		-command "ASGeneralSave $base" \
		-offvalue {} \
		-onvalue -u \
		-text {Import undefined symbols} \
		-variable "ASGeneral($base,IMPORT)"

	checkbutton $base.checkbuttonASLST \
		-command "ASGeneralSave $base" \
		-offvalue -nsr \
		-onvalue {} \
		-text {Generate assembly listing file} \
		-variable "ASGeneral($base,ASLST)"


	# Geometry management

	grid $base.frame#1 -in $root	-row 1 -column 1 
	grid $base.checkbuttonDEBUG -in $base.frame#1	-row 1 -column 1  \
		-sticky w
	grid $base.checkbuttonNOOPT -in $base.frame#1	-row 2 -column 1  \
		-sticky w
	grid $base.checkbuttonIMPORT -in $base.frame#1	-row 3 -column 1  \
		-sticky w
	grid $base.checkbuttonASLST -in $base.frame#1	-row 4 -column 1  \
		-sticky w

	# Resize behavior management

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 1 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    return
}

# get window and options
set w [lindex $args 0]

global ASGeneral
global options

set options($w) [lindex $args 2]
set ASGeneral($base,setfunction) [lindex $args 1]

# get options

foreach var {DEBUG NOOPT IMPORT ASLST} {
    set ASGeneral($base,$var) {}
}

foreach option $options($w) {
    set value {}
    regexp {(-.*)=(.*)} $option all option value
    switch -- $option {
        -l {
            set ASGeneral($base,DEBUG) -l
        }
        -t  {
            set ASGeneral($base,NOOPT) -t
        }
        -u {
            set ASGeneral($base,IMPORT) -u
        }
        -nsr {
            set ASGeneral($base,ASLST) -nsr
        }
    }
}

code::help $w $base.checkbuttonDEBUG "Add information for source level debugging to the object file"
code::help $w $base.checkbuttonNOOPT "Turn off the branch optimizer"
code::help $w $base.checkbuttonIMPORT "Implicitly import undefined symbols"
code::help $w $base.checkbuttonASLST "Generate an assembly language listing"

proc ::ASGeneralSave {base} {
    global ASGeneral
    global options

    set w [winfo toplevel $base]
    foreach "var val" {DEBUG -l NOOPT -t IMPORT -u ASLST -nsr} {
        if {$ASGeneral($base,$var) != ""} {
            # variable is set
            if {[lsearch $options($w) $val] == -1} {

                lappend options($w) $val
            }
        } else {
            # variable is clear
            set options($w) [code::lremove $options($w) $val]
        }
    }
    eval $ASGeneral($base,setfunction) [list $options($w)]    
}        
return "General assembler options"








# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	General_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing General_ui"
	    General_ui .
	}
    }
}
