#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Common/ASoptions/Include.ui
#   root     is the parent window for this user interface

proc Include_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#1

	frame $base.frame#2

	frame $base.frame#4

	frame $base.frame#5

	button $base.buttonADD \
		-command "ASIncludeAdd $base" \
		-text Add:

	entry $base.entryADD

	listbox $base.listboxBEFORE \
		-height 0 \
		-selectmode extended \
		-width 0 \
		-xscrollcommand "$base.scrollbar#2 set" \
		-yscrollcommand "$base.scrollbar#1 set"

	scrollbar $base.scrollbar#1 \
		-command "$base.listboxBEFORE yview" \
		-orient v

	scrollbar $base.scrollbar#2 \
		-command "$base.listboxBEFORE xview" \
		-orient h

	button $base.buttonDELETE \
		-command "ASIncludeDelete $base" \
		-text Delete \
		-width 7

	button $base.buttonEDIT \
		-command "ASIncludeEdit $base" \
		-text Edit \
		-width 7

	button $base.buttonREPLACE \
		-command "ASIncludeReplace $base" \
		-text Replace \
		-width 7

	checkbutton $base.checkbuttonLAST \
		-command "ASIncludeSave $base" \
		-text {Search current directory last} \
		-variable "ASInclude($base,LAST)"


	# Geometry management

	grid $base.frame#1 -in $root	-row 1 -column 1  \
		-sticky nesw
	grid $base.frame#2 -in $base.frame#1	-row 2 -column 1  \
		-sticky nesw
	grid $base.frame#4 -in $base.frame#1	-row 3 -column 1 
	grid $base.frame#5 -in $base.frame#1	-row 1 -column 1  \
		-sticky ew
	grid $base.buttonADD -in $base.frame#5	-row 1 -column 1 
	grid $base.entryADD -in $base.frame#5	-row 1 -column 2  \
		-sticky ew
	grid $base.listboxBEFORE -in $base.frame#2	-row 1 -column 1  \
		-sticky nesw
	grid $base.scrollbar#1 -in $base.frame#2	-row 1 -column 2  \
		-sticky ns
	grid $base.scrollbar#2 -in $base.frame#2	-row 2 -column 1  \
		-sticky ew
	grid $base.buttonDELETE -in $base.frame#4	-row 1 -column 1 
	grid $base.buttonEDIT -in $base.frame#4	-row 1 -column 2 
	grid $base.buttonREPLACE -in $base.frame#4	-row 1 -column 3 
	grid $base.checkbuttonLAST -in $base.frame#1	-row 4 -column 1 

	# Resize behavior management

	grid rowconfigure $base.frame#2 1 -weight 1 -minsize 30
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 1 -weight 1 -minsize 30
	grid columnconfigure $base.frame#2 2 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#4 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 3 -weight 0 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 2 -weight 1 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#5 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 2 -weight 1 -minsize 30
# additional interface code
if {$base == {}} {
    return
}

# get window and options
set w [lindex $args 0]

global ASInclude
global options

set options($w) [lindex $args 2]
set ASInclude($base,setfunction) [lindex $args 1]

# get options

foreach option $options($w) {
    set value {}
    regexp {(-.*)=(.*)} $option all option value
    switch -- $option {
        -yy -
        -y {
            $base.listboxBEFORE insert end $value
            if {$option == "-yy"} {
                set ASInclude($base,LAST) 1
            }
        }
    }
}

code::help $w $base.buttonADD "Add a directory above the selection or at the beginning"
code::help $w $base.entryADD "Enter a directory name to be added"
code::help $w $base.buttonDELETE "Delete the selected directories"
code::help $w $base.buttonEDIT "Edit the selected directory"
code::help $w $base.buttonREPLACE "Replace the selected directory"
code::help $w $base.listboxBEFORE "Include search directories are searched in this order"

global env

set proc [code::Preference Build processor]
set gen [code::Preference Build [set proc]gen]
regsub gen $gen lib lib
$base.listboxBEFORE insert end [file join $env(INTROL) Libraries C]
$base.listboxBEFORE insert end [file join $env(INTROL) Libraries C $lib]
$base.listboxBEFORE insert end [file join $env(INTROL) Libraries Assembly]
$base.listboxBEFORE insert end [file join $env(INTROL) Libraries Assembly $gen]

# Remember the number of fixed directories
set ASInclude($base,directories) [$base.listboxBEFORE index end]

proc ::ASIncludeAdd {base} {
    global ASInclude
    set l $base.listboxBEFORE
    set list [$l curselection]
    if {$list == {}} {
        set index 0
    } else {
        set index [lindex $list 0]
        set last [expr [$l index end] - $ASInclude($base,directories)]
        if {$index > $last} {
            set index $last
        }
    }
    set value [$base.entryADD get]
    if {$value == {}} {
        return
    }
    $l insert $index $value
    ASIncludeSave $base
}

proc ::ASIncludeDelete {base} {
    global ASInclude
    set l $base.listboxBEFORE
    set list [$l curselection]
    set last [expr  [$l index end] - $ASInclude($base,directories)]
    for { set i $last } { $i < [$l index end] } { incr i } {
        # remove fixed directories
        set list [code::lremove $list $i]
    }
    if {$list == {}} {
        return
    }

    eval $l delete [lindex $list 0] [lindex $list end]
    ASIncludeSave $base
}

proc ::ASIncludeEdit {base} {
    global ASInclude
    set l $base.listboxBEFORE
    set list [$l curselection]
    set last [expr  [$l index end] - $ASInclude($base,directories)]
    for { set i $last } { $i < [$l index end] } { incr i } {
        # remove fixed directories
        set list [code::lremove $list $i]
    }
    if {$list == {}} {
        return
    }
    $base.entryADD delete 0 end
    $base.entryADD insert 0 [$l get [lindex $list 0]]
    ASIncludeSave $base
}

proc ::ASIncludeReplace {base} {
    global ASInclude
    set l $base.listboxBEFORE
    set list [$l curselection]
    set last [expr  [$l index end] - $ASInclude($base,directories)]
    for { set i $last } { $i < [$l index end] } { incr i } {
        # remove fixed directories
        set list [code::lremove $list $i]
    }
    if {$list == {}} {
        return
    }
    set value [$base.entryADD get]
    if {$value == {}} {
        return
    }

    set index [lindex $list 0]
    $l delete $index
    $l insert $index $value
    ASIncludeSave $base
}

proc ::ASIncludeSave {base} {
    global ASInclude
    global options

    set w [winfo toplevel $base]
    if {$ASInclude($base,LAST)} {
        set option -yy
    } else {
        set option -y
    }
    while {1} {
        # delete all previous includes
        set index [lsearch $options($w) -y*]
	if {$index != -1} {
            set options($w) [lreplace $options($w) $index $index]
        } else {
            break
        }
    }

    set l $base.listboxBEFORE
    set last [expr [$l index end] - 5]
    if {$last >= 0} {
        # some includes are defined
        foreach include [$l get 0 $last] {
            lappend options($w) $option=$include
        }
    }
    eval $ASInclude($base,setfunction) [list $options($w)]    
}        
return "Include file search paths"










# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Include_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Include_ui"
	    Include_ui .
	}
    }
}
