#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Common/CCoptions/Defines.ui
#   root     is the parent window for this user interface

proc Defines_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#1

	frame $base.frame#2

	frame $base.frame#4

	frame $base.frame#5

	button $base.buttonADD \
		-command "CCDefinesAdd $base" \
		-text Add:

	entry $base.entryADD

	listbox $base.listboxBEFORE \
		-height 0 \
		-selectmode extended \
		-width 0 \
		-xscrollcommand "$base.scrollbar#2 set" \
		-yscrollcommand "$base.scrollbar#1 set"

	scrollbar $base.scrollbar#1 \
		-command "$base.listboxBEFORE yview" \
		-orient v

	scrollbar $base.scrollbar#2 \
		-command "$base.listboxBEFORE xview" \
		-orient h

	button $base.buttonDELETE \
		-command "CCDefinesDelete $base" \
		-text Delete \
		-width 7

	button $base.buttonEDIT \
		-command "CCDefinesEdit $base" \
		-text Edit \
		-width 7

	button $base.buttonREPLACE \
		-command "CCDefinesReplace $base" \
		-text Replace \
		-width 7


	# Geometry management

	grid $base.frame#1 -in $root	-row 1 -column 1  \
		-sticky nesw
	grid $base.frame#2 -in $base.frame#1	-row 2 -column 1  \
		-sticky nesw
	grid $base.frame#4 -in $base.frame#1	-row 3 -column 1 
	grid $base.frame#5 -in $base.frame#1	-row 1 -column 1  \
		-sticky ew
	grid $base.buttonADD -in $base.frame#5	-row 1 -column 1 
	grid $base.entryADD -in $base.frame#5	-row 1 -column 2  \
		-sticky ew
	grid $base.listboxBEFORE -in $base.frame#2	-row 1 -column 1  \
		-sticky nesw
	grid $base.scrollbar#1 -in $base.frame#2	-row 1 -column 2  \
		-sticky ns
	grid $base.scrollbar#2 -in $base.frame#2	-row 2 -column 1  \
		-sticky ew
	grid $base.buttonDELETE -in $base.frame#4	-row 1 -column 1 
	grid $base.buttonEDIT -in $base.frame#4	-row 1 -column 2 
	grid $base.buttonREPLACE -in $base.frame#4	-row 1 -column 3 

	# Resize behavior management

	grid rowconfigure $base.frame#2 1 -weight 1 -minsize 30
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 1 -weight 1 -minsize 30
	grid columnconfigure $base.frame#2 2 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#4 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 3 -weight 0 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 2 -weight 1 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#5 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 2 -weight 1 -minsize 30
# additional interface code
if {$base == {}} {
    return
}

# get window and options

global CCDefines
global options

set w [lindex $args 0]

set options($w) [lindex $args 2]
set CCDefines($base,setfunction) [lindex $args 1]

# get options

foreach option $options($w) {
    switch -glob -- $option {
        -D* {
            set value {}
            regexp {(-D)(.*)} $option all option value
            $base.listboxBEFORE insert end $value
        }
    }
}

code::help $w $base.buttonADD "Add a define"
code::help $w $base.entryADD "Enter a define to be added, NAME{=<optional value>}"
code::help $w $base.buttonDELETE "Delete the selected defines"
code::help $w $base.buttonEDIT "Edit the selected define"
code::help $w $base.buttonREPLACE "Replace the selected define"
code::help $w $base.listboxBEFORE "Defines used during compilation"

proc ::CCDefinesAdd {base} {
    set l $base.listboxBEFORE
    set value [$base.entryADD get]
    if {$value == {}} {
        return
    }
    $l insert end $value
    CCDefinesSave $base
}

proc ::CCDefinesDelete {base} {
    set l $base.listboxBEFORE
    set list [$l curselection]
    if {$list == {}} {
        return
    }

    eval $l delete [lindex $list 0] [lindex $list end]
    CCDefinesSave $base
}

proc ::CCDefinesEdit {base} {
    set l $base.listboxBEFORE
    set list [$l curselection]
    if {$list == {}} {
        return
    }

    $base.entryADD delete 0 end
    $base.entryADD insert 0 [$l get [lindex $list 0]]
    CCDefinesSave $base
}

proc ::CCDefinesReplace {base} {
    set l $base.listboxBEFORE
    set list [$l curselection]
    if {$list == {}} {
        return
    }
    set value [$base.entryADD get]
    if {$value == {}} {
        return
    }

    set index [lindex $list 0]
    $l delete $index
    $l insert $index $value
    CCDefinesSave $base
}

proc ::CCDefinesSave {base} {
    global CCDefines
    global options

    set w [winfo toplevel $base]
    while {1} {
        # delete all previous includes
        set index [lsearch $options($w) -D*]
	if {$index != -1} {
            set options($w) [lreplace $options($w) $index $index]
        } else {
            break
        }
    }

    set l $base.listboxBEFORE
    foreach define [$l get 0 end] {
        lappend options($w) -D$define
    }

    eval $CCDefines($base,setfunction) [list $options($w)]    
}        
return "Preprocessor symbols used during compilation"





# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Defines_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Defines_ui"
	    Defines_ui .
	}
    }
}
