#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Common/CCoptions/General.ui
#   root     is the parent window for this user interface

proc General_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#1

	checkbutton $base.checkbuttonDEBUG \
		-command "CCGeneralSave $base" \
		-offvalue {} \
		-onvalue -g \
		-text {Generate debug information} \
		-variable "General($base,DEBUG)"

	checkbutton $base.checkbuttonWERROR \
		-command "CCGeneralSave $base" \
		-offvalue {} \
		-onvalue -we \
		-state active \
		-text {Make warnings errors} \
		-variable "General($base,WERROR)"

	checkbutton $base.checkbuttonASSRC \
		-command "CCGeneralSave $base" \
		-offvalue {} \
		-onvalue -S \
		-text {Save assembly source} \
		-variable "General($base,ASSRC)"

	checkbutton $base.checkbuttonASLST \
		-command "CCGeneralSave $base" \
		-offvalue {} \
		-onvalue -l \
		-text {Generate assembly listing file} \
		-variable "General($base,ASLST)"


	# Geometry management

	grid $base.frame#1 -in $root	-row 1 -column 1 
	grid $base.checkbuttonDEBUG -in $base.frame#1	-row 1 -column 1  \
		-sticky w
	grid $base.checkbuttonWERROR -in $base.frame#1	-row 2 -column 1  \
		-sticky w
	grid $base.checkbuttonASSRC -in $base.frame#1	-row 3 -column 1  \
		-sticky w
	grid $base.checkbuttonASLST -in $base.frame#1	-row 4 -column 1  \
		-sticky w

	# Resize behavior management

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 1 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    return
}

# get window and options

set w [lindex $args 0]

global General
global options

set options($w) [lindex $args 2]
set General($base,setfunction) [lindex $args 1]

# get options

foreach var {DEBUG WERROR ASSRC ASLST} {
    set  General($base,$var) {}
}

foreach option $options($w) {
    set value {}
    regexp {(-.*)=(.*)} $option all option value
    switch -- $option {
        -g {
            set General($base,DEBUG) -g
        }
        -S  {
            set General($base,ASSRC) -S
        }
        -l {
            set General($base,ASLST) -l
        }
        -we {
            set General($base,WERROR) -we
        }
    }
}

code::help $w $base.checkbuttonDEBUG "Add information for source level debugging to the object file"
code::help $w $base.checkbuttonWERROR "Treat compiler warnings as errors"
code::help $w $base.checkbuttonASSRC "Save assembly language source file generated by the compiler"
code::help $w $base.checkbuttonASLST "Generate assembly language listing file"

proc ::CCGeneralSave {base} {
    global General
    global options

    set w [winfo toplevel $base]
    foreach "var val" {DEBUG -g WERROR -we ASSRC -S ASLST -l} {

        if {$General($base,$var) != ""} {
            # variable is set
            if {[lsearch $options($w) $val] == -1} {

                lappend options($w) $val
            }
        } else {
            # variable is clear
            set options($w) [code::lremove $options($w) $val]
        }
    }
    eval $General($base,setfunction) [list $options($w)]    
}        
return "General C compiler options"







# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	General_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing General_ui"
	    General_ui .
	}
    }
}
