#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Common/CCoptions/Include.ui
#   root     is the parent window for this user interface

proc Include_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#1

	frame $base.frame#2

	frame $base.frame#4

	frame $base.frame#5

	button $base.buttonADD \
		-command "CCIncludeAdd $base" \
		-text Add:

	entry $base.entryADD

	listbox $base.listboxBEFORE \
		-height 0 \
		-selectmode extended \
		-width 0 \
		-xscrollcommand "$base.scrollbar#2 set" \
		-yscrollcommand "$base.scrollbar#1 set"

	scrollbar $base.scrollbar#1 \
		-command "$base.listboxBEFORE yview" \
		-orient v

	scrollbar $base.scrollbar#2 \
		-command "$base.listboxBEFORE xview" \
		-orient h

	button $base.buttonDELETE \
		-command "CCIncludeDelete $base" \
		-text Delete \
		-width 7

	button $base.buttonEDIT \
		-command "CCIncludeEdit $base" \
		-text Edit \
		-width 7

	button $base.buttonREPLACE \
		-command "CCIncludeReplace $base" \
		-text Replace \
		-width 7

	checkbutton $base.checkbuttonLAST \
		-command "CCIncludeSave $base" \
		-text {Search current directory last} \
		-variable "Include($base,LAST)"


	# Geometry management

	grid $base.frame#1 -in $root	-row 1 -column 1  \
		-sticky nesw
	grid $base.frame#2 -in $base.frame#1	-row 2 -column 1  \
		-sticky nesw
	grid $base.frame#4 -in $base.frame#1	-row 3 -column 1 
	grid $base.frame#5 -in $base.frame#1	-row 1 -column 1  \
		-sticky ew
	grid $base.buttonADD -in $base.frame#5	-row 1 -column 1 
	grid $base.entryADD -in $base.frame#5	-row 1 -column 2  \
		-sticky ew
	grid $base.listboxBEFORE -in $base.frame#2	-row 1 -column 1  \
		-sticky nesw
	grid $base.scrollbar#1 -in $base.frame#2	-row 1 -column 2  \
		-sticky ns
	grid $base.scrollbar#2 -in $base.frame#2	-row 2 -column 1  \
		-sticky ew
	grid $base.buttonDELETE -in $base.frame#4	-row 1 -column 1 
	grid $base.buttonEDIT -in $base.frame#4	-row 1 -column 2 
	grid $base.buttonREPLACE -in $base.frame#4	-row 1 -column 3 
	grid $base.checkbuttonLAST -in $base.frame#1	-row 4 -column 1 

	# Resize behavior management

	grid rowconfigure $base.frame#2 1 -weight 1 -minsize 30
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 1 -weight 1 -minsize 30
	grid columnconfigure $base.frame#2 2 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#4 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 3 -weight 0 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 2 -weight 1 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#5 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 2 -weight 1 -minsize 30
# additional interface code
if {$base == {}} {
    return
}

# get window and options
variable w [lindex $args 0]

global Include
global options

set options($w) [lindex $args 2]
set Include($base,setfunction) [lindex $args 1]

# get options

foreach option $options($w) {
    set value {}
    regexp {(-.*)=(.*)} $option all option value
    switch -- $option {
        -ii -
        -i {
            $base.listboxBEFORE insert end $value
            if {$option == "-ii"} {
                set Include($base,LAST) 1
            }
        }
    }
}

code::help $w $base.buttonADD "Add a directory above the selection or at the beginning"
code::help $w $base.entryADD "Enter a directory name to be added"
code::help $w $base.buttonDELETE "Delete the selected directories"
code::help $w $base.buttonEDIT "Edit the selected directory"
code::help $w $base.buttonREPLACE "Replace the selected directory"
code::help $w $base.listboxBEFORE "Include search directories are searched in this order"

global env
$base.listboxBEFORE insert end [file join $env(INTROL) include]

proc ::CCIncludeAdd {base} {
    set l $base.listboxBEFORE
    set list [$l curselection]
    if {$list == {}} {
        set index 0
    } else {
        set index [lindex $list 0]
    }
    set value [$base.entryADD get]
    if {$value == {}} {
        return
    }
    $l insert $index $value
    CCIncludeSave $base
}

proc ::CCIncludeDelete {base} {
    set l $base.listboxBEFORE
    set list [$l curselection]
    set last [expr [$l index end] - 1]
    set list [code::lremove $list $last]
    if {$list == {}} {
        return
    }

    eval $l delete [lindex $list 0] [lindex $list end]
    CCIncludeSave $base
}

proc ::CCIncludeEdit {base} {
    set l $base.listboxBEFORE
    set list [$l curselection]
    set last [expr [$l index end] - 1]
    set list [code::lremove $list $last]
    if {$list == {}} {
        return
    }

    $base.entryADD delete 0 end
    $base.entryADD insert 0 [$l get [lindex $list 0]]
    CCIncludeSave $base
}

proc ::CCIncludeReplace {base} {
    set l $base.listboxBEFORE
    set list [$l curselection]
    set last [expr [$l index end] - 1]
    set list [code::lremove $list $last]
    if {$list == {}} {
        return
    }
    set value [$base.entryADD get]
    if {$value == {}} {
        return
    }

    set index [lindex $list 0]
    $l delete $index
    $l insert $index $value
    CCIncludeSave $base
}

proc ::CCIncludeSave {base} {
    global Include
    global options

    set w [winfo toplevel $base]
    if {$Include($base,LAST)} {
        set option -ii
    } else {
        set option -i
    }
    while {1} {
        # delete all previous includes
        set index [lsearch $options($w) -i*]
	if {$index != -1} {
            set options($w) [lreplace $options($w) $index $index]
        } else {
            break
        }
    }

    set l $base.listboxBEFORE
    set last [expr [$l index end] - 2]
    if {$last >= 0} {
        # some includes are defined
        foreach include [$l get 0 $last] {
            lappend options($w) $option=$include
        }
    }
    eval $Include($base,setfunction) [list $options($w)]    
}        
return "Include file search paths"







# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Include_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Include_ui"
	    Include_ui .
	}
    }
}
