#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Common/LDoptions/General.ui
#   root     is the parent window for this user interface

proc General_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#1

	checkbutton $base.checkbuttonNODORIGIN \
		-command "LDGeneralSave $base" \
		-offvalue {} \
		-onvalue -D \
		-text {Disable device origins} \
		-variable "LDGeneral($base,NODORIGIN)"

	checkbutton $base.checkbuttonNOWARN \
		-command "LDGeneralSave $base" \
		-offvalue {} \
		-onvalue -w \
		-state active \
		-text {Inhibit warnings} \
		-variable "LDGeneral($base,NOWARN)"

	checkbutton $base.checkbuttonFORCE \
		-command "LDGeneralSave $base" \
		-offvalue {} \
		-onvalue -x \
		-text {Force link} \
		-variable "LDGeneral($base,FORCE)"


	# Geometry management

	grid $base.frame#1 -in $root	-row 1 -column 1 
	grid $base.checkbuttonNODORIGIN -in $base.frame#1	-row 1 -column 1  \
		-sticky w
	grid $base.checkbuttonNOWARN -in $base.frame#1	-row 2 -column 1  \
		-sticky w
	grid $base.checkbuttonFORCE -in $base.frame#1	-row 3 -column 1  \
		-sticky w

	# Resize behavior management

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 1 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    return
}

# get window and options
set w [lindex $args 0]

global LDGeneral
global options
set options($w) [lindex $args 2]

set LDGeneral($base,setfunction) [lindex $args 1]

# get options

foreach option $options($w) {
    set value {}
    regexp {(-.*)=(.*)} $option all option value
    switch -- $option {
        -w {
            set LDGeneral($base,NOWARN) -w
        }
        -x  {
            set LDGeneral($base,FORCE) -x
        }
        -D {
            set LDGeneral($base,NODORIGIN) -D
        }
    }
}

code::help $w $base.checkbuttonNOWARN "Don't warn about truncated relocation values"
code::help $w $base.checkbuttonFORCE "Link the program even if there are unresolved references"
code::help $w $base.checkbuttonNODORIGIN "Ignore dorigin directives in the linker command file"

proc ::LDGeneralSave {base} {
    global LDGeneral
    global options

    set w [winfo toplevel $base]
    foreach "var val" {NOWARN -w FORCE -x NODORIGIN -D} {

        if {$LDGeneral($base,$var) != ""} {
            # variable is set
            if {[lsearch $options($w) $val] == -1} {

                lappend options($w) $val
            }
        } else {
            # variable is clear
            set options($w) [code::lremove $options($w) $val]
        }
    }
    eval $LDGeneral($base,setfunction) [list $options($w)]    
}        
return "General linker options"







# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	General_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing General_ui"
	    General_ui .
	}
    }
}
