#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/IO.ui
#   root     is the parent window for this user interface

proc IO_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#20

	frame $base.frameCombo

	frame $base.frame#11

	frame $base.frame#12 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#19

	frame $base.frame#13

	frame $base.frame#14

	frame $base.frame#15

	frame $base.frame#16

	frame $base.frame#17

	checkbutton $base.checkbuttonDefineIO \
		-command IOSave \
		-text {Define IO devices} \
		-variable code::Configure(System,defineio)

	label $base.labelPredefined \
		-text {Use predefined device:}

	label $base.labelTotal \
		-text {Total Devices Defined:}

	label $base.labelCount \
		-textvariable IO(devcount)

	label $base.labelNumber \
		-text {Device #:}

	label $base.labelDevice \
		-textvariable IO(device)

	entry $base.entryTitle \
		-textvariable IO(title)

	label $base.labelName \
		-text Name

	entry $base.entryName \
		-textvariable IO(name)

	label $base.labelIs \
		-text {Device is:}

	checkbutton $base.checkbuttonStdin \
		-command IOSave \
		-text stdin \
		-variable IO(stdin)

	checkbutton $base.checkbuttonStdout \
		-command IOSave \
		-text stdout \
		-variable IO(stdout)

	checkbutton $base.checkbuttonStderr \
		-command IOSave \
		-text stderr \
		-variable IO(stderr)

	label $base.labelMode \
		-text {Device mode:}

	checkbutton $base.checkbuttonRead \
		-command IOSave \
		-maskvalue 1 \
		-text Read \
		-variable IO(mode)

	checkbutton $base.checkbuttonWrite \
		-command IOSave \
		-maskvalue 2 \
		-onvalue 2 \
		-text Write \
		-variable IO(mode)

	checkbutton $base.checkbuttonBinary \
		-command IOSave \
		-maskvalue 16 \
		-onvalue 16 \
		-text Binary \
		-variable IO(mode)

	label $base.labelFlags \
		-text {Device flags:}

	checkbutton $base.checkbuttonEcho \
		-command IOSave \
		-maskvalue 1 \
		-text Echo \
		-variable IO(flags)

	checkbutton $base.checkbuttonBuffered \
		-command IOSave \
		-maskvalue 2 \
		-onvalue 2 \
		-text Buffered \
		-variable IO(flags)

	checkbutton $base.checkbuttonICRNL \
		-command IOSave \
		-maskvalue 4 \
		-onvalue 4 \
		-text ICRNL \
		-variable IO(flags)

	checkbutton $base.checkbuttonONLCR \
		-command IOSave \
		-maskvalue 8 \
		-onvalue 8 \
		-text ONLCR \
		-variable IO(flags)

	checkbutton $base.checkbuttonBSERASE \
		-command IOSave \
		-maskvalue 16 \
		-onvalue 16 \
		-text BSERASE \
		-variable IO(flags)

	label $base.labelDelete \
		-text Delete:

	entry $base.entryDelete \
		-textvariable IO(delete) \
		-width 5

	label $base.labelKill \
		-text {Line Kill:}

	entry $base.entryKill \
		-textvariable IO(kill) \
		-width 5

	checkbutton $base.checkbuttonBufsize \
		-command {IOallocate 1} \
		-text {Allocate static buffer:} \
		-variable IO(allocate)

	entry $base.entryBufsize \
		-textvariable IO(bufsize) \
		-width 10

	label $base.labelOpen \
		-text Open

	label $base.labelClose \
		-text Close

	label $base.labelRead \
		-text Read

	label $base.labelWrite \
		-text Write

	label $base.labelIoctl \
		-text Ioctl

	entry $base.entryOpen \
		-textvariable IO(open) \
		-width 15

	entry $base.entryClose \
		-textvariable IO(close) \
		-width 15

	entry $base.entryRead \
		-textvariable IO(read) \
		-width 15

	entry $base.entryWrite \
		-textvariable IO(write) \
		-width 15

	entry $base.entryIoctl \
		-textvariable IO(ioctl) \
		-width 15

	button $base.buttonPrevious \
		-command IOPrev \
		-text Previous

	button $base.buttonNext \
		-command IONext \
		-text Next

	button $base.buttonDelete \
		-command IODelete \
		-text Delete


	# Geometry management

	grid $base.frame#20 -in $root	-row 2 -column 1  \
		-columnspan 2 \
		-sticky w
	grid $base.frameCombo -in $root	-row 1 -column 4 
	grid $base.frame#11 -in $root	-row 4 -column 1  \
		-columnspan 4 \
		-sticky ew
	grid $base.frame#12 -in $root	-row 3 -column 1  \
		-columnspan 4 \
		-sticky ew
	grid $base.frame#19 -in $base.frame#12	-row 5 -column 1  \
		-sticky w
	grid $base.frame#13 -in $base.frame#12	-row 1 -column 1  \
		-sticky ew
	grid $base.frame#14 -in $base.frame#12	-row 2 -column 1  \
		-sticky w
	grid $base.frame#15 -in $base.frame#12	-row 3 -column 1  \
		-sticky w
	grid $base.frame#16 -in $base.frame#12	-row 4 -column 1  \
		-sticky w
	grid $base.frame#17 -in $base.frame#12	-row 6 -column 1  \
		-sticky w
	grid $base.checkbuttonDefineIO -in $root	-row 1 -column 1  \
		-sticky w
	grid $base.labelPredefined -in $root	-row 1 -column 3 
	grid $base.labelTotal -in $base.frame#20	-row 1 -column 1 
	grid $base.labelCount -in $base.frame#20	-row 1 -column 2 
	grid $base.labelNumber -in $base.frame#13	-row 1 -column 1 
	grid $base.labelDevice -in $base.frame#13	-row 1 -column 2 
	grid $base.entryTitle -in $base.frame#13	-row 1 -column 3  \
		-sticky ew
	grid $base.labelName -in $base.frame#13	-row 1 -column 4 
	grid $base.entryName -in $base.frame#13	-row 1 -column 5 
	grid $base.labelIs -in $base.frame#14	-row 1 -column 1 
	grid $base.checkbuttonStdin -in $base.frame#14	-row 1 -column 2 
	grid $base.checkbuttonStdout -in $base.frame#14	-row 1 -column 3 
	grid $base.checkbuttonStderr -in $base.frame#14	-row 1 -column 4 
	grid $base.labelMode -in $base.frame#15	-row 1 -column 1 
	grid $base.checkbuttonRead -in $base.frame#15	-row 1 -column 2 
	grid $base.checkbuttonWrite -in $base.frame#15	-row 1 -column 3 
	grid $base.checkbuttonBinary -in $base.frame#15	-row 1 -column 4 
	grid $base.labelFlags -in $base.frame#16	-row 1 -column 1 
	grid $base.checkbuttonEcho -in $base.frame#16	-row 1 -column 2 
	grid $base.checkbuttonBuffered -in $base.frame#16	-row 1 -column 3 
	grid $base.checkbuttonICRNL -in $base.frame#16	-row 1 -column 4 
	grid $base.checkbuttonONLCR -in $base.frame#16	-row 1 -column 5 
	grid $base.checkbuttonBSERASE -in $base.frame#16	-row 1 -column 6 
	grid $base.labelDelete -in $base.frame#19	-row 1 -column 1 
	grid $base.entryDelete -in $base.frame#19	-row 1 -column 2 
	grid $base.labelKill -in $base.frame#19	-row 1 -column 4 
	grid $base.entryKill -in $base.frame#19	-row 1 -column 5 
	grid $base.checkbuttonBufsize -in $base.frame#19	-row 1 -column 7 
	grid $base.entryBufsize -in $base.frame#19	-row 1 -column 8 
	grid $base.labelOpen -in $base.frame#17	-row 1 -column 1 
	grid $base.labelClose -in $base.frame#17	-row 1 -column 2 
	grid $base.labelRead -in $base.frame#17	-row 1 -column 3 
	grid $base.labelWrite -in $base.frame#17	-row 1 -column 4 
	grid $base.labelIoctl -in $base.frame#17	-row 1 -column 5 
	grid $base.entryOpen -in $base.frame#17	-row 2 -column 1 
	grid $base.entryClose -in $base.frame#17	-row 2 -column 2 
	grid $base.entryRead -in $base.frame#17	-row 2 -column 3 
	grid $base.entryWrite -in $base.frame#17	-row 2 -column 4 
	grid $base.entryIoctl -in $base.frame#17	-row 2 -column 5 
	grid $base.buttonPrevious -in $base.frame#11	-row 1 -column 1 
	grid $base.buttonNext -in $base.frame#11	-row 1 -column 2 
	grid $base.buttonDelete -in $base.frame#11	-row 1 -column 4 

	# Resize behavior management

	grid rowconfigure $base.frame#20 1 -weight 0 -minsize 6
	grid columnconfigure $base.frame#20 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#20 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#19 1 -weight 0 -minsize 2
	grid columnconfigure $base.frame#19 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#19 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#19 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#19 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#19 5 -weight 0 -minsize 30
	grid columnconfigure $base.frame#19 6 -weight 0 -minsize 30
	grid columnconfigure $base.frame#19 7 -weight 0 -minsize 30
	grid columnconfigure $base.frame#19 8 -weight 0 -minsize 30

	grid rowconfigure $base.frame#15 1 -weight 0 -minsize 2
	grid columnconfigure $base.frame#15 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#15 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#15 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#15 4 -weight 0 -minsize 30

	grid rowconfigure $base.frame#11 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#11 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#11 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#11 3 -weight 1 -minsize 30
	grid columnconfigure $base.frame#11 4 -weight 0 -minsize 30

	grid rowconfigure $base.frame#16 1 -weight 0 -minsize 4
	grid columnconfigure $base.frame#16 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#16 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#16 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#16 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#16 5 -weight 0 -minsize 30
	grid columnconfigure $base.frame#16 6 -weight 0 -minsize 30

	grid rowconfigure $base.frame#12 1 -weight 0 -minsize 13
	grid rowconfigure $base.frame#12 2 -weight 0 -minsize 2
	grid rowconfigure $base.frame#12 3 -weight 0 -minsize 13
	grid rowconfigure $base.frame#12 4 -weight 0 -minsize 5
	grid rowconfigure $base.frame#12 5 -weight 0 -minsize 2
	grid rowconfigure $base.frame#12 6 -weight 0 -minsize 30
	grid columnconfigure $base.frame#12 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#17 1 -weight 0 -minsize 2
	grid rowconfigure $base.frame#17 2 -weight 0 -minsize 2
	grid columnconfigure $base.frame#17 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#17 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#17 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#17 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#17 5 -weight 0 -minsize 30

	grid rowconfigure $base.frame#13 1 -weight 0 -minsize 16
	grid columnconfigure $base.frame#13 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#13 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#13 3 -weight 1 -minsize 30
	grid columnconfigure $base.frame#13 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#13 5 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 20
	grid rowconfigure $root 2 -weight 0 -minsize 7
	grid rowconfigure $root 3 -weight 1 -minsize 30
	grid rowconfigure $root 4 -weight 0 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 88
	grid columnconfigure $root 2 -weight 1 -minsize 30
	grid columnconfigure $root 3 -weight 0 -minsize 30
	grid columnconfigure $root 4 -weight 0 -minsize 30

	grid rowconfigure $base.frame#14 1 -weight 0 -minsize 2
	grid columnconfigure $base.frame#14 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#14 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#14 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#14 4 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
    proc ::IOSave {} {}
    return
}

set w [lindex $args 0]
global IO
global code::Configure

# get the list of valid devices
set devlist [lindex $args 1]
set IO(devlist) $devlist
# get the current device table
set IO(devtab) [lindex $args 2]
set IO(base) $base
set code::Configure(System,defineio) [code::Preference System defineio]
set IO(stdin) [code::Preference System devstdin]
set IO(stdout) [code::Preference System devstdout]
set IO(stderr) [code::Preference System devstderr]

# get a device count
set IO(devcount) 0
foreach one $IO(devtab) {
    incr IO(devcount)
}

# set up the values when a device changes
proc ::IOSet {} {
    global IO

    set dev $IO(device)
    $IO(base).checkbuttonStdin config -onvalue $dev
    $IO(base).checkbuttonStdout config -onvalue $dev
    $IO(base).checkbuttonStderr config -onvalue $dev
    set first [lindex $IO(devtab) $dev]
    set IO(name) [lindex $first 0]
    set IO(mode) [lindex $first 1]
    if {$IO(mode) == {}} {
        set IO(mode) 0
    }
    set IO(flags) [lindex $first 2]
    if {$IO(flags) == {}} {
        set IO(flags) 0
    }
    set IO(delete) [lindex $first 3]
    set IO(kill) [lindex $first 4]
    set IO(open) [lindex $first 5]
    set IO(close) [lindex $first 6]
    set IO(read) [lindex $first 7]
    set IO(write) [lindex $first 8]
    set IO(ioctl) [lindex $first 9]
    set IO(title) [lindex $first 10]
    set IO(bufsize) [lindex $first 11]
    set IO(allocate) [expr {[string compare $IO(bufsize) {}] != 0}]
    if {$dev == $IO(stdin) && \
        !$IO(allocate) && ($IO(flags) & 2)} {
        # this is buffered stdin
        IOSave
    }
}

proc ::IOPrev {} {
    global IO

    if {$IO(device) >= 1} {
        incr IO(device) -1
        $IO(base).buttonNext config -state normal
    }
    if {$IO(device) == 0} {
        $IO(base).buttonPrevious config -state disabled
    }
    IOSet
}

proc ::IONext {} {
    global IO

    incr IO(device)
    IOSet
    if {$IO(device) == $IO(devcount)} {
        # only allow one device to be added at a time
        $IO(base).buttonNext config -state disabled
    }
    $IO(base).buttonPrevious config -state normal
}

# disable the Previous button
$IO(base).buttonPrevious config -state disabled

code::help $w $base.checkbuttonDefineIO "Define the I/O device table in the generated startup code"

proc ::IOSave {{force 0}} {
    global IO
    global code::Configure

    set append 0
    # a change has been made. Deal with it
    if {$IO(device) == $IO(devcount)} {
        incr IO(devcount)
        if {$IO(name) != {}} {
            $IO(base).buttonNext config -state normal
        }
        set append 1
    }
    if {$IO(device) == $IO(stdin) && \
        !$IO(allocate) && ($IO(flags) & 2)} {
        # this is buffered stdin
        set IO(allocate) 1
        set IO(bufsize) 80
    }
    code::PreferenceSetIfChanged System defineio $Configure(System,defineio)
    code::PreferenceSetIfChanged System devstdin $IO(stdin)
    code::PreferenceSetIfChanged System devstdout $IO(stdout)
    code::PreferenceSetIfChanged System devstderr $IO(stderr)
    set old [lindex $IO(devtab) $IO(device)]
    if {!$force && \
        [string match [lindex $old 0] $IO(name)] && \
        [lindex $old 1] == $IO(mode) && \
        [lindex $old 2] == $IO(flags) && \
        [string match [lindex $old 3] $IO(delete)] && \
        [string match [lindex $old 4] $IO(kill)] && \
        [string match [lindex $old 5] $IO(open)] && \
        [string match [lindex $old 6] $IO(close)] && \
        [string match [lindex $old 7] $IO(read)] && \
        [string match [lindex $old 8] $IO(write)] && \
        [string match [lindex $old 9] $IO(ioctl)] && \
        [string match [lindex $old 10] $IO(title)] && \
        [string match [lindex $old 11] $IO(bufsize)]} {
        return
    }
    if {$IO(title) == {}} {
        set IO(title) Untitled
    }
    set new [list $IO(name) $IO(mode) $IO(flags) $IO(delete) \
        $IO(kill) $IO(open) $IO(close) $IO(read) $IO(write) \
        $IO(ioctl) $IO(title) $IO(bufsize)]
    if {$append} {
        lappend IO(devtab) $new
    } else {
        set IO(devtab) [lreplace $IO(devtab) $IO(device) $IO(device) $new]
    }
    code::PreferenceSetIfChanged System devtable $IO(devtab)
}

set IO(device) 0
IOSet

set width 0
foreach one $devlist {
    set len [string length [lindex $one 10]]
    if {$len > $width} {
        set width $len
    }
}

# define temporarily to handle premature calls
proc ::IOUse {} {}

combobox $base.frameCombo.combo \
    -maxheight 0 \
    -textvariable IO(pre) \
    -width $width \
    -editable false \
    -command "IOUse; #"

set IO(pre) {}
foreach one $devlist {
    $base.frameCombo.combo list insert end [lindex $one 10]
}
grid $base.frameCombo.combo -in $base.frameCombo

proc ::IOUse {} {
    global IO

    foreach first $IO(devlist) {
        if {[string match $IO(pre) [lindex $first 10]]} {
            break
        }
    }
    set IO(name) [lindex $first 0]
    set IO(mode) [lindex $first 1]
    set IO(flags) [lindex $first 2]
    set IO(delete) [lindex $first 3]
    set IO(kill) [lindex $first 4]
    set IO(open) [lindex $first 5]
    set IO(close) [lindex $first 6]
    set IO(read) [lindex $first 7]
    set IO(write) [lindex $first 8]
    set IO(ioctl) [lindex $first 9]
    set IO(title) [lindex $first 10]
    set IO(bufsize) [lindex $first 11]
    set IO(allocate) [expr {[string compare $IO(bufsize) {}] != 0}]
    IOSave 1
}

proc ::IODelete {} {
    global IO

    if {$IO(devcount) == 0} {
        return
    }
    set IO(devtab) [lreplace $IO(devtab) $IO(device) $IO(device)]
    code::PreferenceSetIfChanged System devtable $IO(devtab)
    incr IO(devcount) -1
    if {$IO(device) != 0 && $IO(device) >= $IO(devcount)} {
        set IO(device) [expr $IO(devcount) - 1]
    }
    if {$IO(device) == 0} {
        $IO(base).buttonPrevious config -state disabled
    }
    if {$IO(device) >= $IO(devcount)} {
        $IO(base).buttonNext config -state disabled
    }
    IOSet
    IOSave 1
}

proc ::IOallocate {{button 0}} {
    global IO

    if {$button} {
        # entered from check button
        if {$IO(allocate)} {
            set IO(bufsize) 80
        } else {
            set IO(bufsize) {}
        }
    } else {
        # an entry event
        if {[string compare $IO(bufsize) {}] == 0} {
            set IO(allocate) 0
        } else {
            if {[catch {expr {int($IO(bufsize))}} IO(bufsize)]} {
                set IO(bufsize) {}
                set IO(allocate) 0
            } else {
                set IO(allocate) 1
            }
        }
    }
    IOSave
}

# help and bindings
code::help $w $base.checkbuttonDefineIO "Define a device table in the generated startup code"
code::help $w $base.labelPredefined "Set the current device to one of the predefined devices"
code::help $w $base.frameCombo.combo "Set the current device to one of the predefined devices"
code::help $w $base.labelTotal "The total number of device table entries defined"
code::help $w $base.labelCount "The total number of device table entries defined"
code::help $w $base.labelNumber "The current device table entry"
code::help $w $base.labelDevice "The current device table entry"
code::help $w $base.entryTitle "A short description of this device"
bind $base.entryTitle <Return> IOSave
bind $base.entryTitle <FocusOut> IOSave
code::help $w $base.labelName "The device name used by the program"
code::help $w $base.entryName "The device name used by the program"
code::help $w $base.entryName "The device name used by the program"
bind $base.entryName <Return> IOSave
bind $base.entryName <FocusOut> IOSave
code::help $w $base.labelIs "The standard I/O stream this device implements"
code::help $w $base.checkbuttonStdin "If set, this device is the stdin stream"
code::help $w $base.checkbuttonStdout "If set, this device is the stdout stream"
code::help $w $base.checkbuttonStderr "If set, this device is the stderr stream"
code::help $w $base.labelMode "The mode of this device"
code::help $w $base.checkbuttonRead "If set, this device is readable"
code::help $w $base.checkbuttonWrite "If set, this device is writeable"
code::help $w $base.checkbuttonBinary "If set, this device is binary"
code::help $w $base.labelFlags "The flags associated with this device"
code::help $w $base.checkbuttonEcho "If set, input characters are echoed to the output"
code::help $w $base.checkbuttonBuffered "If set, input is line buffered"
code::help $w $base.checkbuttonICRNL "If set, input carriage returns are converted to newlines"
code::help $w $base.checkbuttonONLCR "If set, output newlines are converted to carriage return and linefeed"
code::help $w $base.checkbuttonBSERASE "If set, a backspace space backspace is outout when the delete character is input"
code::help $w $base.labelDelete "The input delete character (^x means control-X, can also be del or a numeric constant)"
code::help $w $base.entryDelete "The input delete character (^x means control-X, can also be del or a numeric constant)"
bind $base.entryDelete <Return> IOSave
bind $base.entryDelete <FocusOut> IOSave
code::help $w $base.labelKill "The input line delete character (^x means control-X, can also be del or a numeric constant)"
code::help $w $base.entryKill "The input line delete character (^x means control-X, can also be del or a numeric constant)"
bind $base.entryKill <Return> IOSave
bind $base.entryKill <FocusOut> IOSave
code::help $w $base.labelOpen "The device open function"
code::help $w $base.entryOpen "The device open function"
bind $base.entryOpen <Return> IOSave
bind $base.entryOpen <FocusOut> IOSave
code::help $w $base.labelClose "The device close function"
code::help $w $base.entryClose "The device close function"
bind $base.entryClose <Return> IOSave
bind $base.entryClose <FocusOut> IOSave
code::help $w $base.labelRead "The device read function"
code::help $w $base.entryRead "The device read function"
bind $base.entryRead <Return> IOSave
bind $base.entryRead <FocusOut> IOSave
code::help $w $base.labelWrite "The device write function"
code::help $w $base.entryWrite "The device write function"
bind $base.entryWrite <Return> IOSave
bind $base.entryWrite <FocusOut> IOSave
code::help $w $base.labelIoctl "The device control function"
code::help $w $base.entryIoctl "The device control function"
bind $base.entryIoctl <Return> IOSave
bind $base.entryIoctl <FocusOut> IOSave
code::help $w $base.buttonPrevious "View the previous device"
code::help $w $base.buttonNext "View the next device"
code::help $w $base.buttonDelete "Delete the current device"

bind $base.entryBufsize <Return> IOallocate
bind $base.entryBufsize <FocusOut> IOallocate
code::help $w $base.entryBufsize "Size of the statically allocated buffer for this device"
code::help $w $base.checkbuttonBufsize "Check to statically allocate a buffer for this device"

return "Configure the input/output device table"









# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	IO_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing IO_ui"
	    IO_ui .
	}
    }
}
