#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Init11.ui
#   root     is the parent window for this user interface

proc Init11_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#5 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#1 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#2

	frame $base.frame#3

	frame $base.frame#6

	frame $base.frame#4

	label $base.labelOption \
		-text {Configuration Option Setup}

	label $base.labelMapping \
		-text {RAM and I/O mapping}

	checkbutton $base.checkbuttonADPU \
		-command InitSave \
		-maskvalue 128 \
		-onvalue 0x80 \
		-text ADPU \
		-variable code::Configure(Registers,OPTION)

	checkbutton $base.checkbuttonCSEL \
		-command InitSave \
		-maskvalue 64 \
		-onvalue 0x40 \
		-text CSEL \
		-variable code::Configure(Registers,OPTION)

	checkbutton $base.checkbuttonIRQE \
		-command InitSave \
		-maskvalue 32 \
		-onvalue 0x20 \
		-text IRQE \
		-variable code::Configure(Registers,OPTION)

	label $base.labelRAM \
		-text RAM:

	entry $base.entryRAM \
		-textvariable Init(RAM) \
		-width 6

	checkbutton $base.checkbuttonDLY \
		-command InitSave \
		-maskvalue 16 \
		-onvalue 0x10 \
		-text DLY \
		-variable code::Configure(Registers,OPTION)

	checkbutton $base.checkbuttonCME \
		-command InitSave \
		-maskvalue 8 \
		-onvalue 0x08 \
		-text CME \
		-variable code::Configure(Registers,OPTION)

	checkbutton $base.checkbuttonFCME \
		-command InitSave \
		-maskvalue 4 \
		-onvalue 0x04 \
		-text FCME \
		-variable code::Configure(Registers,OPTION)

	label $base.labelIO \
		-text I/O:

	entry $base.entryIO \
		-textvariable Init(IO) \
		-width 6

	label $base.labelCOPrate \
		-text {COP timer rate select}

	radiobutton $base.radiobuttonCR1 \
		-command InitSave \
		-maskvalue 3 \
		-text /1 \
		-value 0 \
		-variable code::Configure(Registers,OPTION)

	radiobutton $base.radiobuttonCR4 \
		-command InitSave \
		-maskvalue 3 \
		-text /4 \
		-value 1 \
		-variable code::Configure(Registers,OPTION)

	radiobutton $base.radiobuttonCR16 \
		-command InitSave \
		-maskvalue 3 \
		-text /16 \
		-value 2 \
		-variable code::Configure(Registers,OPTION)

	radiobutton $base.radiobuttonCR64 \
		-command InitSave \
		-maskvalue 3 \
		-text /64 \
		-value 3 \
		-variable code::Configure(Registers,OPTION)


	# Geometry management

	grid $base.frame#5 -in $root	-row 1 -column 2  \
		-sticky n
	grid $base.frame#1 -in $root	-row 1 -column 1 
	grid $base.frame#2 -in $base.frame#1	-row 2 -column 1 
	grid $base.frame#3 -in $base.frame#1	-row 3 -column 1 
	grid $base.frame#6 -in $base.frame#5	-row 2 -column 1 
	grid $base.frame#4 -in $base.frame#3	-row 2 -column 1 
	grid $base.labelOption -in $base.frame#1	-row 1 -column 1 
	grid $base.labelMapping -in $base.frame#5	-row 1 -column 1 
	grid $base.checkbuttonADPU -in $base.frame#2	-row 1 -column 1  \
		-sticky w
	grid $base.checkbuttonCSEL -in $base.frame#2	-row 1 -column 2  \
		-sticky w
	grid $base.checkbuttonIRQE -in $base.frame#2	-row 1 -column 3  \
		-sticky w
	grid $base.labelRAM -in $base.frame#6	-row 1 -column 1  \
		-sticky e
	grid $base.entryRAM -in $base.frame#6	-row 1 -column 2 
	grid $base.checkbuttonDLY -in $base.frame#2	-row 2 -column 1  \
		-sticky w
	grid $base.checkbuttonCME -in $base.frame#2	-row 2 -column 2  \
		-sticky w
	grid $base.checkbuttonFCME -in $base.frame#2	-row 2 -column 3  \
		-sticky w
	grid $base.labelIO -in $base.frame#6	-row 2 -column 1  \
		-sticky e
	grid $base.entryIO -in $base.frame#6	-row 2 -column 2 
	grid $base.labelCOPrate -in $base.frame#3	-row 1 -column 1 
	grid $base.radiobuttonCR1 -in $base.frame#4	-row 1 -column 1  \
		-sticky w
	grid $base.radiobuttonCR4 -in $base.frame#4	-row 1 -column 2 
	grid $base.radiobuttonCR16 -in $base.frame#4	-row 1 -column 3 
	grid $base.radiobuttonCR64 -in $base.frame#4	-row 1 -column 4 

	# Resize behavior management

	grid rowconfigure $base.frame#2 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 3 -weight 0 -minsize 30

	grid rowconfigure $base.frame#6 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#6 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#3 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#3 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 1 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 1 -minsize 30

	grid rowconfigure $base.frame#4 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 4 -weight 0 -minsize 30

	grid rowconfigure $base.frame#5 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#5 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
 
    proc Save {} {}
    return
}

set w [lindex $args 0]

global Init
global code::Configure

code::help $w $base.radiobuttonCR1 "COP timer rate: E / 2^15 / 1"
code::help $w $base.radiobuttonCR4 "COP timer rate: E / 2^15 / 4"
code::help $w $base.radiobuttonCR16 "COP timer rate: E / 2^15 / 16"
code::help $w $base.radiobuttonCR64 "COP timer rate: E / 2^15 / 64"
code::help $w $base.labelCOPrate "Set the COP timer rate"
code::help $w $base.checkbuttonFCME "Force clock monitor enable"
code::help $w $base.checkbuttonCME "Clock monitor enable"
code::help $w $base.checkbuttonDLY "STOP mode exit turn-on delay"
code::help $w $base.checkbuttonIRQE "On: IRQ edge sensitive, Off: IRQ level sensitive"
code::help $w $base.checkbuttonCSEL "A/D Clock - On: internal RC clock, Off: system E clock"
code::help $w $base.checkbuttonADPU "A/D power"

set o $Configure(Registers,INIT)
set Init(IO) [format "0x%02X" [expr $o & 0x0F]]
set Init(RAM) [format "0x%02X" [expr $o >> 4]]
code::help $w $base.labelMapping "Set up the on-chip RAM and I/O mapping"
code::help $w $base.labelRAM "Set the RAM page (address / 4096)"
code::help $w $base.entryRAM "Set the RAM page (address / 4096)"
code::help $w $base.labelIO "Set the I/O page (address / 4096)"
code::help $w $base.entryIO "Set the I/O page (address / 4096)"
bind $base.entryIO <FocusOut> InitSave
bind $base.entryIO <Return> InitSave
bind $base.entryRAM <FocusOut> InitSave
bind $base.entryRAM <Return> InitSave

proc ::InitSave {} {
    global Init
    global code::Configure

    set Configure(Registers,INIT) [format "0x%02X" [expr (($Init(RAM)&0xF)<<4)|($Init(IO)&0xF)]]
    code::DdfSetRegister INIT code::Configure(Registers,INIT)
    code::DdfSetRegister OPTION code::Configure(Registers,OPTION)

}

return "Configure INIT and OPTION registers"



# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Init11_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Init11_ui"
	    Init11_ui .
	}
    }
}
