#
# Install - install CODE
#

package require mkWidgets

# the main Install options
array set code::Install {
    initialized 0
    state 1
    accepted 0
    text {}
    select {}
}

#
# SETUP - install CODE
#
proc code::SETUP {args} {
    variable INTROL
    global env

    # make INTROL sane on all targets (forward slashed)
    set INTROL [eval file join [file split $env(INTROL)]]

    wm geometry . 600x500
    wm title . "Welcome to CODE!"
    placewindow .
    statusbar .status -ticks 10
    # show the splash screen
    signon 1
    Install . start
}

proc code::Install {w command {arg {}}} {
    global tcl_platform
    variable Install
    variable INTROL

    switch -exact $command {
	start {
	    # begin installation
	    if {$Install(state) != 1} {
		break
	    }
	    set Install(state) 2
	    set Install(accepted) 1

	    if {$Install(select) == {}} {
	        # gather host information
	        set host [code::host]
	        set hostfiles [glob [file join $INTROL * host]]
	        if {$tcl_platform(platform) == "windows"} {
		    set Install(dir) "c:\\introl"
	        } else {
		    set Install(dir) "/usr/introl"
	        }
	        # build the option window specification
	        set f [frame $w.ow]
	        grid columnconfigure $f 0 -weight 1
	        set l [label $f.l1 -text "Host Platforms to install (choose one or more):"]
	        grid $l -in $f -row 0 -column 0 
	        set Install(hosts) ""
	        set index 0
	        set bf [frame $f.f]
	        grid columnconfigure $bf 0 -weight 0
	        grid columnconfigure $bf 1 -weight 1
	        grid $bf -in $f -row 1 -column 0 
	        foreach file $hostfiles {
		    set h [file tail [file dirname $file]]
		    lappend Install(hosts) $h
		    if {$host == $h} {
		        set Install($h) 1
		    } else {
		        set Install($h) 0
		    }
		    set file [open $file r]
		    set hb [checkbutton $bf.hb#$index -text [gets $file] -variable code::Install($h)]
		    grid $hb -in $bf -row $index -column 0 -sticky w
		    close $file
		    incr index
	        }
		set Install(cdmanual) 0
		set hb [checkbutton $bf.hb#$index -text "Don't install manual" -variable code::Install(cdmanual)]
		help $w $hb "Don't install the CODE manual to save disk space"
		grid $hb -in $bf -row $index -column 0 -sticky w
	        set l [label $f.l2 -text "Installation Directory:"]
	        grid $l -in $f -row 2 -column 0
		set ff [frame $f.ff]
	        grid $ff -in $f -row 3 -column 0
	        set e [entry $ff.e -textvariable code::Install(dir) -width 40]
	        bind $e <Return> "code::Install $w continue"
		help $w $e "Enter the name of the installation directory"
	        grid $e -in $ff -row 0 -column 0
		set b [button $ff.b -text Browse... -command code::InstallBrowse]
		help $w $b "Browse for or create an installation directory"
	        grid $b -in $ff -row 0 -column 1

    
		set Install(select) "$f $f"
	    }

            wm title . "Configure CODE Installation"
	    eval setContent $w Install $Install(select)
	    set buttons [getContent $w Install select]
	    buttonChange $w Install $buttons 0 \
		Continue continue "Continue installation"
	    buttonChange $w Install $buttons 1 \
		Cancel cancel "Cancel installation"
	}
	again {
	    # get back to state 1
	    set Install(state) 1
	    Install $w Enter
	}
	continue {
	    if {$Install(state) == 3} {
		# already doing install
		return
	    }

	    if {$tcl_platform(platform) == "windows"} {
	        # change backslashes to slashes under windows
		regsub -all {\\} $Install(dir) / Install(dir)
	    }

	    # check for the existance of the INTROL directory

	    if {[file exists $Install(dir)]} {
	       if {[tk_messageBox \
		    -parent $w \
		   -icon warning \
		   -message "The directory $Install(dir) already exists.
Do you want to overwrite the previous installation?" \
		   -type yesno] == "no"} {
		   return
		   }
	    } else {
		# make the installation directory
		if {[catch "file mkdir \"$Install(dir)\"" msg]} {
	            tk_messageBox \
		        -parent $w \
			-icon error \
		        -message "Cannot create $Install(dir).\n\`$msg'" \
		        -type ok
		    return
		}
	    }
	    # see if we can write to Install(dir)
	    set t [clock format [clock seconds]]
	    set inst [file join $Install(dir) installed]
	    if {[catch {open $inst w} f]} {
	        tk_messageBox \
		    -parent $w \
		    -icon error \
		    -message "Cannot write in $Install(dir). $f" \
		    -type ok
		return
	    }
	    puts $f $t
	    close $f

	    # do the installation

	    set Install(state) 3

	    # get set of wanted hosts
	    if {$Install(cdmanual)} {
		# dont install the manual
	        set wanted base
		# write the source directory for later manual access
		set f [open [file join $Install(dir) manual] w]
		puts -nonewline $f $INTROL
		close $f
	    } else {
	        set wanted {base manual}
		file delete [file join $Install(dir) manual]
	    }
	    foreach h $Install(hosts) {
		if {$Install($h)} {
		    lappend wanted $h
		}
	    }

	    # copy the files using the installation lists
	    foreach list $wanted {
		set f [open [file join $INTROL install $list] r]
		while {[gets $f file] != -1} {
		    if {$file == ""} {
			continue
		    }
		    code::status $w $file
		    update

		    # check for interruption of installation
		    if {$Install(state) != 3} {
			return
		    }
		    if {[file dirname $file] != ""} {
		        file mkdir \
			    [file dirname [file join $Install(dir) $file]]
		    }
		    file copy -force \
			[file join $INTROL $file] \
			[file join $Install(dir) $file]
		}
		close $f
	    }
	    code::status $w ""

	    Installed $Install(dir)
            set path "PATH=[file nativename [file join $Install(dir) [code::host] bin]]"
	    set introl "INTROL=[file nativename $Install(dir)]"

            wm title . "Installation Finished"
	    # go back to the text widget
	    eval setContent $w Install $Install(text)
            set t [getContent $w Install]
	    $t config -state normal
	    $t delete 1.0 end
	    $t tag configure info -font {Times 14 bold} -justify center
	    $t insert insert $introl\n$path\n info

	    set buttons [getContent $w Install select]
	    buttonChange $w Install $buttons 0 \
		Ok done "Installation finished"
	    buttonChange $w Install $buttons 1 \
		Again again "Install CODE again"

	    if {$tcl_platform(platform) == "windows"} {
                set f [open [file join $INTROL winenviron.html] r]
	    } else {
                set f [open [file join $INTROL environ.html] r]
	    }
            html::insert $t [read $f]
	    $t insert end \n$introl\n$path info
	    scrolledtextScroll [getContentWidget $w Install]
	    $t see 1.0
            $t config -state disabled
            close $f
	}
	cancel {
	    # the installation has been cancelled

	    if {$Install(state) == 3} {
		# an installation was in progress, go back to last state
		set Install(state) 2
	       if {[tk_messageBox \
		    -parent $w \
		   -icon question \
		   -message "Installation has been cancelled.
Do you want to delete $Install(dir)?" \
		   -type yesno] == "yes"} {
		   file delete -force $Install(dir)
		   }
	    } else {
	        set Install(state) 0
	        set Install(accepted) 0
                windowSet $w Directory
	    }
	}
	exit {
	    # the license was not accepted
	    ::exit
	}
	done {
	    # installation is complete
	    set Install(state) 0
	    set Install(accepted) 0
            windowSet $w Directory
	}
        Leave {
        }
        Destroy {
	    foreach name [array names Install $w,*] {
	        unset Install($name)
	    }
        }
        default {
            tk_messageBox -icon error \
		-parent $w \
	        -message "Install doesn't understand $command" -type ok
        }
    }
}

#
# InstallBrowse - open a directory window for browsing
#
proc code::InstallBrowse {} {
	variable Directory

	set nw [slave Directory]
        set code::Install(dir) [file nativename $Directory($nw,pwd)]
        trace variable Directory($nw,pwd) w "set code::Install(dir) \
	    \[file nativename \$Directory($nw,pwd)]; #"
}

#
# LicenseSet - the user has accepted the license
#
proc code::LicenseSet {} {
    variable license
    variable INTROL

    set t [clock format [clock seconds]]
    set lic [file join $INTROL license]
    if {[catch {open $lic w} f]} {
	# let us run on a read only file system
        set code::license 1
	return
    }
    puts $f $t
    close $f
    set code::license 1
}

#
# License - display the license, get accept or exit
#
proc code::License {} {
    global code::license

    set box .license

    toplevel $box 
    wm transient $box .
    wm protocol $box WM_DELETE_WINDOW "code::LicenseSet"
    set f [frame $box.buttons]
    set tf [frame $box.tf]
    set t $tf.t
    set sx $tf.x
    set sy $tf.y
    text $t -wrap none -xscrollcommand "$sx set" -yscrollcommand "$sy set"
    scrollbar $sx -command "$t xview" -orient h
    scrollbar $sy -command "$t yview" -orient v
    grid $t -in $tf -row 1 -column 0 -sticky nesw
    grid $sx -in $tf -row 2 -column 0 -sticky ew
    grid $sy -in $tf -row 1 -column 1 -sticky ns
    grid columnconfigure $f 0 -weight 1
    grid rowconfigure $f 1 -weight 1

    set fd [open [FindManual license.html] r]
    $t config -state normal
    $t delete 1.0 end
    html::insert $t [read $fd]
    $t see 1.0
    $t config -state disabled
    close $fd
    set okBtn [button $f.ok -text Accept -width 6 \
        -command "code::LicenseSet"]
    set cancelBtn [button $f.cancel -text Exit -width 6 \
        -command _exit]
    grid $okBtn -in $f -row 0 -column 0 
    grid $cancelBtn -in $f -row 0 -column 1 
    grid $f -in $box -row 2 -column 0 -sticky ew -padx 5 -pady 5
    grid $tf -in $box -row 1 -column 0 -sticky ew -padx 5 -pady 5

    wm title $box "The Introl-CODE License"

    set oldFocus [focus]
    set oldGrab [grab current $box]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    grab $box
    focus $t

    tkwait variable code::license
    catch {focus $oldFocus}
    grab release $box
    destroy $box
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
}

#
# Installed - mark CODE as being installed
#
proc code::Installed {{where {}}} {
    variable INTROL
    variable installed

    # record the installation
    set t [clock format [clock seconds]]
    if {[catch "open [file join $INTROL installed] w" f]} {
	# let us run on a read only file system
	return
    }
    puts $f $t
    close $f
    set installed 1
}

