#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/MCCI.ui
#   root     is the parent window for this user interface

proc MCCI_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#2 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#1 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#3

	frame $base.frame#5

	frame $base.frame#7

	label $base.labelStdioselect \
		-text {Stdio select:}

	radiobutton $base.radiobuttonSCI \
		-command IOSave \
		-text SCI \
		-value __mccio \
		-variable IO(Stdioselect)

	radiobutton $base.radiobuttonCREX \
		-command IOSave \
		-text CREX \
		-value __crexmccio \
		-variable IO(Stdioselect)

	radiobutton $base.radiobuttonNone \
		-command IOSave \
		-text None \
		-variable IO(Stdioselect)

	label $base.labelConfigurationValues \
		-text {Configuration Values}

	checkbutton $base.checkbuttonSBK \
		-command IOSave \
		-maskvalue 1 \
		-onvalue 0x0001 \
		-text SBK \
		-variable IO(_CPU16_SCCR1Ainit)

	checkbutton $base.checkbuttonRWU \
		-command IOSave \
		-maskvalue 2 \
		-onvalue 0x0002 \
		-text RWU \
		-variable IO(_CPU16_SCCR1Ainit)

	checkbutton $base.checkbuttonRE \
		-command IOSave \
		-maskvalue 4 \
		-onvalue 0x0004 \
		-text RE \
		-variable IO(_CPU16_SCCR1Ainit)

	checkbutton $base.checkbuttonTE \
		-command IOSave \
		-maskvalue 8 \
		-onvalue 0x0008 \
		-text TE \
		-variable IO(_CPU16_SCCR1Ainit)

	checkbutton $base.checkbuttonILIE \
		-command IOSave \
		-maskvalue 16 \
		-onvalue 0x0010 \
		-text ILIE \
		-variable IO(_CPU16_SCCR1Ainit)

	checkbutton $base.checkbuttonRIE \
		-command IOSave \
		-maskvalue 32 \
		-onvalue 0x0020 \
		-text RIE \
		-variable IO(_CPU16_SCCR1Ainit)

	checkbutton $base.checkbuttonTCIE \
		-command IOSave \
		-maskvalue 64 \
		-onvalue 0x0040 \
		-text TCIE \
		-variable IO(_CPU16_SCCR1Ainit)

	checkbutton $base.checkbuttonTIE \
		-command IOSave \
		-maskvalue 128 \
		-onvalue 0x0080 \
		-text TIE \
		-variable IO(_CPU16_SCCR1Ainit)

	checkbutton $base.checkbuttonWAKE \
		-command IOSave \
		-maskvalue 256 \
		-onvalue 0x0100 \
		-text WAKE \
		-variable IO(_CPU16_SCCR1Ainit)

	checkbutton $base.checkbuttonM \
		-command IOSave \
		-maskvalue 512 \
		-onvalue 0x0200 \
		-text M \
		-variable IO(_CPU16_SCCR1Ainit)

	checkbutton $base.checkbuttonPE \
		-command IOSave \
		-maskvalue 1024 \
		-onvalue 0x0400 \
		-text PE \
		-variable IO(_CPU16_SCCR1Ainit)

	checkbutton $base.checkbuttonPT \
		-command IOSave \
		-maskvalue 2048 \
		-onvalue 0x0800 \
		-text PT \
		-variable IO(_CPU16_SCCR1Ainit)

	checkbutton $base.checkbuttonILT \
		-command IOSave \
		-maskvalue 4096 \
		-onvalue 0x1000 \
		-text ILT \
		-variable IO(_CPU16_SCCR1Ainit)

	checkbutton $base.checkbuttonWOMS \
		-command IOSave \
		-maskvalue 8192 \
		-onvalue 0x2000 \
		-text WOMS \
		-variable IO(_CPU16_SCCR1Ainit)

	checkbutton $base.checkbuttonLOOPS \
		-command IOSave \
		-maskvalue 16384 \
		-onvalue 0x4000 \
		-text LOOPS \
		-variable IO(_CPU16_SCCR1Ainit)

	label $base.labelSCIBaudrate \
		-text {SCI Baud rate: }

	label $base.labelClock \
		-textvariable code::Configure(System,clock) \
		-width 8

	label $base.label#13 \
		-text {/ (32 * }

	entry $base.entrySCCR0A \
		-textvariable IO(_CPU16_SCCR0Ainit) \
		-width 6

	label $base.label#14 \
		-text {) =}

	label $base.labelBAUD \
		-justify left \
		-textvariable IO(BAUD) \
		-width 6

	label $base.labelInput \
		-text {Input buffer size:}

	entry $base.entryInput \
		-textvariable IO(CX_INBUF) \
		-width 6

	label $base.labelOutput \
		-text {Output buffer size:}

	entry $base.entryOutput \
		-cursor {} \
		-textvariable IO(CX_OUTBUF) \
		-width 6


	# Geometry management

	grid $base.frame#2 -in $root	-row 2 -column 1 
	grid $base.frame#1 -in $root	-row 1 -column 1  \
		-sticky w
	grid $base.frame#3 -in $base.frame#2	-row 2 -column 1  \
		-sticky w
	grid $base.frame#5 -in $base.frame#2	-row 4 -column 1  \
		-sticky w
	grid $base.frame#7 -in $base.frame#2	-row 3 -column 1  \
		-columnspan 2 \
		-sticky w
	grid $base.labelStdioselect -in $base.frame#1	-row 1 -column 1 
	grid $base.radiobuttonSCI -in $base.frame#1	-row 1 -column 2  \
		-sticky w
	grid $base.radiobuttonCREX -in $base.frame#1	-row 1 -column 3  \
		-sticky w
	grid $base.radiobuttonNone -in $base.frame#1	-row 1 -column 4  \
		-sticky w
	grid $base.labelConfigurationValues -in $base.frame#2	-row 1 -column 1 
	grid $base.checkbuttonSBK -in $base.frame#3	-row 1 -column 1  \
		-sticky w
	grid $base.checkbuttonRWU -in $base.frame#3	-row 1 -column 2  \
		-sticky w
	grid $base.checkbuttonRE -in $base.frame#3	-row 1 -column 3  \
		-sticky w
	grid $base.checkbuttonTE -in $base.frame#3	-row 1 -column 4  \
		-sticky w
	grid $base.checkbuttonILIE -in $base.frame#3	-row 2 -column 1  \
		-sticky w
	grid $base.checkbuttonRIE -in $base.frame#3	-row 2 -column 2  \
		-sticky w
	grid $base.checkbuttonTCIE -in $base.frame#3	-row 2 -column 3  \
		-sticky w
	grid $base.checkbuttonTIE -in $base.frame#3	-row 2 -column 4  \
		-sticky w
	grid $base.checkbuttonWAKE -in $base.frame#3	-row 3 -column 1  \
		-sticky w
	grid $base.checkbuttonM -in $base.frame#3	-row 3 -column 2  \
		-sticky w
	grid $base.checkbuttonPE -in $base.frame#3	-row 3 -column 3  \
		-sticky w
	grid $base.checkbuttonPT -in $base.frame#3	-row 3 -column 4  \
		-sticky w
	grid $base.checkbuttonILT -in $base.frame#3	-row 4 -column 1  \
		-sticky w
	grid $base.checkbuttonWOMS -in $base.frame#3	-row 4 -column 2  \
		-sticky w
	grid $base.checkbuttonLOOPS -in $base.frame#3	-row 4 -column 3  \
		-sticky w
	grid $base.labelSCIBaudrate -in $base.frame#7	-row 1 -column 1 
	grid $base.labelClock -in $base.frame#7	-row 1 -column 2 
	grid $base.label#13 -in $base.frame#7	-row 1 -column 3 
	grid $base.entrySCCR0A -in $base.frame#7	-row 1 -column 4 
	grid $base.label#14 -in $base.frame#7	-row 1 -column 5 
	grid $base.labelBAUD -in $base.frame#7	-row 1 -column 6  \
		-sticky w
	grid $base.labelInput -in $base.frame#5	-row 1 -column 1  \
		-sticky e
	grid $base.entryInput -in $base.frame#5	-row 1 -column 2 
	grid $base.labelOutput -in $base.frame#5	-row 2 -column 1 
	grid $base.entryOutput -in $base.frame#5	-row 2 -column 2 

	# Resize behavior management

	grid rowconfigure $base.frame#2 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 1 -weight 0 -minsize 53
	grid columnconfigure $base.frame#2 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#3 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#3 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#3 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#3 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 4 -weight 0 -minsize 30

	grid rowconfigure $base.frame#7 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 5 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 6 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 0 -minsize 30
	grid rowconfigure $root 3 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 1 -minsize 30

	grid rowconfigure $base.frame#5 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#5 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 4 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
 
    proc Save {} {}
    return
}

set w [lindex $args 0]

global IO

# get the module definition
set m [code::Preference Module mccio]

variable Stdioselect [lindex [lindex $m 0] 0]
foreach "name value" [lrange $m 1 end] {
    set IO($name) $value
}

code::help $w $base.labelStdioselect "Select the stdin/stdout functions"
code::help $w $base.radiobuttonSCI "Use the SCI for non-interrupt driven i/o"
code::help $w $base.radiobuttonCREX "Use the SCI for interrupt driven i/o under CREX"
code::help $w $base.radiobuttonNone "Don't use any i/o functions supplied with CODE"
code::help $w $base.labelConfigurationValues "Configure the I/O functions"
code::help $w $base.labelSCIBaudrate "The initial SCI baud rate for SCI and CREX I/O"
code::help $w $base.labelClock "The system clock speed"
code::help $w $base.entrySCCR0A "Change the initial SCI SCCR0A register for SCI and CREX I/O"
bind $base.entrySCCR0A <FocusOut> IOSave
bind $base.entrySCCR0A <Return> IOSave
code::help $w $base.labelBAUD "The baud rate at this system clock speed"

foreach "name help" {
    LOOPS {Test SCI operation, looping, feedback path enabled}
    WOMS {Set TXD to open drain output}
    ILT {Long idle-line detect}
    PT {Odd parity}
    PE {Enable parity}
    M {Frame length: Off - 10 bit, On - 11 bit}
    WAKE {Receiver wakeup: Off - idle-line, On - address mark}
    TIE {Enable transmit data reggister empty interrupt}
    TCIE {Enable transmit complete interrupt}
    RIE {Enable receiver interrupts}
    ILIE {Enable idle-line interrupt}
    TE {Enable the transmitter}
    RE {Enable the receiver}
    RWU {Enable receiver wakeup mode}
    SBK {Send break}} {
    code::help $w $base.checkbutton$name $help
}
code::help $w $base.labelInput "The size of the CREX SCI input buffer in bytes"
code::help $w $base.entryInput "Change the size of the CREX SCI input buffer"
bind $base.entryInput <FocusOut> IOSave
bind $base.entryInput <Return> IOSave
code::help $w $base.labelOutput "The size of the CREX SCI output buffer in bytes"
code::help $w $base.entryOutput "Change the size of the CREX SCI output buffer"
bind $base.entryOutput <FocusOut> IOSave
bind $base.entryOutput <Return> IOSave

proc ::IOSave {} {
    global IO code::Configure

    set oldm [code::Preference Module mccio]

    set IO(_CPU16_SCCR0Ainit) [expr $IO(_CPU16_SCCR0Ainit) \
        & 0x1FFF]
    set IO(BAUD) [expr $code::Configure(System,clock) / \
        ($IO(_CPU16_SCCR0Ainit) * 32)]
    set changed 0
    set m [concat [list $IO(Stdioselect)] [lrange [lindex $oldm 0] 1 end]]
    if {$m != [lindex $oldm 0]} {
        set changed 1
    }
    set n {}
    foreach "name value" [lrange $oldm 1 end] {
        set newvalue $IO($name)
        lappend n $name $newvalue
        if {$newvalue != $value} {
            set changed 1
        }
    }
    if {$changed} {
        code::Preference Module mccio [concat [list $m] $n] 1
    }
    if {$IO(Stdioselect) == "__crexmccio"} {
        # use  crex
	global CREX
        set CREX(crex) __crex
        CREXSave
    }
}

IOSave

return "Configure the stdio channel"



# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	MCCI_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing MCCI_ui"
	    MCCI_ui .
	}
    }
}
