#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Output.ui
#   root     is the parent window for this user interface

proc Output_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	label $base.label#4 \
		-text {Additional output files to create for the project}

	label $base.labelOutputtype \
		-text {Output type}

	label $base.labelOutputfilename \
		-text {Output file name}

	label $base.labelEntrypoint \
		-text {Entry point}

	checkbutton $base.checkbuttonSrecord \
		-text S-records \
		-variable code::Configure(System,Srecord)

	entry $base.entrySrecordfile \
		-textvariable code::Configure(System,Srecordfile)

	entry $base.entrySrecordentry \
		-textvariable code::Configure(System,Srecordentry)

	checkbutton $base.checkbuttonIntelhex \
		-text {Intel hex} \
		-variable code::Configure(System,Intelhex)

	entry $base.entryIntelhexfile \
		-textvariable code::Configure(System,Intelhexfile)

	entry $base.entryIntelhexentry \
		-textvariable code::Configure(System,Intelhexentry)

	checkbutton $base.checkbuttonIeee695 \
		-text {IEEE 695} \
		-variable code::Configure(System,Ieee695)

	entry $base.entryIeee695file \
		-textvariable code::Configure(System,Ieee695file)

	entry $base.entryIeee695entry \
		-textvariable code::Configure(System,Ieee695entry)


	# Geometry management

	grid $base.label#4 -in $root	-row 1 -column 1  \
		-columnspan 3
	grid $base.labelOutputtype -in $root	-row 2 -column 1 
	grid $base.labelOutputfilename -in $root	-row 2 -column 2 
	grid $base.labelEntrypoint -in $root	-row 2 -column 3 
	grid $base.checkbuttonSrecord -in $root	-row 3 -column 1  \
		-sticky w
	grid $base.entrySrecordfile -in $root	-row 3 -column 2 
	grid $base.entrySrecordentry -in $root	-row 3 -column 3 
	grid $base.checkbuttonIntelhex -in $root	-row 4 -column 1  \
		-sticky w
	grid $base.entryIntelhexfile -in $root	-row 4 -column 2 
	grid $base.entryIntelhexentry -in $root	-row 4 -column 3 
	grid $base.checkbuttonIeee695 -in $root	-row 5 -column 1  \
		-sticky w
	grid $base.entryIeee695file -in $root	-row 5 -column 2 
	grid $base.entryIeee695entry -in $root	-row 5 -column 3 

	# Resize behavior management

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 0 -minsize 30
	grid rowconfigure $root 3 -weight 0 -minsize 30
	grid rowconfigure $root 4 -weight 0 -minsize 30
	grid rowconfigure $root 5 -weight 0 -minsize 30
	grid rowconfigure $root 6 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 0 -minsize 30
	grid columnconfigure $root 4 -weight 1 -minsize 30
# additional interface code
# get the containing window
set w [lindex $args 0]
global code::Configure

code::help $w $base.labelOutputtype "Types of output files that can be created"
code::help $w $base.labelOutputfilename "Name of the output file to be created"
code::help $w $base.labelEntrypoint "Symbolic name of the entry point in the file"
set list {
    { Srecord "Create a file containing S-records"
      "The S-record output file name"
      "The S-record symbolic entry point" }
    { Intelhex "Create a file containing Intel hex"
      "The Intel hex output file name"
      "The Intel hex symbolic entry point" }
    { Ieee695 "Create a file containing an IEEE 695 object file"
      "The IEEE 695 output file name"
      "The IEEE 695 symbolic entry point" }
}

foreach elt $list {
    set name [lindex $elt 0]
    set code::Configure(System,$name) [code::Preference System $name]
    set code::Configure(System,${name}file) [code::Preference System ${name}file]
    set code::Configure(System,${name}entry) [code::Preference System ${name}entry]
    help $w $base.checkbutton$name [lindex $elt 1]
    help $w $base.entry${name}file [lindex $elt 2]
    help $w $base.entry${name}entry [lindex $elt 3]
    $base.checkbutton$name configure -command "code::PreferenceSetIfChanged System $name \$code::Configure(System,$name)"
    bind $base.entry${name}file <FocusOut> "code::PreferenceSetIfChanged System ${name}file \$code::Configure(System,${name}file)"
    bind $base.entry${name}file <Return> "code::PreferenceSetIfChanged System ${name}file \$code::Configure(System,${name}file)"
    bind $base.entry${name}entry <FocusOut> "code::PreferenceSetIfChanged System ${name}entry \$code::Configure(System,${name}entry)"
    bind $base.entry${name}entry <Return> "code::PreferenceSetIfChanged System ${name}entry \$code::Configure(System,${name}entry)"
}    
return "Set the object directory and specify optional output created by the project"







# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Output_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Output_ui"
	    Output_ui .
	}
    }
}
