#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Preferences/Command.ui
#   root     is the parent window for this user interface

proc Command_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#1 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#2 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#3

	frame $base.framePrompt

	label $base.label#1 \
		-text Colors

	label $base.label#2 \
		-text Fonts

	button $base.buttonPrompt \
		-text Prompt \
		-width 10

	button $base.buttonCommandFont \
		-text {Command Font} \
		-width 14

	button $base.buttonError \
		-text Error \
		-width 10

	button $base.buttonOutput \
		-text Output \
		-width 10

	label $base.labelPrompt \
		-text Prompt:

	entry $base.entryPrompt \
		-textvariable code::Configure(Command,prompt) \
		-width 40

	checkbutton $base.checkbuttonRecord \
		-text {Record build history} \
		-variable example_checkbutton

	checkbutton $base.checkbuttonRecorddebug \
		-text {Record debugger commands} \
		-variable example_checkbutton


	# Geometry management

	grid $base.frame#1 -in $root	-row 1 -column 1 
	grid $base.frame#2 -in $root	-row 1 -column 2  \
		-sticky n
	grid $base.frame#3 -in $root	-row 2 -column 1  \
		-columnspan 3 \
		-sticky ew
	grid $base.framePrompt -in $base.frame#3	-row 1 -column 1  \
		-sticky ew
	grid $base.label#1 -in $base.frame#1	-row 1 -column 1 
	grid $base.label#2 -in $base.frame#2	-row 1 -column 1 
	grid $base.buttonPrompt -in $base.frame#1	-row 2 -column 1 
	grid $base.buttonCommandFont -in $base.frame#2	-row 2 -column 1 
	grid $base.buttonError -in $base.frame#1	-row 3 -column 1 
	grid $base.buttonOutput -in $base.frame#1	-row 4 -column 1 
	grid $base.labelPrompt -in $base.framePrompt	-row 1 -column 1 
	grid $base.entryPrompt -in $base.framePrompt	-row 1 -column 2  \
		-sticky ew
	grid $base.checkbuttonRecord -in $base.frame#3	-row 2 -column 1  \
		-sticky w
	grid $base.checkbuttonRecorddebug -in $base.frame#3	-row 3 -column 1  \
		-sticky w

	# Resize behavior management

	grid rowconfigure $base.frame#2 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#3 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#3 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#3 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 1 -weight 1 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 0 -minsize 30
	grid rowconfigure $root 3 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 1 -minsize 30

	grid rowconfigure $base.framePrompt 1 -weight 0 -minsize 30
	grid columnconfigure $base.framePrompt 1 -weight 0 -minsize 30
	grid columnconfigure $base.framePrompt 2 -weight 1 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
    return
}

# get the containing window
set w [lindex $args 0]
global code::Configure

# set up color buttons
set list {
    buttonPrompt Prompt colorprompt "Color to display the command prompt"
    buttonError Error colorstderr "Color to display command error output"
    buttonOutput Output colorstdout "Color to display command output"
}

foreach {button name element help} $list {
    $base.$button config \
        -command "code::ConfigureColor $base $name Command $element $base.$button" \
        -fg [code::Preference Command $element]
    code::help $w $base.$button $help
}

# set up font buttons
set list {
    buttonCommandFont "Command Font" fontcommand "The command font"
}

foreach {button name element help} $list {
    $base.$button config \
        -command "code::ConfigureFont $base \"$name\" Command $element $base.$button"
    code::help $w $base.$button $help
 }

# the prompt
set code::Configure(Command,prompt) [code::Preference Command prompt]
code::help $w $base.entryPrompt {Change the command window prompt}
code::help $w $base.labelPrompt {Change the command window prompt}
bind $base.entryPrompt <FocusOut> "code::PreferenceSetIfChanged Command prompt \
    \[$base.entryPrompt get]"
bind $base.entryPrompt <Return> "code::PreferenceSetIfChanged Command prompt \
    \[$base.entryPrompt get]"

# the record button
global code::Configure
set code::Configure(Command,history) [code::Preference Command history]
$base.checkbuttonRecord config \
    -variable code::Configure(Command,history) \
    -command "code::Preference Command history \$code::Configure(Command,history)"
code::help $w $base.checkbuttonRecord \
    {Show executed build commands and results in the command window}

# the record debug button
global code::Configure
set code::Configure(Command,debugcommands) [code::Preference Command debugcommands]
$base.checkbuttonRecorddebug config \
    -variable code::Configure(Command,debugcommands) \
    -command "code::Preference Command debugcommands \$code::Configure(Command,debugcommands)"
code::help $w $base.checkbuttonRecorddebug \
    {Show executed debugger commands and results in the command window}
return "Configure the command window"










# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Command_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Command_ui"
	    Command_ui .
	}
    }
}
