#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Preferences/Debugger.ui
#   root     is the parent window for this user interface

proc Debugger_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#2 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#3

	frame $base.frameAutomatic \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#10 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#11 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#1 \
		-borderwidth 2 \
		-relief groove

	label $base.labelColors \
		-text Colors

	label $base.labelFonts \
		-text Fonts

	label $base.labelAutomatic \
		-text Automatic

	label $base.labelHandlers \
		-text Handlers

	button $base.buttonCurrent \
		-text Current \
		-width 10

	button $base.buttonFont \
		-text Font \
		-width 14

	checkbutton $base.checkbuttonOpen \
		-text Open \
		-variable code::Configure(Debugger,autoopen)

	checkbutton $base.checkbuttonHandleMain \
		-text main \
		-variable code::Configure(DebuggerInternal,atmain)

	button $base.buttonDisassembly \
		-text Disassembly \
		-width 10

	checkbutton $base.checkbuttonLoad \
		-text Load \
		-variable code::Configure(Debugger,autoload)

	checkbutton $base.checkbuttonHandleCIO \
		-state active \
		-text {C I/O} \
		-variable code::Configure(DebuggerInternal,breakio)

	button $base.buttonNormal \
		-text Normal \
		-width 10

	checkbutton $base.checkbuttonReload \
		-state active \
		-text Reload \
		-variable code::Configure(Debugger,autocheck)

	checkbutton $base.checkbuttonHandleExit \
		-text Exit \
		-variable code::Configure(DebuggerInternal,breakexit)

	button $base.buttonMixed \
		-text Mixed \
		-width 10

	checkbutton $base.checkbuttonReset \
		-text Reset \
		-variable code::Configure(Debugger,autoreset)

	button $base.buttonSelected \
		-text Selected \
		-width 10

	checkbutton $base.checkbuttonBuild \
		-text Build \
		-variable code::Configure(Debugger,autobuild)

	checkbutton $base.checkbuttonShowcycles \
		-text {Show cycles} \
		-variable code::Configure(Debugger,showcycles)

	label $base.labelTargetId \
		-text Target:

	menubutton $base.menubuttonTarget \
		-indicatoron 1 \
		-relief raised \
		-text {Choose a processor first} \
		-textvariable code::Configure(Debugger,targetname)


	# Geometry management

	grid $base.frame#2 -in $root	-row 1 -column 2  \
		-sticky n
	grid $base.frame#3 -in $root	-row 2 -column 1  \
		-columnspan 5 \
		-sticky ew
	grid $base.frameAutomatic -in $root	-row 1 -column 3  \
		-sticky n
	grid $base.frame#10 -in $root	-row 3 -column 1  \
		-columnspan 5 \
		-sticky ew
	grid $base.frame#11 -in $root	-row 1 -column 4  \
		-sticky n
	grid $base.frame#1 -in $root	-row 1 -column 1 
	grid $base.labelColors -in $base.frame#1	-row 1 -column 1 
	grid $base.labelFonts -in $base.frame#2	-row 1 -column 1 
	grid $base.labelAutomatic -in $base.frameAutomatic	-row 1 -column 1 
	grid $base.labelHandlers -in $base.frame#11	-row 1 -column 1 
	grid $base.buttonCurrent -in $base.frame#1	-row 2 -column 1 
	grid $base.buttonFont -in $base.frame#2	-row 2 -column 1 
	grid $base.checkbuttonOpen -in $base.frameAutomatic	-row 2 -column 1  \
		-sticky w
	grid $base.checkbuttonHandleMain -in $base.frame#11	-row 2 -column 1  \
		-sticky w
	grid $base.buttonDisassembly -in $base.frame#1	-row 3 -column 1 
	grid $base.checkbuttonLoad -in $base.frameAutomatic	-row 3 -column 1  \
		-sticky w
	grid $base.checkbuttonHandleCIO -in $base.frame#11	-row 3 -column 1  \
		-sticky w
	grid $base.buttonNormal -in $base.frame#1	-row 4 -column 1 
	grid $base.checkbuttonReload -in $base.frameAutomatic	-row 4 -column 1  \
		-sticky w
	grid $base.checkbuttonHandleExit -in $base.frame#11	-row 4 -column 1  \
		-sticky w
	grid $base.buttonMixed -in $base.frame#1	-row 5 -column 1 
	grid $base.checkbuttonReset -in $base.frameAutomatic	-row 5 -column 1  \
		-sticky w
	grid $base.buttonSelected -in $base.frame#1	-row 6 -column 1 
	grid $base.checkbuttonBuild -in $base.frameAutomatic	-row 6 -column 1  \
		-sticky w
	grid $base.checkbuttonShowcycles -in $base.frame#3	-row 1 -column 1  \
		-sticky w
	grid $base.labelTargetId -in $base.frame#10	-row 1 -column 1 
	grid $base.menubuttonTarget -in $base.frame#10	-row 1 -column 2  \
		-sticky ew

	# Resize behavior management

	grid rowconfigure $base.frameAutomatic 1 -weight 0 -minsize 30
	grid rowconfigure $base.frameAutomatic 2 -weight 0 -minsize 30
	grid rowconfigure $base.frameAutomatic 3 -weight 0 -minsize 30
	grid rowconfigure $base.frameAutomatic 4 -weight 0 -minsize 30
	grid rowconfigure $base.frameAutomatic 5 -weight 0 -minsize 30
	grid rowconfigure $base.frameAutomatic 6 -weight 0 -minsize 30
	grid columnconfigure $base.frameAutomatic 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#2 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#11 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#11 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#11 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#11 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#11 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#3 1 -weight 0 -minsize 2
	grid columnconfigure $base.frame#3 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 2 -weight 1 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 0 -minsize 32
	grid rowconfigure $root 3 -weight 0 -minsize 20
	grid rowconfigure $root 4 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 10
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 0 -minsize 30
	grid columnconfigure $root 4 -weight 0 -minsize 30
	grid columnconfigure $root 5 -weight 1 -minsize 30

	grid rowconfigure $base.frame#10 1 -weight 0 -minsize 2
	grid columnconfigure $base.frame#10 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#10 2 -weight 1 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 4 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 5 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 6 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
    return
}

# get the containing window
set w [lindex $args 0]
global code::Configure

# set up color buttons
set list {
    buttonCurrent Current colorcurrent "Color to display the currently executing source line"
    buttonDisassembly Disassembly colordisas "Color to display current disassembled line"
    buttonNormal Normal colornormal "Color to display normal text"
    buttonMixed Mixed colormixed "Color to display source in the Mixed window"
    buttonSelected Selected colorselect "Color to display a selected source line"
}

foreach {button name element help} $list {
    $base.$button config \
        -command "code::ConfigureColor $base $name Debugger $element $base.$button" \
        -fg [code::Preference Debugger $element]
    code::help $w $base.$button $help
}

# set up font buttons
set list {
    buttonFont "Command Font" font "The Debugger window font"
}

foreach {button name element help} $list {
    $base.$button config \
        -command "code::ConfigureFont $base \"$name\" Debugger $element $base.$button"
    code::help $w $base.$button $help
}

# the color source button
global code::Configure
# the show cycles button
set code::Configure(Debugger,showcycles) [code::Preference Debugger showcycles]
$base.checkbuttonShowcycles config \
    -command "code::Preference Debugger showcycles \$code::Configure(Debugger,showcycles)"
code::help $w $base.checkbuttonShowcycles \
    {Show processor cycles in the register window (Simulator only)}

# the handlers label
code::help $w $base.labelHandlers \
    {Standard program action handling}

# the handle main button
set code::Configure(DebuggerInternal,atmain) [code::Preference DebuggerInternal atmain]
$base.checkbuttonHandleMain config \
    -command "code::Preference DebuggerInternal atmain \$code::Configure(DebuggerInternal,atmain)"
code::help $w $base.checkbuttonHandleMain \
    {Set a breakpoint at the main() entry point}
# the handle C i/o button
set code::Configure(DebuggerInternal,breakio) [code::Preference DebuggerInternal breakio]
$base.checkbuttonHandleCIO config \
    -command "code::Preference DebuggerInternal breakio \$code::Configure(DebuggerInternal,breakio)"
code::help $w $base.checkbuttonHandleCIO \
    {Trap __io_read and __io_write in the Stdio window}
# the handle exit button
set code::Configure(DebuggerInternal,breakexit) [code::Preference DebuggerInternal breakexit]
$base.checkbuttonHandleExit config \
    -command "code::Preference DebuggerInternal breakexit \$code::Configure(DebuggerInternal,breakexit)"
code::help $w $base.checkbuttonHandleExit \
    {Trap the program at __exit}
# the Automatic buttons
code::help $w $base.labelAutomatic \
    {Automatic functions performed by the debugger}
# the open button
set code::Configure(Debugger,autoopen) [code::Preference Debugger autoopen]
$base.checkbuttonOpen config \
    -command "code::Preference Debugger autoopen \$code::Configure(Debugger,autoopen)"
code::help $w $base.checkbuttonOpen \
    {Automatically open project executable, if it exists}
# the load button
set code::Configure(Debugger,autoload) [code::Preference Debugger autoload]
$base.checkbuttonLoad config \
    -command "code::Preference Debugger autoload \$code::Configure(Debugger,autoload)"
code::help $w $base.checkbuttonLoad \
    {Automatically load project executable, if opened}
# the reload button
set code::Configure(Debugger,autocheck) [code::Preference Debugger autocheck]
$base.checkbuttonReload config \
    -command "code::Preference Debugger autocheck \$code::Configure(Debugger,autocheck)"
code::help $w $base.checkbuttonReload \
    {Automatically reload project executable, if it has changed}
# the reset button
set code::Configure(Debugger,autoreset) [code::Preference Debugger autoreset]
$base.checkbuttonReset config \
    -command "code::Preference Debugger autoreset \$code::Configure(Debugger,autoreset)"
code::help $w $base.checkbuttonReset \
    {Automatically reset the target when program is loaded}
# the build button
set code::Configure(Debugger,autobuild) [code::Preference Debugger autobuild]
$base.checkbuttonBuild config \
    -command "code::Preference Debugger autobuild \$code::Configure(Debugger,autobuild)"
code::help $w $base.checkbuttonBuild \
    {Automatically build the program if changed when target is reset}

# set up the target control
code::help $w $base.labelTargetId \
    {The debugger target environment}
code::help $w $base.menubuttonTarget \
    {Change the debugger target environment}
$base.menubuttonTarget config \
    -menu [code::PreferenceTargetMenu $base.menubuttonTarget.target] \
    -direction flush

return "Configure the execute/debug environment"
















# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Debugger_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Debugger_ui"
	    Debugger_ui .
	}
    }
}
