#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Preferences/Directory.ui
#   root     is the parent window for this user interface

proc Directory_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#2 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#3

	frame $base.frame#1 \
		-borderwidth 2 \
		-relief groove

	label $base.label#1 \
		-text Colors

	label $base.label#2 \
		-text Fonts

	button $base.buttonEntries \
		-text Entries \
		-width 10

	button $base.buttonEntryFont \
		-text {Entry Font} \
		-width 14

	button $base.buttonProject \
		-text Project \
		-width 10

	button $base.buttonLibraries \
		-state active \
		-text Libraries \
		-width 10

	button $base.buttonSubprojects \
		-text Sub-Projects \
		-width 10

	button $base.buttonMissing \
		-text Missing \
		-width 10

	checkbutton $base.checkbuttonShowall \
		-text {Show all project files in directory window} \
		-variable code::Configure(Directory,showproject)

	checkbutton $base.checkbuttonRegular \
		-text {Show regular files that are not in the project} \
		-variable code::Configure(Directory,showregular)

	checkbutton $base.checkbuttonRemember \
		-text {Remember last directory} \
		-variable code::Configure(Directory,gotolastdir)


	# Geometry management

	grid $base.frame#2 -in $root	-row 1 -column 2  \
		-sticky n
	grid $base.frame#3 -in $root	-row 2 -column 1  \
		-columnspan 3 \
		-sticky w
	grid $base.frame#1 -in $root	-row 1 -column 1 
	grid $base.label#1 -in $base.frame#1	-row 1 -column 1 
	grid $base.label#2 -in $base.frame#2	-row 1 -column 1 
	grid $base.buttonEntries -in $base.frame#1	-row 2 -column 1 
	grid $base.buttonEntryFont -in $base.frame#2	-row 2 -column 1 
	grid $base.buttonProject -in $base.frame#1	-row 3 -column 1 
	grid $base.buttonLibraries -in $base.frame#1	-row 4 -column 1 
	grid $base.buttonSubprojects -in $base.frame#1	-row 5 -column 1 
	grid $base.buttonMissing -in $base.frame#1	-row 6 -column 1 
	grid $base.checkbuttonShowall -in $base.frame#3	-row 1 -column 1  \
		-sticky w
	grid $base.checkbuttonRegular -in $base.frame#3	-row 2 -column 1  \
		-sticky w
	grid $base.checkbuttonRemember -in $base.frame#3	-row 3 -column 1  \
		-sticky w

	# Resize behavior management

	grid rowconfigure $base.frame#2 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#3 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#3 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#3 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 1 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 0 -minsize 30
	grid rowconfigure $root 3 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 1 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 4 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 5 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 6 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
    return
}

# get the containing window
set w [lindex $args 0]
global code::Configure

# set up color buttons
set list {
    buttonEntries Entries colorentry "Color to display directory entries"
    buttonProject Project colorproject "Color to display project members"
    buttonLibraries Libraries colorlibrary "Color to display project libraries"
    buttonSubprojects Sub-Projects colorsubproject "Color to display project sub-projects"
    buttonMissing Missing colormissing "Color to display missing project members"
}

foreach {button name element help} $list {
    $base.$button config \
        -command "code::ConfigureColor $base $name Directory $element $base.$button" \
        -fg [code::Preference Directory $element]
    code::help $w $base.$button $help
}

# set up font buttons
set list {
    buttonEntryFont "Entry Font" fontdirectory "The directory entry font"
}

foreach {button name element help} $list {
    $base.$button config \
        -command "code::ConfigureFont $base \"$name\" Directory $element $base.$button"
    code::help $w $base.$button $help
}

# the show all button
set code::Configure(Directory,showproject) [Preference Directory showproject]
$base.checkbuttonShowall config -command \
    "code::Preference Directory showproject \$code::Configure(Directory,showproject)"
code::help $w $base.checkbuttonShowall \
    {Show all project files in directory window}

# the show regular button
set code::Configure(Directory,showregular) [Preference Directory showregular]
$base.checkbuttonRegular config -command \
    "code::Preference Directory showregular \$code::Configure(Directory,showregular)"
code::help $w $base.checkbuttonRegular \
    {Show all non project files in directory window}

# the remember button
set code::Configure(Directory,gotolastdir) [Preference Directory gotolastdir]
$base.checkbuttonRemember config -command \
    "code::Preference Directory gotolastdir \$code::Configure(Directory,gotolastdir)"
code::help $w $base.checkbuttonRemember \
    {Remember the last project opened or visited directory}


return "Configure the directory browser"












# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Directory_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Directory_ui"
	    Directory_ui .
	}
    }
}
