#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Preferences/Editor.ui
#   root     is the parent window for this user interface

proc Editor_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#1 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#2 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#3

	frame $base.frame#9

	frame $base.frameWrapMode \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#7

	frame $base.frame#6

	frame $base.frame#8

	label $base.label#1 \
		-text Colors

	label $base.label#2 \
		-text Fonts

	button $base.buttonErrors \
		-text Errors \
		-width 10

	button $base.buttonEditorFont \
		-text {Editor Font} \
		-width 14

	button $base.buttonWarnings \
		-text Warnings \
		-width 10

	button $base.buttonNormal \
		-text Normal \
		-width 10

	button $base.buttonThisError \
		-text {This Error} \
		-width 10

	label $base.labelWrapMode \
		-text {Wrap Mode:}

	radiobutton $base.radiobuttonCharacter \
		-text Character \
		-value char \
		-variable code::Configure(Editor,modewrap)

	radiobutton $base.radiobuttonWord \
		-text Word \
		-value word \
		-variable code::Configure(Editor,modewrap)

	radiobutton $base.radiobuttonNowrap \
		-text {No wrap} \
		-value none \
		-variable code::Configure(Editor,modewrap)

	checkbutton $base.checkbuttonColorsource \
		-text {Color source} \
		-variable code::Configure(Editor,showcolors)

	label $base.labelTabs \
		-text Tabs:

	entry $base.entryTabs \
		-textvariable code::Configure(Editor,tabs) \
		-width 3

	checkbutton $base.checkbuttonAutoreload \
		-text {Auto reload} \
		-variable code::Configure(Editor,autoreload)

	checkbutton $base.checkbuttonAutoindent \
		-text {Auto indent} \
		-variable code::Configure(Editor,autoindent)

	checkbutton $base.checkbuttonErrorlist \
		-text {Show build error list in editor} \
		-variable code::Configure(Editor,showerrors)


	# Geometry management

	grid $base.frame#1 -in $root	-row 1 -column 1 
	grid $base.frame#2 -in $root	-row 1 -column 2  \
		-sticky n
	grid $base.frame#3 -in $root	-row 2 -column 1  \
		-columnspan 3 \
		-sticky w
	grid $base.frame#9 -in $root	-row 3 -column 2  \
		-sticky w
	grid $base.frameWrapMode -in $base.frame#3	-row 1 -column 1  \
		-sticky w
	grid $base.frame#7 -in $base.frame#3	-row 2 -column 1  \
		-sticky w
	grid $base.frame#6 -in $base.frameWrapMode	-row 1 -column 1  \
		-sticky w
	grid $base.frame#8 -in $base.frame#7	-row 1 -column 3 
	grid $base.label#1 -in $base.frame#1	-row 1 -column 1 
	grid $base.label#2 -in $base.frame#2	-row 1 -column 1 
	grid $base.buttonErrors -in $base.frame#1	-row 2 -column 1 
	grid $base.buttonEditorFont -in $base.frame#2	-row 2 -column 1 
	grid $base.buttonWarnings -in $base.frame#1	-row 3 -column 1 
	grid $base.buttonNormal -in $base.frame#1	-row 4 -column 1 
	grid $base.buttonThisError -in $base.frame#1	-row 5 -column 1 
	grid $base.labelWrapMode -in $base.frame#6	-row 1 -column 1 
	grid $base.radiobuttonCharacter -in $base.frame#6	-row 1 -column 2 
	grid $base.radiobuttonWord -in $base.frame#6	-row 1 -column 3 
	grid $base.radiobuttonNowrap -in $base.frame#6	-row 1 -column 4 
	grid $base.checkbuttonColorsource -in $base.frame#7	-row 1 -column 1 
	grid $base.labelTabs -in $base.frame#8	-row 1 -column 1 
	grid $base.entryTabs -in $base.frame#8	-row 1 -column 2 
	grid $base.checkbuttonAutoreload -in $root	-row 3 -column 1  \
		-sticky w
	grid $base.checkbuttonAutoindent -in $base.frame#9	-row 1 -column 1 
	grid $base.checkbuttonErrorlist -in $root	-row 4 -column 1  \
		-columnspan 2 \
		-sticky w

	# Resize behavior management

	grid rowconfigure $base.frame#2 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#6 1 -weight 0 -minsize 4
	grid columnconfigure $base.frame#6 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 4 -weight 0 -minsize 30

	grid rowconfigure $base.frame#7 1 -weight 0 -minsize 2
	grid columnconfigure $base.frame#7 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 3 -weight 0 -minsize 30

	grid rowconfigure $base.frame#3 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#3 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#8 1 -weight 0 -minsize 10
	grid columnconfigure $base.frame#8 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#8 2 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 0 -minsize 16
	grid rowconfigure $root 3 -weight 0 -minsize 2
	grid rowconfigure $root 4 -weight 0 -minsize 30
	grid rowconfigure $root 5 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 1 -minsize 30

	grid rowconfigure $base.frame#9 1 -weight 0 -minsize 6
	grid columnconfigure $base.frame#9 1 -weight 0 -minsize 30

	grid rowconfigure $base.frameWrapMode 1 -weight 0 -minsize 30
	grid columnconfigure $base.frameWrapMode 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 4 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 5 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
    return
}

# get the containing window
set w [lindex $args 0]
global code::Configure

# set up color buttons
set list {
    buttonErrors Errors colorerror "Color to display source lines with errors"
    buttonWarnings Warnings colorwarning "Color to display source lines with warnings"
    buttonNormal Normal colornormal "Color to display normal text"
    buttonThisError "This Error" colorcurrent "Color to display the current source line with errors"
}

foreach {button name element help} $list {
    $base.$button config \
        -command "code::ConfigureColor $base \"$name\" Editor $element $base.$button" \
        -fg [code::Preference Editor $element]
    code::help $w $base.$button $help
}

# set up font buttons
set list {
    buttonEditorFont "Editor Font" fonteditor "The editor font"
}

foreach {button name element help} $list {
    $base.$button config \
        -command "code::ConfigureFont $base \"$name\" Editor $element $base.$button"
    code::help $w $base.$button $help
}

# the tab setting
set code::Configure(Editor,tabs) [code::Preference Editor tabs]
code::help $w $base.entryTabs \
    {Set the number of characters between tab stops}
bind $base.entryTabs <FocusOut> "code::PreferenceSetIfChanged Editor tabs \
    \$code::Configure(Editor,tabs)"
bind $base.entryTabs <Return> "code::PreferenceSetIfChanged Editor tabs \
    \$code::Configure(Editor,tabs)"
code::help $w $base.labelTabs \
    {Set the number of characters between tab stops}

# the color source button
set code::Configure(Editor,showcolors) [code::Preference Editor showcolors]
$base.checkbuttonColorsource config \
    -variable code::Configure(Editor,showcolors) \
    -command "code::Preference Editor showcolors \$code::Configure(Editor,showcolors)"
code::help $w $base.checkbuttonColorsource \
    {Color the syntax elements in a source file}

# the editor wrap mode selector
set code::Configure(Editor,modewrap) [code::Preference Editor modewrap]
$base.radiobuttonCharacter config \
    -command "code::Preference Editor modewrap \$code::Configure(Editor,modewrap)"
code::help $w $base.radiobuttonCharacter \
    {Wrap long lines at character boundries}
$base.radiobuttonWord config \
    -command "code::Preference Editor modewrap \$code::Configure(Editor,modewrap)"
code::help $w $base.radiobuttonWord \
    {Wrap long lines at word boundries}
$base.radiobuttonNowrap config \
    -command "code::Preference Editor modewrap \$code::Configure(Editor,modewrap)"
code::help $w $base.radiobuttonNowrap \
    {Do not wrap long lines}
code::help $w $base.labelWrapMode \
    {Configure the editor wrap mode}

# the auto reload button
set code::Configure(Editor,autoreload) [code::Preference Editor autoreload]
$base.checkbuttonAutoreload config \
    -variable code::Configure(Editor,autoreload) \
    -command "code::Preference Editor autoreload \$code::Configure(Editor,autoreload)"
code::help $w $base.checkbuttonAutoreload \
    {Automatically reload files that have changed on the disk}

# the auto indent button
set code::Configure(Editor,autoindent) [code::Preference Editor autoindent]
$base.checkbuttonAutoindent config \
    -variable code::Configure(Editor,autoindent) \
    -command "code::Preference Editor autoindent \$code::Configure(Editor,autoindent)"
code::help $w $base.checkbuttonAutoindent \
    {Automatically match the indentation of the previous line}

# the error list button
set code::Configure(Editor,showerrors) [code::Preference Editor showerrors]
$base.checkbuttonErrorlist config \
    -variable code::Configure(Editor,showerrors) \
    -command "code::Preference Editor showerrors \$code::Configure(Editor,showerrors)"
code::help $w $base.checkbuttonErrorlist \
    {Show a list of all build errors in an edit window when they occur}

return "Configure the editor"





# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Editor_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Editor_ui"
	    Editor_ui .
	}
    }
}
