#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Preferences/General.ui
#   root     is the parent window for this user interface

proc General_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#1 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#2 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#3

	label $base.label#1 \
		-text Colors

	label $base.label#2 \
		-text Fonts

	button $base.buttonReserved \
		-text Reserved \
		-width 10

	button $base.buttonSelection \
		-text Selection \
		-width 10

	button $base.buttonStatusFont \
		-text {Status Font} \
		-width 14

	button $base.buttonString \
		-text String \
		-width 10

	button $base.buttonConstant \
		-text Constant \
		-width 10

	button $base.buttonIdentifier \
		-text Identifier \
		-width 10

	button $base.buttonDirective \
		-text Directive \
		-width 10

	button $base.buttonOperator \
		-text Operator \
		-width 10

	button $base.buttonMacro \
		-text Macro \
		-width 10

	button $base.buttonComment \
		-text Comment \
		-width 10

	button $base.buttonSkipped \
		-text Skipped \
		-width 10

	button $base.buttonBackground \
		-text Background \
		-width 10

	button $base.buttonBraces \
		-text Braces \
		-width 10

	button $base.buttonStatus \
		-text Status \
		-width 10

	label $base.labelBracehighlighttime \
		-text {Brace highlight time:}

	entry $base.entryBracehighlighttime \
		-cursor {} \
		-textvariable code::Configure(General,bracetime) \
		-width 6


	# Geometry management

	grid $base.frame#1 -in $root	-row 1 -column 1 
	grid $base.frame#2 -in $root	-row 1 -column 2  \
		-sticky nw
	grid $base.frame#3 -in $root	-row 2 -column 1  \
		-sticky w
	grid $base.label#1 -in $base.frame#1	-row 1 -column 1  \
		-columnspan 2
	grid $base.label#2 -in $base.frame#2	-row 1 -column 1 
	grid $base.buttonReserved -in $base.frame#1	-row 2 -column 1 
	grid $base.buttonSelection -in $base.frame#1	-row 2 -column 2 
	grid $base.buttonStatusFont -in $base.frame#2	-row 2 -column 1 
	grid $base.buttonString -in $base.frame#1	-row 3 -column 1 
	grid $base.buttonConstant -in $base.frame#1	-row 3 -column 2 
	grid $base.buttonIdentifier -in $base.frame#1	-row 4 -column 1 
	grid $base.buttonDirective -in $base.frame#1	-row 4 -column 2 
	grid $base.buttonOperator -in $base.frame#1	-row 5 -column 1 
	grid $base.buttonMacro -in $base.frame#1	-row 5 -column 2 
	grid $base.buttonComment -in $base.frame#1	-row 6 -column 1 
	grid $base.buttonSkipped -in $base.frame#1	-row 6 -column 2 
	grid $base.buttonBackground -in $base.frame#1	-row 7 -column 1  \
		-sticky ew
	grid $base.buttonBraces -in $base.frame#1	-row 7 -column 2 
	grid $base.buttonStatus -in $base.frame#1	-row 8 -column 1 
	grid $base.labelBracehighlighttime -in $base.frame#3	-row 1 -column 1 
	grid $base.entryBracehighlighttime -in $base.frame#3	-row 1 -column 2 

	# Resize behavior management

	grid rowconfigure $base.frame#2 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#3 1 -weight 0 -minsize 12
	grid columnconfigure $base.frame#3 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 2 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 0 -minsize 8
	grid rowconfigure $root 3 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 0 -minsize 30
	grid columnconfigure $root 4 -weight 1 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 4 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 5 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 6 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 7 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 8 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 2 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
    return
}

# get the containing window
set w [lindex $args 0]
global code::Configure

# set up color buttons
set list {
    buttonReserved Reserved colorreserved "Color to display reserved words/opcodes"
    buttonSelection Selection colorselection "Color to display selected text"
    buttonString String colorstring "Color to display strings"
    buttonConstant Constant colorconstant "Color to display constants"
    buttonIdentifier Identifier coloridentifier "Color to display identifiers and labels"
    buttonOperator Operands coloroperator "Color to display operators and operands"
    buttonComment Comment colorcomment "Color to display comments"
    buttonBackground Background colorbackground "Color of window backgrounds"
    buttonStatus Status colorstatusbackground "Color of window status line backgrounds"
    buttonDirective Directive colorppdirective "Color to display pre-processor directives"
    buttonMacro Macro colormacro "Color to display macro calls"
    buttonSkipped Skipped colorskipped "Color to display missing include files and conditionally skipped code"
    buttonBraces Braces colorbrace "Color to highlight matching braces"
}

foreach {button name element help} $list {
    $base.$button config \
        -command "code::ConfigureColor $base $name General $element $base.$button" \
        -fg [code::Preference General $element]
    code::help $w $base.$button $help
}

# set up font buttons
set list {
    buttonStatusFont "Status Font" fontstatus "The default status bar font"
}

foreach {button name element help} $list {
    $base.$button config \
        -command "code::ConfigureFont $base \"$name\" General $element $base.$button"
    code::help $w $base.$button $help
}

# the brace highlight time setting
set code::Configure(General,bracetime) [code::Preference General bracetime]
code::help $w $base.entryBracehighlighttime \
    {Set the time to highlight braces in milliseconds}
bind $base.entryBracehighlighttime <FocusOut> "code::PreferenceSetIfChanged General bracetime \
    \$code::Configure(General,bracetime)"
bind $base.entryBracehighlighttime <Return> "code::PreferenceSetIfChanged General bracetime \
    \$code::Configure(General,bracetime)"
code::help $w $base.labelBracehighlighttime \
    {Set the time to highlight braces in milliseconds}

return "Configure general CODE preferences"





























# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	General_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing General_ui"
	    General_ui .
	}
    }
}
