#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Preferences/Manual.ui
#   root     is the parent window for this user interface

proc Manual_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#2 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#1 \
		-borderwidth 2 \
		-relief groove

	label $base.label#1 \
		-text Colors

	label $base.label#2 \
		-text Fonts

	button $base.buttonLinks \
		-text Links \
		-width 10

	button $base.buttonVariableFont \
		-text {Variable Font} \
		-width 14

	button $base.buttonFixedFont \
		-text {Fixed Font} \
		-width 14


	# Geometry management

	grid $base.frame#2 -in $root	-row 1 -column 2 
	grid $base.frame#1 -in $root	-row 1 -column 1  \
		-sticky n
	grid $base.label#1 -in $base.frame#1	-row 1 -column 1 
	grid $base.label#2 -in $base.frame#2	-row 1 -column 1 
	grid $base.buttonLinks -in $base.frame#1	-row 2 -column 1 
	grid $base.buttonVariableFont -in $base.frame#2	-row 2 -column 1 
	grid $base.buttonFixedFont -in $base.frame#2	-row 3 -column 1 

	# Resize behavior management

	grid rowconfigure $base.frame#2 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 1 -weight 1 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 1 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
    return
}

# get the containing window
set w [lindex $args 0]
global code::Configure

# set up color buttons
set list {
    buttonLinks Links colorlink "Color to display hypertext links"
}

foreach {button name element help} $list {
    $base.$button config \
        -command "code::ConfigureColor $base $name Manual $element $base.$button" \
        -fg [code::Preference Manual $element]
    code::help $w $base.$button $help
}

# set up font buttons
set list {
    buttonVariableFont "Variable Font" fontproportional "The variable spacing font"
    buttonFixedFont "Fixed Font" fontfixed "The fixed spacing font"
}

foreach {button name element help} $list {
    $base.$button config \
        -command "code::ConfigureFont $base \"$name\" Manual $element $base.$button"
    code::help $w $base.$button $help
}

return "Configure the manual browser"








# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Manual_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Manual_ui"
	    Manual_ui .
	}
    }
}
