#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/QSM.ui
#   root     is the parent window for this user interface

proc QSM_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#8 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#1 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#2

	frame $base.frame#7

	frame $base.frame#10

	frame $base.frame#11

	frame $base.frame#12

	frame $base.frameIARB

	frame $base.frameILSCI

	frame $base.frameILQSPI

	label $base.labelOption \
		-text {QSM Module Configuration}

	label $base.label#7 \
		-text Interrupts

	label $base.labelIARB \
		-text {Interrupt arbitration:}

	label $base.labelQIVR \
		-text Vector:

	entry $base.entryQIVR \
		-textvariable QSM(QIVRinit) \
		-width 0

	label $base.labelILSCI \
		-text {SCI interrupt level:}

	checkbutton $base.checkbuttonSTOP \
		-command QSMSave \
		-maskvalue 32768 \
		-onvalue 0x8000 \
		-text STOP \
		-variable QSM(QMCRinit)

	checkbutton $base.checkbuttonFRZ1 \
		-command QSMSave \
		-maskvalue 16384 \
		-onvalue 0x4000 \
		-text FRZ1 \
		-variable QSM(QMCRinit)

	checkbutton $base.checkbuttonFRZ0 \
		-command QSMSave \
		-maskvalue 8192 \
		-onvalue 0x2000 \
		-text FRZ0 \
		-variable QSM(QMCRinit)

	checkbutton $base.checkbuttonSUPV \
		-command QSMSave \
		-maskvalue 128 \
		-onvalue 0x0080 \
		-text SUPV \
		-variable QSM(QMCRinit)

	label $base.labelILQSPI \
		-text {QSPI interrupt level:}


	# Geometry management

	grid $base.frame#8 -in $root	-row 1 -column 2  \
		-sticky n
	grid $base.frame#1 -in $root	-row 1 -column 1  \
		-sticky n
	grid $base.frame#2 -in $base.frame#1	-row 3 -column 1 
	grid $base.frame#7 -in $base.frame#1	-row 2 -column 1 
	grid $base.frame#10 -in $base.frame#8	-row 2 -column 1 
	grid $base.frame#11 -in $base.frame#10	-row 1 -column 1  \
		-sticky ew
	grid $base.frame#12 -in $base.frame#10	-row 2 -column 1  \
		-sticky ew
	grid $base.frameIARB -in $base.frame#7	-row 1 -column 2 
	grid $base.frameILSCI -in $base.frame#12	-row 1 -column 2 
	grid $base.frameILQSPI -in $base.frame#12	-row 2 -column 2 
	grid $base.labelOption -in $base.frame#1	-row 1 -column 1 
	grid $base.label#7 -in $base.frame#8	-row 1 -column 1 
	grid $base.labelIARB -in $base.frame#7	-row 1 -column 1 
	grid $base.labelQIVR -in $base.frame#11	-row 1 -column 1 
	grid $base.entryQIVR -in $base.frame#11	-row 1 -column 2  \
		-sticky ew
	grid $base.labelILSCI -in $base.frame#12	-row 1 -column 1  \
		-sticky e
	grid $base.checkbuttonSTOP -in $base.frame#2	-row 1 -column 1  \
		-sticky w
	grid $base.checkbuttonFRZ1 -in $base.frame#2	-row 1 -column 2  \
		-sticky w
	grid $base.checkbuttonFRZ0 -in $base.frame#2	-row 1 -column 3  \
		-sticky w
	grid $base.checkbuttonSUPV -in $base.frame#2	-row 2 -column 1  \
		-sticky w
	grid $base.labelILQSPI -in $base.frame#12	-row 2 -column 1  \
		-sticky e

	# Resize behavior management

	grid rowconfigure $base.frame#2 1 -weight 0 -minsize 13
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 9
	grid columnconfigure $base.frame#2 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 3 -weight 0 -minsize 30

	grid rowconfigure $base.frame#11 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#11 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#11 2 -weight 1 -minsize 30

	grid rowconfigure $base.frame#7 1 -weight 0 -minsize 16
	grid columnconfigure $base.frame#7 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#12 1 -weight 0 -minsize 5
	grid rowconfigure $base.frame#12 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#12 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#12 2 -weight 1 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 0 -minsize 30
	grid rowconfigure $root 3 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 1 -minsize 30

	grid rowconfigure $base.frame#8 1 -weight 0 -minsize 16
	grid rowconfigure $base.frame#8 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#8 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#10 1 -weight 0 -minsize 17
	grid rowconfigure $base.frame#10 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#10 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 10
	grid rowconfigure $base.frame#1 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
 
    proc QSMSave {} {}
    return
}

global QSM
global code::Configure

set w [lindex $args 0]
set title [lindex $args 1]
set QSM(NAME) "Set up the [lindex $title 1]"

foreach name "QMCR QILR QIVR" {
    set QSM($name) $Configure(Registers,$name)
    if {$QSM($name) == {}} {
        set QSM($name) 0
    }
}
set QSM(QMCRinit) $QSM(QMCR)
set o $QSM(QMCRinit)
set QSM(IARB) [expr $o & 0x000F]
set QSM(QILRinit) $QSM(QILR)
set o $QSM(QILRinit)
set QSM(ILQSPI) [expr ($o & 0x38) >> 3]
set QSM(ILSCI) [expr ($o & 0x07)]
set QSM(QIVRinit) $QSM(QIVR)

proc ::QSMSave {args} {
    global QSM
    global code::Configure

    set QSM(QMCRinit) [format "0x%04X" \
        [expr ($QSM(QMCRinit) & ~0x0F)| $QSM(IARB)]]
    set QSM(QMCR) $QSM(QMCRinit)

    set QSM(QILRinit) [format "0x%02X" \
        [expr ($QSM(ILQSPI) << 3) | $QSM(ILSCI)]]
    set QSM(QILR) $QSM(QILRinit)

    set QSM(QIVRinit) [format "%d" \
        [expr $QSM(QIVRinit) & 0xFF]]
    set QSM(QIVR) $QSM(QIVRinit)

    foreach name "QMCR QILR QIVR" {
        if {$QSM($name) != 0 || $Configure(Registers,$name) != {}} {
            code::DdfSetRegister $name QSM($name)
            set Configure(Registers,$name) $QSM($name)
        }
    }

}

set w [lindex $args 0]

combobox $base.frameIARB.combo \
    -maxheight 0 \
    -width 3 \
    -textvariable QSM(IARB) \
    -editable false \
    -command QSMSave

code::help $w $base.frameIARB.combo "Queued serial module interrupt arbitration priority"
code::help $w $base.labelIARB "Queued serial module interrupt arbitration priority"
grid $base.frameIARB.combo -in $base.frameIARB
foreach number {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15} {
    $base.frameIARB.combo list insert end $number
}

code::help $w $base.checkbuttonSUPV "Put integration module in supervisor data space"
code::help $w $base.checkbuttonFRZ0 "Reserved for future use"
code::help $w $base.checkbuttonFRZ1 "Halt the QSPI when FREEZE asserted"
code::help $w $base.checkbuttonSTOP "Stop the queued serial module clock"

code::help $w $base.labelQIVR "The QSM interrupt vector (For SCI, QSPI is vector + 1)"
code::help $w $base.entryQIVR "The QSM interrupt vector (For SCI, QSPI is vector + 1)"
bind $base.entryQIVR <FocusOut> "QSMSave"
bind $base.entryQIVR <Return> "QSMSave"

combobox $base.frameILSCI.combo \
    -maxheight 0 \
    -width 3 \
    -textvariable QSM(ILSCI) \
    -editable false \
    -command QSMSave
code::help $w $base.frameILSCI.combo "SCI interrupt priority level"
code::help $w $base.labelILSCI "SCI interrupt priority level"
grid $base.frameILSCI.combo -in $base.frameILSCI
foreach number {0 1 2 3 4 5 6 7} {
    $base.frameILSCI.combo list insert end $number
}

combobox $base.frameILQSPI.combo \
    -maxheight 0 \
    -width 3 \
    -textvariable QSM(ILQSPI) \
    -editable false \
    -command QSMSave
code::help $w $base.frameILQSPI.combo "QSPI interrupt priority level"
code::help $w $base.labelILQSPI "QSPI interrupt priority level"
grid $base.frameILQSPI.combo -in $base.frameILQSPI
foreach number {0 1 2 3 4 5 6 7} {
    $base.frameILQSPI.combo list insert end $number
}


QSMSave
return $title


























# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	QSM_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing QSM_ui"
	    QSM_ui .
	}
    }
}
