#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Registers.ui
#   root     is the parent window for this user interface

proc Registers_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#4 \
		-borderwidth 2 \
		-relief groove

	label $base.label#2 \
		-text {Initial values of device registers}

	canvas $base.canvasRegisters \
		-height 0 \
		-selectbackground #c3c3c3 \
		-selectforeground Black \
		-width 0 \
		-yscrollcommand "$base.scrollbar#2 set"

	scrollbar $base.scrollbar#2 \
		-command "$base.canvasRegisters yview" \
		-orient v


	# Geometry management

	grid $base.frame#4 -in $root	-row 2 -column 1  \
		-columnspan 3 \
		-sticky nesw
	grid $base.label#2 -in $root	-row 1 -column 1  \
		-columnspan 3
	grid $base.canvasRegisters -in $base.frame#4	-row 1 -column 1  \
		-sticky nesw
	grid $base.scrollbar#2 -in $base.frame#4	-row 1 -column 2  \
		-sticky ns

	# Resize behavior management

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 1 -minsize 30

	grid rowconfigure $base.frame#4 1 -weight 1 -minsize 30
	grid columnconfigure $base.frame#4 1 -weight 1 -minsize 30
	grid columnconfigure $base.frame#4 2 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
    return
}

# get the containing window
set w [lindex $args 0]
global code::Configure


# create a frame for the registers
set c $base.canvasRegisters
set row 0
set f [frame $c.f]
set id [$c create window 0 0 -window $f]

set list [code::DdfGetRegisterList]
foreach name $list {
    set info [code::DdfGetRegisterInfo $name]
    set command [lindex $info 0]
    if {[string match space* $command]} {
        # no arrays
        continue
    }
    set value [lindex $info 1]
    set description [lindex $info 2]
    set l [label $f.l$row -text $name -width 20 -anchor e]
    set e [entry $f.e$row \
        -textvariable code::Configure(Registers,$name) \
        -width 12]
    bind $e <FocusOut> "code::DdfSetRegister $name code::Configure(Registers,$name)"
    bind $e <Return> "code::DdfSetRegister $name code::Configure(Registers,$name)"
    grid $l -in $f -row $row -column 1
    grid $e -in $f -row $row -column 2 -sticky ew
    set l [label $f.d$row -text $description -anchor w]
    grid $l -in $f -row $row -column 3 -sticky w

    incr row
}

grid columnconfigure $f 2 -weight 1

update idletasks
set bbox [$c bbox $id]
set width [expr [lindex $bbox 2] - [lindex $bbox 0]]
$c config -scrollregion $bbox -width $width
$c xview moveto 0
$c yview moveto 0
 
return "Set the initial values of the system device registers"














# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Registers_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Registers_ui"
	    Registers_ui .
	}
    }
}
