#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/SCI.ui
#   root     is the parent window for this user interface

proc SCI_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#2 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#3

	frame $base.frame#7

	label $base.labelConfigurationValues \
		-text {SCI Configuration Values}

	checkbutton $base.checkbuttonSBK \
		-command IOSave \
		-maskvalue 1 \
		-onvalue 0x0001 \
		-state active \
		-text SBK \
		-variable IO(_CPU32_SCCR1init)

	checkbutton $base.checkbuttonRWU \
		-command IOSave \
		-maskvalue 2 \
		-onvalue 0x0002 \
		-text RWU \
		-variable IO(_CPU32_SCCR1init)

	checkbutton $base.checkbuttonRE \
		-command IOSave \
		-maskvalue 4 \
		-onvalue 0x0004 \
		-text RE \
		-variable IO(_CPU32_SCCR1init)

	checkbutton $base.checkbuttonTE \
		-command IOSave \
		-maskvalue 8 \
		-onvalue 0x0008 \
		-text TE \
		-variable IO(_CPU32_SCCR1init)

	checkbutton $base.checkbuttonILIE \
		-command IOSave \
		-maskvalue 16 \
		-onvalue 0x0010 \
		-text ILIE \
		-variable IO(_CPU32_SCCR1init)

	checkbutton $base.checkbuttonRIE \
		-command IOSave \
		-maskvalue 32 \
		-onvalue 0x0020 \
		-text RIE \
		-variable IO(_CPU32_SCCR1init)

	checkbutton $base.checkbuttonTCIE \
		-command IOSave \
		-maskvalue 64 \
		-onvalue 0x0040 \
		-text TCIE \
		-variable IO(_CPU32_SCCR1init)

	checkbutton $base.checkbuttonTIE \
		-command IOSave \
		-maskvalue 128 \
		-onvalue 0x0080 \
		-text TIE \
		-variable IO(_CPU32_SCCR1init)

	checkbutton $base.checkbuttonWAKE \
		-command IOSave \
		-maskvalue 256 \
		-onvalue 0x0100 \
		-text WAKE \
		-variable IO(_CPU32_SCCR1init)

	checkbutton $base.checkbuttonM \
		-command IOSave \
		-maskvalue 512 \
		-onvalue 0x0200 \
		-text M \
		-variable IO(_CPU32_SCCR1init)

	checkbutton $base.checkbuttonPE \
		-command IOSave \
		-maskvalue 1024 \
		-onvalue 0x0400 \
		-text PE \
		-variable IO(_CPU32_SCCR1init)

	checkbutton $base.checkbuttonPT \
		-command IOSave \
		-maskvalue 2048 \
		-onvalue 0x0800 \
		-text PT \
		-variable IO(_CPU32_SCCR1init)

	checkbutton $base.checkbuttonILT \
		-command IOSave \
		-maskvalue 4096 \
		-onvalue 0x1000 \
		-text ILT \
		-variable IO(_CPU32_SCCR1init)

	checkbutton $base.checkbuttonWOMS \
		-command IOSave \
		-maskvalue 8192 \
		-onvalue 0x2000 \
		-text WOMS \
		-variable IO(_CPU32_SCCR1init)

	checkbutton $base.checkbuttonLOOPS \
		-command IOSave \
		-maskvalue 16384 \
		-onvalue 0x4000 \
		-text LOOPS \
		-variable IO(_CPU32_SCCR1init)

	label $base.labelSCIBaudrate \
		-text {SCI Baud rate: }

	label $base.labelClock \
		-textvariable code::Configure(System,clock) \
		-width 8

	label $base.label#13 \
		-text {/ (32 * }

	entry $base.entrySCCR0 \
		-width 6

	label $base.label#14 \
		-text {) =}

	label $base.labelBAUD \
		-justify left \
		-width 6


	# Geometry management

	grid $base.frame#2 -in $root	-row 1 -column 1 
	grid $base.frame#3 -in $base.frame#2	-row 2 -column 1  \
		-sticky w
	grid $base.frame#7 -in $base.frame#2	-row 3 -column 1  \
		-sticky w
	grid $base.labelConfigurationValues -in $base.frame#2	-row 1 -column 1 
	grid $base.checkbuttonSBK -in $base.frame#3	-row 1 -column 1  \
		-sticky w
	grid $base.checkbuttonRWU -in $base.frame#3	-row 1 -column 2  \
		-sticky w
	grid $base.checkbuttonRE -in $base.frame#3	-row 1 -column 3  \
		-sticky w
	grid $base.checkbuttonTE -in $base.frame#3	-row 1 -column 4  \
		-sticky w
	grid $base.checkbuttonILIE -in $base.frame#3	-row 2 -column 1  \
		-sticky w
	grid $base.checkbuttonRIE -in $base.frame#3	-row 2 -column 2  \
		-sticky w
	grid $base.checkbuttonTCIE -in $base.frame#3	-row 2 -column 3  \
		-sticky w
	grid $base.checkbuttonTIE -in $base.frame#3	-row 2 -column 4  \
		-sticky w
	grid $base.checkbuttonWAKE -in $base.frame#3	-row 3 -column 1  \
		-sticky w
	grid $base.checkbuttonM -in $base.frame#3	-row 3 -column 2  \
		-sticky w
	grid $base.checkbuttonPE -in $base.frame#3	-row 3 -column 3  \
		-sticky w
	grid $base.checkbuttonPT -in $base.frame#3	-row 3 -column 4  \
		-sticky w
	grid $base.checkbuttonILT -in $base.frame#3	-row 4 -column 1  \
		-sticky w
	grid $base.checkbuttonWOMS -in $base.frame#3	-row 4 -column 2  \
		-sticky w
	grid $base.checkbuttonLOOPS -in $base.frame#3	-row 4 -column 3  \
		-sticky w
	grid $base.labelSCIBaudrate -in $base.frame#7	-row 1 -column 1 
	grid $base.labelClock -in $base.frame#7	-row 1 -column 2 
	grid $base.label#13 -in $base.frame#7	-row 1 -column 3 
	grid $base.entrySCCR0 -in $base.frame#7	-row 1 -column 4 
	grid $base.label#14 -in $base.frame#7	-row 1 -column 5 
	grid $base.labelBAUD -in $base.frame#7	-row 1 -column 6  \
		-sticky w

	# Resize behavior management

	grid rowconfigure $base.frame#2 1 -weight 0 -minsize 2
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 1 -weight 0 -minsize 53

	grid rowconfigure $base.frame#3 1 -weight 0 -minsize 4
	grid rowconfigure $base.frame#3 2 -weight 0 -minsize 2
	grid rowconfigure $base.frame#3 3 -weight 0 -minsize 6
	grid rowconfigure $base.frame#3 4 -weight 0 -minsize 2
	grid columnconfigure $base.frame#3 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 4 -weight 0 -minsize 30

	grid rowconfigure $base.frame#7 1 -weight 0 -minsize 2
	grid columnconfigure $base.frame#7 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 5 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 6 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 1 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
 
    proc Save {} {}
    return
}

set w [lindex $args 0]

set title [lindex $args 1]
set SCCR0NAME [lindex $args 2]
set SCCR1NAME [lindex $args 3]

code::help $w $base.labelConfigurationValues "Configure the SCI"
code::help $w $base.labelSCIBaudrate "The initial SCI baud rate"
code::help $w $base.labelClock "The system clock speed"
code::help $w $base.entrySCCR0 "Change the initial SCI SCCR0 register"
bind $base.entrySCCR0 <FocusOut> "SCISave $SCCR0NAME $SCCR1NAME"
bind $base.entrySCCR0 <Return> "SCISave $SCCR0NAME $SCCR1NAME"
code::help $w $base.labelBAUD "The baud rate at this system clock speed"
$base.labelBAUD config -textvariable SCI(BAUD$SCCR0NAME)
$base.entrySCCR0 config -textvariable code::Configure(Registers,$SCCR0NAME)
foreach "name help" {
    LOOPS {Test SCI operation, looping, feedback path enabled}
    WOMS {Set TXD to open drain output}
    ILT {Long idle-line detect}
    PT {Odd parity}
    PE {Enable parity}
    M {Frame length: Off - 10 bit, On - 11 bit}
    WAKE {Receiver wakeup: Off - idle-line, On - address mark}
    TIE {Enable transmit data reggister empty interrupt}
    TCIE {Enable transmit complete interrupt}
    RIE {Enable receiver interrupts}
    ILIE {Enable idle-line interrupt}
    TE {Enable the transmitter}
    RE {Enable the receiver}
    RWU {Enable receiver wakeup mode}
    SBK {Send break}} {
    $base.checkbutton$name config \
        -variable code::Configure(Registers,$SCCR1NAME) \
        -command "SCISave $SCCR0NAME $SCCR1NAME"
    code::help $w $base.checkbutton$name $help
}

proc ::SCISave {SCCR0NAME SCCR1NAME} {
    global code::Configure SCI

    set Configure(Registers,$SCCR0NAME) [expr $Configure(Registers,$SCCR0NAME) \
        & 0x1FFF]
    set SCI(BAUD$SCCR0NAME) [expr $code::Configure(System,clock) / \
        ($Configure(Registers,$SCCR0NAME) * 32)]

    foreach name "$SCCR0NAME $SCCR1NAME" {
        code::DdfSetRegister $name code::Configure(Registers,$name)
    }
}

trace variable code::Configure(System,clock) w "SCISave $SCCR0NAME $SCCR1NAME;#"
SCISave $SCCR0NAME $SCCR1NAME
return $title




















# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	SCI_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing SCI_ui"
	    SCI_ui .
	}
    }
}
