#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/SIM.ui
#   root     is the parent window for this user interface

proc SIM_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#8 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#1 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#2

	frame $base.frame#3

	frame $base.frame#7

	frame $base.frame#10

	frame $base.frame#4

	frame $base.frame#11

	frame $base.frame#12

	frame $base.frame#13

	frame $base.frame#14

	frame $base.frameIARB

	label $base.labelOption \
		-text {SIM Module Configuration}

	label $base.label#7 \
		-text {Clock Synthesizer}

	label $base.labelIARB \
		-text {Interrupt arbitration:}

	label $base.labelCrystal \
		-text {Crystal (HZ):}

	entry $base.entryCrystal \
		-textvariable code::Configure(System,crystal) \
		-width 0

	label $base.labelY \
		-text {Frequency Control:}

	entry $base.entryY \
		-textvariable SIM(Y) \
		-width 5

	checkbutton $base.checkbuttonEXOFF \
		-command SIMSave \
		-maskvalue 32768 \
		-offvalue 0x8000 \
		-onvalue 0 \
		-text EXOFF \
		-variable SIM(SIMMCRinit)

	checkbutton $base.checkbuttonMM \
		-command SIMSave \
		-maskvalue 64 \
		-onvalue 0x0040 \
		-text MM \
		-variable SIM(SIMMCRinit)

	checkbutton $base.checkbuttonSUPV \
		-command SIMSave \
		-maskvalue 128 \
		-onvalue 0x0080 \
		-text SUPV \
		-variable SIM(SIMMCRinit)

	checkbutton $base.checkbuttonSLVEN \
		-command SIMSave \
		-maskvalue 2048 \
		-onvalue 0x0800 \
		-text SLVEN \
		-variable SIM(SIMMCRinit)

	checkbutton $base.checkbuttonFRZBM \
		-command SIMSave \
		-maskvalue 8192 \
		-offvalue 0x2000 \
		-onvalue 0 \
		-text FRZBM \
		-variable SIM(SIMMCRinit)

	checkbutton $base.checkbuttonFRZSW \
		-command SIMSave \
		-maskvalue 16384 \
		-offvalue 0x4000 \
		-onvalue 0 \
		-text FRZSW \
		-variable SIM(SIMMCRinit)

	checkbutton $base.checkbuttonW \
		-command SIMSave \
		-maskvalue 32768 \
		-onvalue 0x8000 \
		-text {VCO * 4} \
		-variable SIM(SYNCRinit)

	label $base.labelSHEN \
		-text {Show cycle enable}

	checkbutton $base.checkbuttonX \
		-command SIMSave \
		-maskvalue 16384 \
		-onvalue 0x4000 \
		-text {System clock * 2} \
		-variable SIM(SYNCRinit)

	radiobutton $base.radiobuttonSHEN00 \
		-command SIMSave \
		-maskvalue 768 \
		-text {Cycles off, Arbitration on} \
		-value 0x0000 \
		-variable SIM(SIMMCRinit)

	label $base.labelClock \
		-text {Clock (HZ):}

	label $base.labelClockValue \
		-textvariable code::Configure(System,clock)

	radiobutton $base.radiobuttonSHEN01 \
		-command SIMSave \
		-maskvalue 768 \
		-text {Cycles on, Arbitration off} \
		-value 0x0100 \
		-variable SIM(SIMMCRinit)

	radiobutton $base.radiobuttonSHEN10 \
		-command SIMSave \
		-maskvalue 768 \
		-text {Cycles on, Arbitration on} \
		-value 0x0200 \
		-variable SIM(SIMMCRinit)

	checkbutton $base.checkbuttonEDIV \
		-command SIMSave \
		-maskvalue 128 \
		-onvalue 0x0080 \
		-text EDIV \
		-variable SIM(SYNCRinit)

	checkbutton $base.checkbuttonRSTEN \
		-command SIMSave \
		-maskvalue 4 \
		-onvalue 0x0004 \
		-text RSTEN \
		-variable SIM(SYNCRinit)

	radiobutton $base.radiobuttonSHEN11 \
		-command SIMSave \
		-maskvalue 768 \
		-text {Cycles on, Arbitration on, Halt} \
		-value 0x0300 \
		-variable SIM(SIMMCRinit)

	checkbutton $base.checkbuttonSTSIM \
		-command SIMSave \
		-maskvalue 2 \
		-onvalue 0x0002 \
		-text STSIM \
		-variable SIM(SYNCRinit)

	checkbutton $base.checkbuttonSTEXT \
		-command SIMSave \
		-maskvalue 1 \
		-onvalue 0x0001 \
		-text STEXT \
		-variable SIM(SYNCRinit)


	# Geometry management

	grid $base.frame#8 -in $root	-row 1 -column 2  \
		-sticky n
	grid $base.frame#1 -in $root	-row 1 -column 1  \
		-sticky n
	grid $base.frame#2 -in $base.frame#1	-row 3 -column 1 
	grid $base.frame#3 -in $base.frame#1	-row 4 -column 1 
	grid $base.frame#7 -in $base.frame#1	-row 2 -column 1 
	grid $base.frame#10 -in $base.frame#8	-row 2 -column 1 
	grid $base.frame#4 -in $base.frame#3	-row 2 -column 1 
	grid $base.frame#11 -in $base.frame#10	-row 1 -column 1  \
		-sticky ew
	grid $base.frame#12 -in $base.frame#10	-row 2 -column 1  \
		-sticky ew
	grid $base.frame#13 -in $base.frame#10	-row 5 -column 1  \
		-sticky ew
	grid $base.frame#14 -in $base.frame#10	-row 6 -column 1 
	grid $base.frameIARB -in $base.frame#7	-row 1 -column 2 
	grid $base.labelOption -in $base.frame#1	-row 1 -column 1 
	grid $base.label#7 -in $base.frame#8	-row 1 -column 1 
	grid $base.labelIARB -in $base.frame#7	-row 1 -column 1 
	grid $base.labelCrystal -in $base.frame#11	-row 1 -column 1 
	grid $base.entryCrystal -in $base.frame#11	-row 1 -column 2  \
		-sticky ew
	grid $base.labelY -in $base.frame#12	-row 1 -column 1 
	grid $base.entryY -in $base.frame#12	-row 1 -column 2  \
		-sticky ew
	grid $base.checkbuttonEXOFF -in $base.frame#2	-row 1 -column 1  \
		-sticky w
	grid $base.checkbuttonMM -in $base.frame#2	-row 1 -column 2  \
		-sticky w
	grid $base.checkbuttonSUPV -in $base.frame#2	-row 1 -column 3  \
		-sticky w
	grid $base.checkbuttonSLVEN -in $base.frame#2	-row 2 -column 1  \
		-sticky w
	grid $base.checkbuttonFRZBM -in $base.frame#2	-row 2 -column 2  \
		-sticky w
	grid $base.checkbuttonFRZSW -in $base.frame#2	-row 2 -column 3  \
		-sticky w
	grid $base.checkbuttonW -in $base.frame#10	-row 3 -column 1  \
		-sticky w
	grid $base.labelSHEN -in $base.frame#3	-row 1 -column 1 
	grid $base.checkbuttonX -in $base.frame#10	-row 4 -column 1  \
		-sticky w
	grid $base.radiobuttonSHEN00 -in $base.frame#4	-row 1 -column 1  \
		-sticky w
	grid $base.labelClock -in $base.frame#13	-row 1 -column 1  \
		-sticky e
	grid $base.labelClockValue -in $base.frame#13	-row 1 -column 2 
	grid $base.radiobuttonSHEN01 -in $base.frame#4	-row 2 -column 1  \
		-sticky w
	grid $base.radiobuttonSHEN10 -in $base.frame#4	-row 3 -column 1  \
		-sticky w
	grid $base.checkbuttonEDIV -in $base.frame#14	-row 1 -column 1  \
		-sticky w
	grid $base.checkbuttonRSTEN -in $base.frame#14	-row 1 -column 2  \
		-sticky w
	grid $base.radiobuttonSHEN11 -in $base.frame#4	-row 4 -column 1  \
		-sticky w
	grid $base.checkbuttonSTSIM -in $base.frame#14	-row 2 -column 1  \
		-sticky w
	grid $base.checkbuttonSTEXT -in $base.frame#14	-row 2 -column 2  \
		-sticky w

	# Resize behavior management

	grid rowconfigure $base.frame#2 1 -weight 0 -minsize 13
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 9
	grid columnconfigure $base.frame#2 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 3 -weight 0 -minsize 30

	grid rowconfigure $base.frame#3 1 -weight 0 -minsize 9
	grid rowconfigure $base.frame#3 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#4 1 -weight 0 -minsize 2
	grid rowconfigure $base.frame#4 2 -weight 0 -minsize 2
	grid rowconfigure $base.frame#4 3 -weight 0 -minsize 2
	grid rowconfigure $base.frame#4 4 -weight 0 -minsize 2
	grid columnconfigure $base.frame#4 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#7 1 -weight 0 -minsize 16
	grid columnconfigure $base.frame#7 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#8 1 -weight 0 -minsize 16
	grid rowconfigure $base.frame#8 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#8 1 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 1 -minsize 30

	grid rowconfigure $base.frame#10 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#10 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#10 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#10 4 -weight 0 -minsize 30
	grid rowconfigure $base.frame#10 5 -weight 0 -minsize 30
	grid rowconfigure $base.frame#10 6 -weight 0 -minsize 30
	grid columnconfigure $base.frame#10 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#11 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#11 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#11 2 -weight 1 -minsize 30

	grid rowconfigure $base.frame#12 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#12 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#12 2 -weight 1 -minsize 30

	grid rowconfigure $base.frame#13 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#13 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#13 2 -weight 1 -minsize 30

	grid rowconfigure $base.frame#14 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#14 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#14 1 -weight 1 -minsize 30
	grid columnconfigure $base.frame#14 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 10
	grid rowconfigure $base.frame#1 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
 
    proc SIMSave {} {}
    return
}

global SIM
global code::Configure

set w [lindex $args 0]
set title [lindex $args 1]
set SIM(NAME) "Set up the [lindex $title 1]"
set SIM(SIMMCRNAME) [lindex $args 2]
set SIM(SYNCRNAME) [lindex $args 3]

foreach name "$SIM(SIMMCRNAME) $SIM(SYNCRNAME)" {
    set SIM($name) $Configure(Registers,$name)
    if {$SIM($name) == {}} {
        set SIM($name) 0
    }
}
set SIM(SIMMCRinit) $SIM($SIM(SIMMCRNAME))
set o $SIM(SIMMCRinit)
set SIM(IARB) [expr $o & 0x000F]
set SIM(SYNCRinit) $SIM($SIM(SYNCRNAME))
set o $SIM(SYNCRinit)
set SIM(Y) [expr ($o & 0x3F00) >> 8]

proc ::SIMSave {args} {
    global SIM
    global code::Configure

    if {$code::Configure(System,crystal) != [code::Preference System crystal]} {
        if {   $code::Configure(System,crystal) == {} \
            || [catch {expr int($code::Configure(System,crystal))}]} {
            set code::Configure(System,crystal) [code::Preference System crystal]
        } else {
            code::Preference System crystal $code::Configure(System,crystal)
        }
    }

    set SIM(SIMMCRinit) [format "0x%04X" \
        [expr ($SIM(SIMMCRinit) & ~0x0F)| $SIM(IARB)]]
    set SIM($SIM(SIMMCRNAME)) $SIM(SIMMCRinit)

    set SIM(SYNCRinit) [format "0x%04X" \
        [expr ($SIM(SYNCRinit) & ~0x3F00) \
            |(($SIM(Y) & 0x3F)<<8)]]
    set SIM($SIM(SYNCRNAME)) $SIM(SYNCRinit)

    foreach name "$SIM(SIMMCRNAME) $SIM(SYNCRNAME)" {
        if {$SIM($name) != 0 || $Configure(Registers,$name) != {}} {
            code::DdfSetRegister $name SIM($name)
            set Configure(Registers,$name) $SIM($name)
        }
    }

    set X [expr ($SIM(SYNCRinit) & 0x4000) != 0]
    set W [expr ($SIM(SYNCRinit) & 0x8000) != 0]
    set Y [expr ($SIM(SYNCRinit) & 0x3F00) >> 8]
    set clock [expr $code::Configure(System,crystal) * 4 * \
        (($Y + 1) << ((2 * $W) + $X))]
    if {$clock != [code::Preference System clock]} {
        code::Preference System clock $clock
    }
    # possibly changed crystal value
    catch CREXSave
}

set w [lindex $args 0]

combobox $base.frameIARB.combo \
    -maxheight 0 \
    -width 3 \
    -textvariable SIM(IARB) \
    -editable false \
    -command SIMSave

code::help $w $base.frameIARB.combo "Integration module interrupt arbitration priority"
code::help $w $base.labelIARB "Integration module interrupt arbitration priority"
grid $base.frameIARB.combo -in $base.frameIARB
foreach number {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15} {
    $base.frameIARB.combo list insert end $number
}

code::help $w $base.checkbuttonMM "Module mapping - Off: 0x7FF000, On: 0xFFF000"
code::help $w $base.checkbuttonSUPV "Put integration module in supervisor data space"
code::help $w $base.checkbuttonSLVEN "Allow external master access to the IMB"
code::help $w $base.checkbuttonFRZBM "Enable bus monitor when FREEZE asserted"
code::help $w $base.checkbuttonFRZSW "Enable watchdog and periodic counters when FREEZE asserted"
code::help $w $base.checkbuttonEXOFF "Enable the CLKOUT pin"
code::help $w $base.radiobuttonSHEN00 "Show cycles disabled, external arbitration enabled"
code::help $w $base.radiobuttonSHEN01 "Show cycles enabled, external arbitration disabled"
code::help $w $base.radiobuttonSHEN10 "Show cycles enabled, external arbitration enabled"
code::help $w $base.radiobuttonSHEN11 "Show cycles enabled, external arbitration enabled, bus grant halt"

code::help $w $base.checkbuttonSTEXT "CLKOUT driven during low-power stop"
code::help $w $base.checkbuttonSTSIM "Integration module clock driven by VCO during low-power stop"
code::help $w $base.checkbuttonRSTEN "Loss of reference causes system reset"
code::help $w $base.checkbuttonEDIV "On: ECLK = system clock / 16, Off: / 8"
code::help $w $base.labelY "Frequency control down counter initial value"
code::help $w $base.entryY "Frequency control down counter initial value"
bind $base.entryY <FocusOut> "SIMSave"
bind $base.entryY <Return> "SIMSave"
code::help $w $base.checkbuttonX "Multiply system clock by two"
code::help $w $base.checkbuttonW "Multiply VCO frequency by four"

code::help $w $base.labelClock "The system clock speed"
code::help $w $base.labelClockValue "The system clock speed"
code::help $w $base.labelCrystal "The system crystal speed"
code::help $w $base.entryCrystal "The system crystal speed"
bind $base.entryCrystal <FocusOut> "SIMSave"
bind $base.entryCrystal <Return> "SIMSave"

SIMSave
return $title
























# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	SIM_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing SIM_ui"
	    SIM_ui .
	}
    }
}
