#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/SIM2.ui
#   root     is the parent window for this user interface

proc SIM2_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#8

	frame $base.frame#11frame#11 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#1 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#3

	frame $base.frame#7

	frame $base.frame#12frame#12

	frame $base.frame#13frame#13

	frame $base.framePIRQL

	label $base.labelProtection \
		-text {System protection control}

	checkbutton $base.checkbuttonBME \
		-command SIM2Save \
		-text {Bus monitor enable} \
		-variable SIM(BME)

	menubutton $base.menubuttonBMT \
		-indicatoron 1 \
		-relief raised \
		-textvariable SIM(BMTname) \
		-width 5

	checkbutton $base.checkbuttonHME \
		-command SIM2Save \
		-text {Halt monitor enable} \
		-variable SIM(HME)

	checkbutton $base.checkbuttonSWE \
		-command SIM2Save \
		-text {Software watchdog enable} \
		-variable SIM(SWE)

	menubutton $base.menubuttonSWT \
		-indicatoron 1 \
		-relief raised \
		-textvariable SIM(SWTname)

	button $base.buttonChipSelects \
		-command code::ConfigureEditChipSelects \
		-text {Chip Selects}

	label $base.labelPIC \
		-text {Periodic Interrupt Timer}

	label $base.labelPITM \
		-text {PIT Period: ((}

	entry $base.entryPITM \
		-justify right \
		-textvariable SIM(PITM) \
		-width 5

	checkbutton $base.checkbuttonPTP \
		-command SIM2Save \
		-text {* 512) * 4) / } \
		-variable SIM(PTP)

	label $base.labelCrystal \
		-textvariable code::Configure(System,crystal) \
		-width 6

	label $base.labelequal \
		-text =

	label $base.labelPIT \
		-textvariable SIM(PIT) \
		-width 11

	label $base.labelPIRQL \
		-text {Interrupt Request level:}

	label $base.labelPIV \
		-text {Interrupt vector:}

	entry $base.entryPIV \
		-textvariable SIM(PIV) \
		-width 5


	# Geometry management

	grid $base.frame#8 -in $root	-row 2 -column 1  \
		-sticky w
	grid $base.frame#11frame#11 -in $root	-row 3 -column 1  \
		-sticky w
	grid $base.frame#1 -in $root	-row 1 -column 1 
	grid $base.frame#3 -in $base.frame#1	-row 4 -column 1 
	grid $base.frame#7 -in $base.frame#1	-row 2 -column 1  \
		-sticky w
	grid $base.frame#12frame#12 -in $base.frame#11frame#11	-row 2 -column 1  \
		-sticky w
	grid $base.frame#13frame#13 -in $base.frame#11frame#11	-row 3 -column 1 
	grid $base.framePIRQL -in $base.frame#13frame#13	-row 1 -column 2  \
		-sticky w
	grid $base.labelProtection -in $base.frame#1	-row 1 -column 1 
	grid $base.checkbuttonBME -in $base.frame#7	-row 1 -column 1 
	grid $base.menubuttonBMT -in $base.frame#7	-row 1 -column 2 
	grid $base.checkbuttonHME -in $base.frame#1	-row 3 -column 1  \
		-sticky w
	grid $base.checkbuttonSWE -in $base.frame#3	-row 1 -column 1 
	grid $base.menubuttonSWT -in $base.frame#3	-row 1 -column 2 
	grid $base.buttonChipSelects -in $base.frame#8	-row 1 -column 1 
	grid $base.labelPIC -in $base.frame#11frame#11	-row 1 -column 1 
	grid $base.labelPITM -in $base.frame#12frame#12	-row 1 -column 1 
	grid $base.entryPITM -in $base.frame#12frame#12	-row 1 -column 2 
	grid $base.checkbuttonPTP -in $base.frame#12frame#12	-row 1 -column 3 
	grid $base.labelCrystal -in $base.frame#12frame#12	-row 1 -column 4 
	grid $base.labelequal -in $base.frame#12frame#12	-row 1 -column 5 
	grid $base.labelPIT -in $base.frame#12frame#12	-row 1 -column 6  \
		-sticky ew
	grid $base.labelPIRQL -in $base.frame#13frame#13	-row 1 -column 1  \
		-sticky e
	grid $base.labelPIV -in $base.frame#13frame#13	-row 2 -column 1  \
		-sticky e
	grid $base.entryPIV -in $base.frame#13frame#13	-row 2 -column 2  \
		-sticky w

	# Resize behavior management

	grid rowconfigure $base.frame#11frame#11 1 -weight 0 -minsize 2
	grid rowconfigure $base.frame#11frame#11 2 -weight 0 -minsize 2
	grid rowconfigure $base.frame#11frame#11 3 -weight 0 -minsize 12
	grid columnconfigure $base.frame#11frame#11 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#3 1 -weight 0 -minsize 2
	grid columnconfigure $base.frame#3 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#7 1 -weight 0 -minsize 6
	grid columnconfigure $base.frame#7 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#12frame#12 1 -weight 0 -minsize 2
	grid columnconfigure $base.frame#12frame#12 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#12frame#12 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#12frame#12 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#12frame#12 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#12frame#12 5 -weight 0 -minsize 15
	grid columnconfigure $base.frame#12frame#12 6 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 0 -minsize 4
	grid rowconfigure $root 3 -weight 0 -minsize 30
	grid rowconfigure $root 4 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 1 -minsize 30

	grid rowconfigure $base.frame#13frame#13 1 -weight 0 -minsize 2
	grid rowconfigure $base.frame#13frame#13 2 -weight 0 -minsize 2
	grid columnconfigure $base.frame#13frame#13 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#13frame#13 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#8 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#8 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 5
	grid rowconfigure $base.frame#1 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 2
	grid rowconfigure $base.frame#1 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
 
    proc Save {} {}
    return
}

global SIM
global code::Configure

set w [lindex $args 0]
set title [lindex $args 1]
set SIM(NAME) "Set up the [lindex $title 1]"

foreach name "SYPCR PICR PITR" {
    set SIM($name) $Configure(Registers,$name)
    if {$SIM($name) == {}} {
        set SIM($name) 0
    }
}

set SIM(SYPCRinit) $SIM(SYPCR)
set o $SIM(SYPCRinit)
set SIM(BMT) [expr $o & 0x0003]
code::help $w $base.menubuttonBMT "Bus monitor timeout period"
set m [menu $base.menubuttonBMT.menu -tearoff 0]
set value 0
foreach number {"64 clocks" "32 clocks" "16 clocks" "8 clocks"} {
    $m add radiobutton -label $number\
        -variable SIM(BMT) \
        -command "set SIM(BMTname) \"$number\"; SIM2Save" \
        -value $value
    if {$SIM(BMT) == $value} {
        set SIM(BMTname) $number
    }
    incr value
}
$base.menubuttonBMT config -menu $m -direction flush -width 11 \
    -textvariable SIM(BMTname)
set SIM(BME) [expr $o & 0x0004 ? 1 : 0]
code::help $w $base.checkbuttonBME "Enable bus monitor for an internal to external bus cycle"
set SIM(HME) [expr $o & 0x0008 ? 1 : 0]
code::help $w $base.checkbuttonHME "Enable halt monitor"
set SIM(SWT) [expr ($o & 0x0070)>> 4]
set m [menu $base.menubuttonSWT.menu -tearoff 0]
set value 0
foreach number {"2^9 / Crystal frequency" \
  "2^11 / Crystal frequenct" "2^13 / Crystal frequency" \
  "2^15 / Crystal frequency" "2^18 / Crystal frequency" \
  "2^20 / Crystal frequency" "2^22 / Crystal frequency" \
  "2^24 / Crystal frequency" } {
    $m add radiobutton -label $number\
        -variable SIM(SWT) \
        -command "set SIM(SWTname) \"$number\"; SIM2Save" \
        -value $value
    if {$SIM(SWT) == $value} {
        set SIM(SWTname) $number
    }
    incr value
}
$base.menubuttonSWT config -menu $m -direction flush -width 24

code::help $w $base.menubuttonSWT "Software watchdog timeout period"
set SIM(SWE) [expr $o & 0x0080 ? 1 : 0]
code::help $w $base.checkbuttonSWE "Enable software watchdog timer"
code::help $w $base.buttonChipSelects "Edit the chip select registers"

set SIM(PIRQL) [expr ($SIM(PICR) & 0x0700) >>8]
set SIM(PIV) [expr $SIM(PICR) & 0x00FF]
set SIM(PTP) [expr ($SIM(PITR) & 0x0100) != 0]
set SIM(PITM) [expr $SIM(PITR) & 0x00FF]
code::help $w $base.labelPIT "Configure the Periodic Interrupt Timer"
code::help $w $base.labelPITM "Configure the Periodic Interrupt Timer"
code::help $w $base.entryPITM "The PIT modulus"
bind $base.entryPITM <FocusOut> SIM2Save
bind $base.entryPITM <Return> SIM2Save
code::help $w $base.checkbuttonPTP "Enable/Disable the prescaler"
code::help $w $base.labelPIRQL "The PIT interrupt request level"
code::help $w $base.labelPIV "The PIT interrupt vector"
code::help $w $base.entryPIV "The PIT interrupt vector"
bind $base.entryPIV <FocusOut> SIM2Save
bind $base.entryPIV <Return> SIM2Save

proc ::SIM2Save {} {
    global SIM
    global code::Configure

    set SIM(SYPCRinit) [format "0x%04X" \
        [expr ($SIM(SWE)<<7)| \
        ($SIM(SWT)<<4)|($SIM(HME)<<3)| \
        ($SIM(BME)<<2)|$SIM(BMT)]]
    set SIM(SYPCR) $SIM(SYPCRinit)

    set SIM(PITM) [expr $SIM(PITM) & 0x00FF]
    set pre 1
    if {$SIM(PTP)} {
        set pre 512
    }
    set pit [expr ($SIM(PITM) * $pre * 4) / $code::Configure(System,crystal).0]
    set units sec
    if {$pit != 0} {
        while {int($pit) == 0} {
            set pit [expr $pit * 1000]
            if {$units == "sec"} {
                set units ms
            } elseif {$units == "ms"} {
                set units us
            }
        }
    }
        
    set SIM(PIT) [format "%4.5f $units" $pit]
    set SIM(PIV) [expr $SIM(PIV) & 0x00FF]
    set SIM(PICR) [expr ($SIM(PIRQL) << 8) | $SIM(PIV)]
    set SIM(PITR) $SIM(PITM)
    if {$SIM(PTP)} {
        set SIM(PITR) [expr $SIM(PITR) | 0x0100]
    }

    foreach name "SYPCR PICR PITR" {
        if {$SIM($name) != 0 || $Configure(Registers,$name) != {}} {
            code::DdfSetRegister $name SIM($name)
            set Configure(Registers,$name) $SIM($name)
        }
    }
}

combobox $base.framePIRQL.combo \
    -maxheight 0 \
    -width 3 \
    -textvariable SIM(PIRQL) \
    -editable false \
    -command "SIM2Save ;#"

grid $base.framePIRQL.combo -in $base.framePIRQL
foreach number {0 1 2 3 4 5 6 7} {
    $base.framePIRQL.combo list insert end $number
}
code::help $w $base.framePIRQL.combo "The PIT interrupt request level"

return $title






# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	SIM2_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing SIM2_ui"
	    SIM2_ui .
	}
    }
}
