#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Search/Goto.ui
#   root     is the parent window for this user interface

proc Goto_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#2

	frame $base.frame#1

	frame $base.frame#3

	frame $base.frame#4

	frame $base.frame#6

	frame $base.frameGoto

	frame $base.frameWhat

	button $base.buttonGoto \
		-command code::SearchGoto \
		-text Goto \
		-width 10

	label $base.labelGoto \
		-anchor e \
		-text Goto: \
		-width 12

	label $base.labelGotowhat \
		-text {Goto what:}


	# Geometry management

	grid $base.frame#2 -in $root	-row 1 -column 1 
	grid $base.frame#1 -in $root	-row 1 -column 2  \
		-sticky n
	grid $base.frame#3 -in $base.frame#2	-row 2 -column 1 
	grid $base.frame#4 -in $base.frame#2	-row 1 -column 1  \
		-sticky ew
	grid $base.frame#6 -in $base.frame#3	-row 1 -column 1  \
		-sticky n
	grid $base.frameGoto -in $base.frame#4	-row 1 -column 2  \
		-sticky w
	grid $base.frameWhat -in $base.frame#6	-row 1 -column 2  \
		-sticky w
	grid $base.buttonGoto -in $base.frame#1	-row 1 -column 1 
	grid $base.labelGoto -in $base.frame#4	-row 1 -column 1  \
		-sticky e
	grid $base.labelGotowhat -in $base.frame#6	-row 1 -column 1  \
		-sticky e

	# Resize behavior management

	grid rowconfigure $base.frame#6 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#2 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#3 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#4 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#4 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 2 -weight 1 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 1 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
    return
}

# get the containing window
set w [lindex $args 0]
global code::Search

code::help $w $base.labelGoto "The goto target"
code::help $w $base.labelGotowhat "The type of place to go to"
code::help $w $base.buttonGoto "Go to the target"

combobox $base.frameWhat.combo \
    -maxheight 0 \
    -width 5 \
    -textvariable code::Search(gotowhat) \
    -editable false

grid $base.frameWhat.combo -in $base.frameWhat
code::help $w $base.frameWhat.combo "Select a goto target type"

foreach dir {Line Mark} {
    $base.frameWhat.combo list insert end $dir
}

if {$code::Search(gotowhat) == "Line"} {
    set state disabled
} else {
    set state normal
}

set Search(whatcombo) $base.frameWhat.combo

combobox $base.frameGoto.combo \
    -maxheight 0 \
    -width 27 \
    -textvariable code::Search(goto) \
    -editable true \
    -state $state \
    -command code::SearchGoto

grid $base.frameGoto.combo -in $base.frameGoto
set code::Search(gotocombo) $base.frameGoto.combo
$base.frameWhat.combo configure -command code::SearchWhat

code::help $w $base.frameGoto.combo "Enter a line number or 'end' for the end of the file"
return "Go to a place in the text"


























# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Goto_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Goto_ui"
	    Goto_ui .
	}
    }
}
