#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Search/Replace.ui
#   root     is the parent window for this user interface

proc Replace_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#2

	frame $base.frame#1

	frame $base.frame#3

	frame $base.frame#4

	frame $base.frame#5 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#6

	frame $base.frameFind

	frame $base.frameReplace

	frame $base.frameDirection

	button $base.buttonFindNext \
		-command "code::SearchNext $base.frameFind.combo" \
		-text {Find Next} \
		-width 10

	label $base.labelFind \
		-anchor e \
		-text {Find what:} \
		-width 12

	button $base.buttonReplace \
		-command code::SearchReplace \
		-text Replace \
		-width 10

	label $base.labelReplace \
		-anchor e \
		-text {Replace with:} \
		-width 12

	button $base.buttonReplaceAll \
		-command code::SearchReplaceAll \
		-text ReplaceAll \
		-width 10

	label $base.labelSearch \
		-text Search:

	checkbutton $base.checkbuttonMatchCase \
		-command {set code::Search(matchpattern) 0} \
		-text {Match Case} \
		-variable code::Search(matchcase)

	checkbutton $base.checkbuttonMatchPattern \
		-command {set code::Search(matchcase) 0} \
		-text {Match Pattern} \
		-variable code::Search(matchpattern)


	# Geometry management

	grid $base.frame#2 -in $root	-row 1 -column 1 
	grid $base.frame#1 -in $root	-row 1 -column 2  \
		-sticky n
	grid $base.frame#3 -in $base.frame#2	-row 2 -column 1 
	grid $base.frame#4 -in $base.frame#2	-row 1 -column 1  \
		-sticky ew
	grid $base.frame#5 -in $base.frame#3	-row 1 -column 3 
	grid $base.frame#6 -in $base.frame#3	-row 1 -column 1  \
		-sticky n
	grid $base.frameFind -in $base.frame#4	-row 1 -column 2  \
		-sticky w
	grid $base.frameReplace -in $base.frame#4	-row 2 -column 2  \
		-sticky w
	grid $base.frameDirection -in $base.frame#6	-row 1 -column 2  \
		-sticky w
	grid $base.buttonFindNext -in $base.frame#1	-row 1 -column 1 
	grid $base.labelFind -in $base.frame#4	-row 1 -column 1  \
		-sticky e
	grid $base.buttonReplace -in $base.frame#1	-row 2 -column 1 
	grid $base.labelReplace -in $base.frame#4	-row 2 -column 1 
	grid $base.buttonReplaceAll -in $base.frame#1	-row 3 -column 1 
	grid $base.labelSearch -in $base.frame#6	-row 1 -column 1  \
		-sticky e
	grid $base.checkbuttonMatchCase -in $base.frame#5	-row 1 -column 1  \
		-sticky w
	grid $base.checkbuttonMatchPattern -in $base.frame#5	-row 2 -column 1  \
		-sticky w

	# Resize behavior management

	grid rowconfigure $base.frame#6 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#2 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 1 -weight 1 -minsize 30

	grid rowconfigure $base.frame#3 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 3 -weight 0 -minsize 30

	grid rowconfigure $base.frame#4 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#4 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 2 -weight 1 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 1 -minsize 30

	grid rowconfigure $base.frame#5 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#5 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#1 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
    return
}

# get the containing window
set w [lindex $args 0]
global code::Search

code::help $w $base.labelFind "The string or pattern to find"
code::help $w $base.labelReplace "The string to replace with"
code::help $w $base.labelSearch "The search direction"
code::help $w $base.buttonFindNext "Find the next match"
code::help $w $base.buttonReplace "Replace the current selection"
code::help $w $base.buttonReplaceAll "Replace all occurances of string or pattern"
code::help $w $base.checkbuttonMatchCase "Set to require case matching"
code::help $w $base.checkbuttonMatchPattern "Set to use regular expression matching"

combobox $base.frameDirection.combo \
    -maxheight 0 \
    -width 5 \
    -textvariable code::Search(direction) \
    -editable false
grid $base.frameDirection.combo -in $base.frameDirection
code::help $w $base.frameDirection.combo "Select a search direction"

foreach dir {Down Up All} {
    $base.frameDirection.combo list insert end $dir
}

combobox $base.frameFind.combo \
    -maxheight 0 \
    -width 27 \
    -textvariable code::Search(rpattern) \
    -editable true \
    -command code::SearchNext
grid $base.frameFind.combo -in $base.frameFind
set code::Search(replacefindcombo) $base.frameFind.combo
code::help $w $base.frameFind.combo "Enter or select a string or pattern"
combobox $base.frameReplace.combo \
    -maxheight 0 \
    -width 27 \
    -textvariable code::Search(replace) \
    -editable true \
    -command code::SearchReplace
grid $base.frameReplace.combo -in $base.frameReplace
set code::Search(replacecombo) $base.frameReplace.combo
code::help $w $base.frameReplace.combo "Enter or select a replace string"

return "Replace a string or pattern"


# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Replace_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Replace_ui"
	    Replace_ui .
	}
    }
}
