#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Startup.ui
#   root     is the parent window for this user interface

proc Startup_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#23

	frame $base.frame#2

	frame $base.frame#11 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#7 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#18

	frame $base.frame#22

	frame $base.frame#17

	label $base.labelProgramstartup \
		-text {Program startup}

	checkbutton $base.checkbuttonUsestartupcode \
		-text {Use startup code} \
		-variable code::Configure(System,definestartup)

	checkbutton $base.checkbuttonAddprojectnotes \
		-text {Add project notes} \
		-variable code::Configure(System,notesinstartfile)

	checkbutton $base.checkbuttonchipinit \
		-offvalue {} \
		-onvalue __chipinit \
		-text {Initialize device registers} \
		-variable code::Configure(Module,chipinit)

	checkbutton $base.checkbuttonstackinit \
		-offvalue {} \
		-onvalue __stackinit \
		-text {Initialize stack pointer} \
		-variable code::Configure(Module,stackinit)

	checkbutton $base.checkbuttonbssinit \
		-offvalue {} \
		-onvalue __bssinit \
		-text {Zero out RAM} \
		-variable code::Configure(Module,bssinit)

	checkbutton $base.checkbuttonfbssinit \
		-offvalue {} \
		-onvalue __fbssinit \
		-text {Zero out far RAM} \
		-variable code::Configure(Module,fbssinit)

	checkbutton $base.checkbuttondatainit \
		-offvalue {} \
		-onvalue __datainit \
		-text {Copy initialized data} \
		-variable code::Configure(Module,datainit)

	checkbutton $base.checkbuttonfdatainit \
		-offvalue {} \
		-onvalue __fbssinit \
		-text {Copy far initialized data} \
		-variable code::Configure(Module,fbssinit)

	checkbutton $base.checkbuttoninterruptinit \
		-offvalue {} \
		-onvalue __interruptinit \
		-text {Enable interrupts} \
		-variable code::Configure(Module,interruptinit)

	checkbutton $base.checkbuttonload_k \
		-offvalue {} \
		-onvalue __load_k \
		-text {Initialize K fields} \
		-variable code::Configure(Module,load_k)

	label $base.labelEntry \
		-text Entry:

	entry $base.entryEntry \
		-textvariable code::Configure(System,entry)

	label $base.labelstartfilename \
		-text {Startup file name:}

	entry $base.entrystartfilename \
		-cursor {} \
		-textvariable code::Configure(System,startfilename) \
		-width 40

	label $base.labelOnexit \
		-text {On exit:}

	radiobutton $base.radiobuttonHalt \
		-text Halt \
		-value __exithalt \
		-variable code::Configure(Module,onexit)

	radiobutton $base.radiobuttonReturn \
		-text Return \
		-value __exitreturn \
		-variable code::Configure(Module,onexit)

	label $base.labelClock \
		-text Clock:

	entry $base.entryClock \
		-textvariable code::Configure(System,clock)


	# Geometry management

	grid $base.frame#23 -in $root	-row 3 -column 1  \
		-sticky w
	grid $base.frame#2 -in $root	-row 1 -column 1  \
		-sticky w
	grid $base.frame#11 -in $root	-row 2 -column 1  \
		-sticky w
	grid $base.frame#7 -in $base.frame#2	-row 1 -column 1  \
		-rowspan 5 \
		-sticky w
	grid $base.frame#18 -in $base.frame#11	-row 1 -column 1  \
		-sticky w
	grid $base.frame#22 -in $base.frame#7	-row 8 -column 1  \
		-columnspan 2 \
		-sticky w
	grid $base.frame#17 -in $base.frame#7	-row 7 -column 1  \
		-sticky w
	grid $base.labelProgramstartup -in $base.frame#7	-row 1 -column 1  \
		-columnspan 2
	grid $base.checkbuttonUsestartupcode -in $base.frame#7	-row 2 -column 1  \
		-sticky w
	grid $base.checkbuttonAddprojectnotes -in $base.frame#7	-row 2 -column 2  \
		-sticky w
	grid $base.checkbuttonchipinit -in $base.frame#7	-row 3 -column 1  \
		-sticky w
	grid $base.checkbuttonstackinit -in $base.frame#7	-row 3 -column 2  \
		-sticky w
	grid $base.checkbuttonbssinit -in $base.frame#7	-row 4 -column 1  \
		-sticky w
	grid $base.checkbuttonfbssinit -in $base.frame#7	-row 4 -column 2  \
		-sticky w
	grid $base.checkbuttondatainit -in $base.frame#7	-row 5 -column 1  \
		-sticky w
	grid $base.checkbuttonfdatainit -in $base.frame#7	-row 5 -column 2  \
		-sticky w
	grid $base.checkbuttoninterruptinit -in $base.frame#7	-row 6 -column 1  \
		-sticky w
	grid $base.checkbuttonload_k -in $base.frame#7	-row 6 -column 2  \
		-sticky w
	grid $base.labelEntry -in $base.frame#17	-row 1 -column 1 
	grid $base.entryEntry -in $base.frame#17	-row 1 -column 2 
	grid $base.labelstartfilename -in $base.frame#22	-row 1 -column 1 
	grid $base.entrystartfilename -in $base.frame#22	-row 1 -column 2 
	grid $base.labelOnexit -in $base.frame#18	-row 1 -column 1 
	grid $base.radiobuttonHalt -in $base.frame#18	-row 1 -column 2 
	grid $base.radiobuttonReturn -in $base.frame#18	-row 1 -column 3 
	grid $base.labelClock -in $base.frame#23	-row 1 -column 1 
	grid $base.entryClock -in $base.frame#23	-row 1 -column 2 

	# Resize behavior management

	grid rowconfigure $base.frame#11 1 -weight 0 -minsize 21
	grid columnconfigure $base.frame#11 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#2 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 4 -weight 0 -minsize 30
	grid rowconfigure $base.frame#2 5 -weight 0 -minsize 30
	grid columnconfigure $base.frame#2 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#7 1 -weight 0 -minsize 2
	grid rowconfigure $base.frame#7 2 -weight 0 -minsize 2
	grid rowconfigure $base.frame#7 3 -weight 0 -minsize 2
	grid rowconfigure $base.frame#7 4 -weight 0 -minsize 2
	grid rowconfigure $base.frame#7 5 -weight 0 -minsize 2
	grid rowconfigure $base.frame#7 6 -weight 0 -minsize 2
	grid rowconfigure $base.frame#7 7 -weight 0 -minsize 2
	grid rowconfigure $base.frame#7 8 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#7 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#22 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#22 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#22 2 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 0 -minsize 30
	grid rowconfigure $root 3 -weight 0 -minsize 30
	grid rowconfigure $root 4 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 1 -minsize 30

	grid rowconfigure $base.frame#17 1 -weight 0 -minsize 5
	grid columnconfigure $base.frame#17 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#17 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#23 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#23 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#23 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#18 1 -weight 0 -minsize 6
	grid columnconfigure $base.frame#18 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#18 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#18 3 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
    return
}

# get the containing window
set w [lindex $args 0]
# get list of enabled checkboxes
set enabled [lindex $args 1]
global code::Configure

# set up startup configuration
code::help $w $base.labelProgramstartup \
    {Configure the program startup code}
set code::Configure(System,definestartup) \
    [code::Preference System definestartup]
$base.checkbuttonUsestartupcode config \
    -command "code::Preference System definestartup \$code::Configure(System,definestartup)"
code::help $w $base.checkbuttonUsestartupcode \
    {Use CODE generated program startup code}
set code::Configure(System,notesinstartfile) \
    [code::Preference System notesinstartfile]
$base.checkbuttonAddprojectnotes config \
    -command "code::Preference System notesinstartfile \$code::Configure(System,notesinstartfile)"
code::help $w $base.checkbuttonAddprojectnotes \
    {Add the project notes to the startup code as comments}
set code::Configure(System,startfilename) \
    [code::Preference System startfilename]
bind $base.entrystartfilename <FocusOut> \
    "code::Preference System startfilename \$code::Configure(System,startfilename)"
bind $base.entrystartfilename <Return> \
    "code::Preference System startfilename \$code::Configure(System,startfilename)"
code::help $w $base.entrystartfilename \
    {The name of the CODE generated startup file}
code::help $w $base.labelstartfilename \
    {The name of the CODE generated startup file}

set buttons {
    chipinit {Initialize the system device registers}
    stackinit {Initialize the processor stackpointer}
    bssinit {Zero out the program RAM (.bss) area}
    fbssinit {Zero out the program far RAM (.fbss) area}
    datainit {Copy the initialized writable data to RAM}
    fdatainit {Copy the far initialized writable data to RAM}
    load_k {Initialize the K fields to the near bank}
    interruptinit {Enable interrupts at program start}
}

foreach "variable description" $buttons {
    if {[lsearch $enabled $variable] == -1} {
        set state "disabled"
    } else {
        set state "normal"
    }
    $base.checkbutton$variable config -state $state \
        -command "code::Preference Module $variable \$code::Configure(Module,$variable) 1"
    code::help $w $base.checkbutton$variable $description
}

set code::Configure(System,entry) [code::Preference System entry]
code::help $w $base.labelEntry \
    {The name of the program entry point}
code::help $w $base.entryEntry \
    {The name of the program entry point}
bind $base.entryEntry <FocusOut> "code::PreferenceSetIfChanged System entry \
    \$code::Configure(System,entry)"
bind $base.entryEntry <Return> "code::PreferenceSetIfChanged System entry \
    \$code::Configure(System,entry)"
code::help $w $base.labelOnexit \
    {Program action when finished or _exit called}
code::help $w $base.radiobuttonHalt \
    {Disable interrupts and enter an infinite loop}
code::help $w $base.radiobuttonReturn \
    {Restore stackpointer and return to calling program}
$base.radiobuttonHalt config \
    -command "code::Preference Module onexit \$code::Configure(Module,onexit) 1"
$base.radiobuttonReturn config \
    -command "code::Preference Module onexit \$code::Configure(Module,onexit) 1"

# set up the clock speed entry
set code::Configure(System,clock) [code::Preference System clock]
code::help $w $base.entryClock \
    {The clock speed of the target system}
bind $base.entryClock <FocusOut> "code::PreferenceSetIfChanged System clock \
    \$code::Configure(System,clock)"
bind $base.entryClock <Return> "code::PreferenceSetIfChanged System clock \
    \$code::Configure(System,clock)"
code::help $w $base.labelClock \
    {The clock speed of the target system}

return "Set up the program startup code"

































# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Startup_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Startup_ui"
	    Startup_ui .
	}
    }
}
