#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Tools.ui
#   root     is the parent window for this user interface

proc Tools_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#3 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#4 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#5 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#6 \
		-borderwidth 2 \
		-relief groove

	checkbutton $base.checkbuttonUselinkercommandfile \
		-text {Use external linker command file} \
		-variable code::Configure(Build,ldfile)

	checkbutton $base.checkbuttonUsestartfile \
		-text {Use external startup code} \
		-variable code::Configure(System,startfile)

	checkbutton $base.checkbuttonUsemakefile \
		-text {Use external makefile} \
		-variable code::Configure(Build,makefile)

	entry $base.entryLdfilename \
		-textvariable code::Configure(Build,ldfilename) \
		-width 30

	entry $base.entryStartfilename \
		-textvariable code::Configure(System,startfilename) \
		-width 30

	entry $base.entryMakefilename \
		-cursor {} \
		-textvariable code::Configure(Build,makefilename) \
		-width 30

	canvas $base.canvasTools \
		-height 0 \
		-width 0 \
		-yscrollcommand "$base.scrollbar#2 set"

	scrollbar $base.scrollbar#2 \
		-command "$base.canvasTools yview" \
		-orient v


	# Geometry management

	grid $base.frame#3 -in $root	-row 1 -column 1  \
		-sticky n
	grid $base.frame#4 -in $root	-row 2 -column 1  \
		-columnspan 4 \
		-sticky nesw
	grid $base.frame#5 -in $root	-row 1 -column 2 
	grid $base.frame#6 -in $root	-row 1 -column 3 
	grid $base.checkbuttonUselinkercommandfile -in $base.frame#3	-row 1 -column 1  \
		-sticky w
	grid $base.checkbuttonUsestartfile -in $base.frame#5	-row 1 -column 1  \
		-sticky w
	grid $base.checkbuttonUsemakefile -in $base.frame#6	-row 1 -column 1  \
		-sticky w
	grid $base.entryLdfilename -in $base.frame#3	-row 2 -column 1  \
		-sticky ew
	grid $base.entryStartfilename -in $base.frame#5	-row 2 -column 1  \
		-sticky ew
	grid $base.entryMakefilename -in $base.frame#6	-row 2 -column 1 
	grid $base.canvasTools -in $base.frame#4	-row 1 -column 1  \
		-sticky nesw
	grid $base.scrollbar#2 -in $base.frame#4	-row 1 -column 2  \
		-sticky ns

	# Resize behavior management

	grid rowconfigure $base.frame#6 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#6 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#3 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#3 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#3 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#4 1 -weight 1 -minsize 30
	grid columnconfigure $base.frame#4 1 -weight 1 -minsize 30
	grid columnconfigure $base.frame#4 2 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 0 -minsize 30
	grid columnconfigure $root 4 -weight 1 -minsize 30

	grid rowconfigure $base.frame#5 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#5 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 1 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
    return
}

# get the containing window
set w [lindex $args 0]
global code::Configure

# the linker command file controls
set Configure(Build,ldfile) [Preference Build ldfile]
code::help $w $base.checkbuttonUselinkercommandfile \
    "Use an existing linker command file instead of generating one"
$base.checkbuttonUselinkercommandfile config -command \
    "code::Preference Build ldfile \$code::Configure(Build,ldfile)"

set Configure(Build,ldfilename) [Preference Build ldfilename]
code::help $w $base.entryLdfilename \
    "Optional name of the linker command file, defaults to LDFILE (below)"
bind $base.entryLdfilename <FocusOut> "code::PreferenceSetIfChanged Build ldfilename \
    \$code::Configure(Build,ldfilename)"
bind $base.entryLdfilename <Return> "code::PreferenceSetIfChanged Build ldfilename \
    \$code::Configure(Build,ldfilename)"

# the startup code file controls
set Configure(System,startfile) [Preference System startfile]
code::help $w $base.checkbuttonUsestartfile \
    "Use an existing startup code file instead of generating one"
$base.checkbuttonUsestartfile config -command \
    "code::Preference System startfile \$code::Configure(System,startfile)"

set Configure(System,startfilename) [Preference System startfilename]
code::help $w $base.entryStartfilename \
    "Name of the startup code file"
bind $base.entryStartfilename <FocusOut> "code::PreferenceSetIfChanged System startfilename \
    \$code::Configure(System,startfilename)"
bind $base.entryStartfilename <Return> "code::PreferenceSetIfChanged System startfilename \
    \$code::Configure(System,startfilename)"

# the makefile controls
set Configure(Build,makefile) [Preference Build makefile]
code::help $w $base.checkbuttonUsemakefile \
    "Use an existing makefile and external build program, see BUILD below"
$base.checkbuttonUsemakefile config -command \
    "code::Preference Build makefile \$code::Configure(Build,makefile)"

set Configure(Build,makefilename) [Preference Build makefilename]
code::help $w $base.entryMakefilename \
    "Name of the makefile"
bind $base.entryMakefilename <FocusOut> "code::PreferenceSetIfChanged Build makefilename \
    \$code::Configure(Build,makefilename)"
bind $base.entryMakefilename <Return> "code::PreferenceSetIfChanged Build makefilename \
    \$code::Configure(Build,makefilename)"

# list the build variables
set c $base.canvasTools
set row 0
set f [frame $c.f]
set id [$c create window 0 0 -window $f]

set list {
    AR "The library manager"
    ARFLAGS "Flags passed to the library manager"
    ARSUBNAME "The middle part of the library name"
    ARNAME "The full library name"
    Archive "The command line used to build a library"
    AS "The assembler"
    ASFLAGS "Flags passed to the assembler"
    Assemble "The command line used to assemble a program"
    AssembleCheck "The command line used to check a program for assembly errors"
    CC "The C compiler"
    CFLAGS "Flags passed to the C compiler"
    Compile "The command line used to compile a C program"
    CompileCheck "The command line used to check a C program for errors"
    LD "The linker"
    LDFLAGS "Flags passed to the linker"
    LDFILE "The default linker command file"
    LDFILEG "Option for using a generated linker command file"
    LDOUT "The default linker output file name"
    Link "The command line used to link a program"
    LIBS "The default libraries used when linking"
    LLIBS "Large model libraries used when linking (if available)"
    E "The processor specific string used to create file name extensions"
    XA "The library base extension"
    XE "The executable program base extension"
    XO "The object file base extension"
    XS "The assembly file base extension"
    XC "The C file base extension"
    XASM "Alternate assembly file base extension"
    XMCU "The microcontroller awareness file base extension"
    XMCD "The machine code description file base extension"
    XCCD "The compiled machine code description file base extension"
    XDDF "The Device Definition file base extension"
    maxaddress "The largest address permitted in the memory map window"
    Srecords "The command used to create an S-record file"
    Intelhex "The command used to create an Intel hex file"
    IEEE695 "The command used to create an IEEE-695 object file"
    UseIcode "This flag is set to a true value to specify that icode should be used for builds"
    CCICODE "The ICODE C compiler"
    CompileIcode "The command line used to compile a C program into ICODE"
    CompileIcodeCheck "The command line used to check an icode target C program for errors"
    LDICODE "The ICODE linker"
    LinkIcode "The command line used to link an ICODE program"
    ILIBS "The default libraries used when linking ICODE"
    CompileMCD "The command line used to compile a machine code description file"
    CompileMCDCheck "The command line used to check a machine code description file for errors"
    CompileMCUCheck "The command line used to check a microcontroller awareness file for errors"
}

set globallist {
    BUILD "External project building command line"
    EDIT "External editor command line"
}

proc ::ToolsGet {list} {
    global code::Configure

    foreach "name description" $list {
    set Configure(Build,$name) \
        [code::Preference Build \
            [code::Preference Build processor]$name]
    }
}

proc ::ToolsGlobalGet {list} {
    global code::Configure

    foreach "name description" $list {
    set Configure(General,$name) \
        [code::Preference General $name]
    }
}

# get the current value of the variables
ToolsGet $list
ToolsGlobalGet $globallist

trace variable Configure(Build,processor) w \
    "ToolsGet [list $list] ; #"

foreach "name description" $list {
    set l [label $f.l$row -text $name -width 20 -anchor e]
    help $w $l $description
    set e [entry $f.e$row \
        -textvariable code::Configure(Build,$name) \
        -width 70]
    help $w $e $description
    bind $e <FocusOut> "code::PreferenceSetIfChanged \
        Build \[code::Preference Build processor\]$name \
        \$code::Configure(Build,$name)"
    bind $e <Return> "code::PreferenceSetIfChanged \
        Build \[code::Preference Build processor\]$name \
        \$code::Configure(Build,$name)"
    grid $l -in $f -row $row -column 1
    grid $e -in $f -row $row -column 2 -sticky ew
    incr row
}

foreach "name description" $globallist {
    set l [label $f.l$row -text $name -width 20 -anchor e]
    help $w $l $description
    set e [entry $f.e$row \
        -textvariable code::Configure(General,$name) \
        -width 70]
    help $w $e $description
    bind $e <FocusOut> "code::PreferenceSetIfChanged \
        General $name \$code::Configure(General,$name)"
    bind $e <Return> "code::PreferenceSetIfChanged \
        General $name \$code::Configure(General,$name)"
    grid $l -in $f -row $row -column 1
    grid $e -in $f -row $row -column 2 -sticky ew
    incr row
}

grid columnconfigure $f 2 -weight 1

update idletasks
set bbox [$c bbox $id]
set width [expr [lindex $bbox 2] - [lindex $bbox 0]]
$c config -scrollregion $bbox -width $width
$c xview moveto 0
$c yview moveto 0
 
return "Tools used by this project"






















# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Tools_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Tools_ui"
	    Tools_ui .
	}
    }
}
