#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Variant.ui
#   root     is the parent window for this user interface

proc Variant_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#1

	frame $base.frame#4 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#9

	label $base.labelProcessorFamily \
		-text {Based on Processor}

	label $base.labelName \
		-text Name:

	entry $base.entryName \
		-textvariable Variant(variant)

	menubutton $base.menubuttonProcessorFamily \
		-indicatoron 1 \
		-relief raised \
		-textvariable code::Configure(Build,processor)

	button $base.buttonDefinevariant \
		-command VariantSave \
		-text {Define Variant}

	label $base.labelProcessorVariant \
		-text {Based On Variant}

	button $base.buttonDeletevariant \
		-command VariantDelete \
		-text {Delete Variant}

	menubutton $base.menubuttonProcessorVariant \
		-indicatoron 1 \
		-relief raised \
		-textvariable code::Configure(Build,variant)

	label $base.labelDdffile \
		-text {Ddf file:}

	entry $base.entryDdffile \
		-textvariable Variant(ddf)

	label $base.labelDdfimport \
		-text {Ddf import:}

	entry $base.entryDdfimport \
		-textvariable Variant(import)

	label $base.labelMemoryfile \
		-text {Memory file:}

	entry $base.entryMemoryfile \
		-textvariable Variant(memory)

	label $base.labelDefaultmap \
		-text {Default map:}

	entry $base.entryDefaultmap \
		-textvariable Variant(defaultmemory)

	label $base.labelModulefile \
		-text {Module file:}

	entry $base.entryModulefile \
		-textvariable Variant(module)

	label $base.labelSectionsfile \
		-text {Sections file:}

	entry $base.entrySectionsfile \
		-textvariable Variant(sections)

	label $base.labelVectorsfile \
		-text {Vectors file:}

	entry $base.entryVectorsfile \
		-textvariable Variant(vectors)

	label $base.labelVectorsimport \
		-text {Vectors import:}

	entry $base.entryVectorsimport \
		-textvariable Variant(vectorsimport)

	label $base.labelVariablesfile \
		-text {Variables file:}

	entry $base.entryVariablesfile \
		-textvariable Variant(variables)


	# Geometry management

	grid $base.frame#1 -in $root	-row 1 -column 1 
	grid $base.frame#4 -in $root	-row 1 -column 2  \
		-rowspan 3 \
		-sticky n
	grid $base.frame#9 -in $root	-row 4 -column 1  \
		-columnspan 3 \
		-sticky nw
	grid $base.labelProcessorFamily -in $base.frame#4	-row 1 -column 1 
	grid $base.labelName -in $base.frame#1	-row 1 -column 1 
	grid $base.entryName -in $base.frame#1	-row 1 -column 2 
	grid $base.menubuttonProcessorFamily -in $base.frame#4	-row 2 -column 1  \
		-sticky ew
	grid $base.buttonDefinevariant -in $root	-row 2 -column 1  \
		-sticky w
	grid $base.labelProcessorVariant -in $base.frame#4	-row 3 -column 1 
	grid $base.buttonDeletevariant -in $root	-row 3 -column 1  \
		-sticky w
	grid $base.menubuttonProcessorVariant -in $base.frame#4	-row 4 -column 1  \
		-sticky ew
	grid $base.labelDdffile -in $base.frame#9	-row 1 -column 1  \
		-sticky e
	grid $base.entryDdffile -in $base.frame#9	-row 1 -column 2 
	grid $base.labelDdfimport -in $base.frame#9	-row 1 -column 3  \
		-sticky e
	grid $base.entryDdfimport -in $base.frame#9	-row 1 -column 4 
	grid $base.labelMemoryfile -in $base.frame#9	-row 2 -column 1  \
		-sticky e
	grid $base.entryMemoryfile -in $base.frame#9	-row 2 -column 2 
	grid $base.labelDefaultmap -in $base.frame#9	-row 2 -column 3  \
		-sticky e
	grid $base.entryDefaultmap -in $base.frame#9	-row 2 -column 4 
	grid $base.labelModulefile -in $base.frame#9	-row 3 -column 1  \
		-sticky e
	grid $base.entryModulefile -in $base.frame#9	-row 3 -column 2 
	grid $base.labelSectionsfile -in $base.frame#9	-row 3 -column 3  \
		-sticky e
	grid $base.entrySectionsfile -in $base.frame#9	-row 3 -column 4 
	grid $base.labelVectorsfile -in $base.frame#9	-row 4 -column 1  \
		-sticky e
	grid $base.entryVectorsfile -in $base.frame#9	-row 4 -column 2 
	grid $base.labelVectorsimport -in $base.frame#9	-row 4 -column 3  \
		-sticky e
	grid $base.entryVectorsimport -in $base.frame#9	-row 4 -column 4 
	grid $base.labelVariablesfile -in $base.frame#9	-row 5 -column 1  \
		-sticky e
	grid $base.entryVariablesfile -in $base.frame#9	-row 5 -column 2 

	# Resize behavior management

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 0 -minsize 30
	grid rowconfigure $root 3 -weight 0 -minsize 30
	grid rowconfigure $root 4 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 1 -minsize 30

	grid rowconfigure $base.frame#4 1 -weight 0 -minsize 13
	grid rowconfigure $base.frame#4 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#4 3 -weight 0 -minsize 7
	grid rowconfigure $base.frame#4 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#4 1 -weight 0 -minsize 30

	grid rowconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#1 2 -weight 0 -minsize 30

	grid rowconfigure $base.frame#9 1 -weight 0 -minsize 30
	grid rowconfigure $base.frame#9 2 -weight 0 -minsize 30
	grid rowconfigure $base.frame#9 3 -weight 0 -minsize 30
	grid rowconfigure $base.frame#9 4 -weight 0 -minsize 30
	grid rowconfigure $base.frame#9 5 -weight 0 -minsize 30
	grid columnconfigure $base.frame#9 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#9 2 -weight 0 -minsize 23
	grid columnconfigure $base.frame#9 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#9 4 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
    return
}

# get the containing window
set w [lindex $args 0]
global code::Configure
global Variant

set Variant(w) $w
set Variant(base) $base

# the variant name
code::help $w $base.entryName {The name of the new variant}
code::help $w $base.labelName {The name of the new variant}

# set up the processor definition controls
code::help $w $base.labelProcessorFamily \
    {The current target processor}
code::help $w $base.menubuttonProcessorFamily \
    {Change the current target processor}
$base.menubuttonProcessorFamily config \
    -menu [code::PreferenceProcessorMenu $base.menubuttonProcessorFamily.processor] \
    -direction flush
code::help $w $base.labelProcessorVariant \
    {The current target processor variant}
set variant [code::Preference Build variant]
code::help $w $base.menubuttonProcessorVariant \
    {Change the current target processor variant}
$base.menubuttonProcessorVariant config \
    -menu [code::PreferenceVariantMenu $base.menubuttonProcessorVariant.variant] \
    -direction flush

proc ::VariantUpdate {} {
    global Variant
    set w $Variant(w)
    set base $Variant(base)
    set list {
    Ddffile ddf "The name of the Device Definition file"
    Ddfimport import "The import symbol to use"
    Memoryfile memory "The name of the memory map file"
    Defaultmap defaultmemory "The default memory map to use"
    Modulefile module "The name of the library module file"
    Sectionsfile sections "The name of the section defining file"
    Vectorsfile vectors "The name of the vectors file"
    Vectorsimport vectorsimport "The import symbol for the vector table"
    Variablesfile variables "The name of the linker variables file"
    }

    foreach "name var desc" $list {
        code::help $w $base.label$name $desc
        code::help $w $base.entry$name $desc
        set Variant($var) [code::Preference Build $var]
    }
    set Variant(variant) [code::Preference Build variant]
}
VariantUpdate

foreach name {ddf import memory defaultmemory module
    sections vectors vectorsimport variables} {
    trace variable Configure(Build,$name) w "VariantUpdate ;#"
}

code::help $w $base.buttonDefinevariant "Define this as a new variant"
code::help $w $base.buttonDeletevariant "Delete this user-defined variant"

proc ::VariantSave {} {
    global Variant
    global code::Preferences

    if {$Variant(variant) == {}} {
        tk_messageBox \
            -icon error \
            -message "You must name the variant" \
            -type ok
        return
    }
    set proc [code::Preference Build processor]
    set newvariant [list $proc $Variant(variant) \
        $Variant(ddf) $Variant(import) $Variant(memory) \
        $Variant(defaultmemory) $Variant(module) \
        $Variant(sections) $Variant(variables) \
        $Variant(vectors) $Variant(vectorsimport)]
    set myvariants [code::Preference $proc myvariants]
    set index 0
    foreach variant $myvariants {
        # check for a pre-existing one, and change it

        if {[lindex $variant 1] == $Variant(variant)} {
            # change this one
            break
        }
        incr index
     }
     if {$index < [llength $myvariants]} {
        # editing
        set myvariants [lreplace $myvariants $index $index \
            $newvariant]
     } else {
        # a new variant
        foreach variant [code::PreferenceVariantInfo] {
	    # can't use the same same as a pre-existing
            if {$Variant(variant) == $variant} {
                tk_messageBox \
                    -icon error \
                    -message "The $Variant(variant) is already defined" \
                    -type ok
                return
            }
        }
        lappend myvariants $newvariant
     }

     # regenerate the system variant info
     code::PreferenceSetIfChanged $proc myvariants $myvariants
     code::Preference Build variant $Variant(variant)
}

proc ::VariantDelete {} {
    global Variant
    global code::Preferences
    global code::Configure

    if {$Variant(variant) == {}} {
        return
    }
    set proc [code::Preference Build processor]
    set myvariants [code::Preference $proc myvariants]
    set index 0
    foreach variant $myvariants {
        # check for a pre-existing one, and change it

        if {[lindex $variant 1] == $Variant(variant)} {
            # delete this one
            break
        }
        incr index
    }
    if {$index < [llength $myvariants]} {
        # editing
        set myvariants [lreplace $myvariants $index $index]
    } else {
        # a new variant
        foreach variant [code::PreferenceVariantInfo] {
            # can't delete a pre-existing
            if {$Variant(variant) == $variant} {
                tk_messageBox \
                    -icon error \
                    -message "The $Variant(variant) is a predefined variant and can't be deleted" \
                    -type ok
                return
            }
        }
    }

    # regenerate the system variant info
    code::PreferenceSetIfChanged $proc myvariants $myvariants
    code::Preference Build variant {} 1
    set Configure(Build,variant) Unknown
    VariantUpdate
}
return "Define a new processor variant"





# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Variant_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Variant_ui"
	    Variant_ui .
	}
    }
}
