#! /bin/sh
# the next line restarts using wish4.2 \
exec wish4.2 "$0" "$@"
# interface generated by SpecTcl version 1.1 from /usr/rich/build/Source/source/ilib/code/library/Vectors.ui
#   root     is the parent window for this user interface

proc Vectors_ui {root args} {

	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.frame#4 \
		-borderwidth 2 \
		-relief groove

	frame $base.frame#5

	frame $base.frame#6

	checkbutton $base.checkbuttonSetupvectors \
		-text {Set up vectors} \
		-variable code::Configure(System,definevectors)

	label $base.labelHighestvector \
		-text {Highest vector:}

	entry $base.entryHighestvector \
		-textvariable code::Configure(System,maxvector) \
		-width 6

	button $base.buttonRestoredefaults \
		-command VectorsDefault \
		-text {Restore Defaults}

	label $base.labelUnhandledexceptions \
		-text {Unhandled exceptions:}

	radiobutton $base.radiobuttonExit \
		-text Exit \
		-value 0 \
		-variable code::Configure(System,unhandledtraps)

	radiobutton $base.radiobuttonCatch \
		-text Catch \
		-value 1 \
		-variable code::Configure(System,unhandledtraps)

	radiobutton $base.radiobuttonRevector \
		-text Re-vector \
		-value 2 \
		-variable code::Configure(System,unhandledtraps)

	label $base.labelRevectorto \
		-text {Re-vector to:}

	entry $base.entryRevectorto \
		-textvariable code::Configure(System,revectors)

	canvas $base.canvasVectors \
		-height 0 \
		-selectbackground #c3c3c3 \
		-selectforeground Black \
		-width 0 \
		-yscrollcommand "$base.scrollbar#2 set"

	scrollbar $base.scrollbar#2 \
		-command "$base.canvasVectors yview" \
		-orient v


	# Geometry management

	grid $base.frame#4 -in $root	-row 3 -column 1  \
		-columnspan 3 \
		-sticky nesw
	grid $base.frame#5 -in $root	-row 1 -column 1  \
		-columnspan 3 \
		-sticky ew
	grid $base.frame#6 -in $root	-row 2 -column 1  \
		-columnspan 3 \
		-sticky w
	grid $base.checkbuttonSetupvectors -in $base.frame#5	-row 1 -column 1 
	grid $base.labelHighestvector -in $base.frame#5	-row 1 -column 3  \
		-sticky e
	grid $base.entryHighestvector -in $base.frame#5	-row 1 -column 4 
	grid $base.buttonRestoredefaults -in $base.frame#5	-row 1 -column 6  \
		-sticky e
	grid $base.labelUnhandledexceptions -in $base.frame#6	-row 1 -column 1 
	grid $base.radiobuttonExit -in $base.frame#6	-row 1 -column 2 
	grid $base.radiobuttonCatch -in $base.frame#6	-row 1 -column 3 
	grid $base.radiobuttonRevector -in $base.frame#6	-row 1 -column 4 
	grid $base.labelRevectorto -in $base.frame#6	-row 1 -column 6 
	grid $base.entryRevectorto -in $base.frame#6	-row 1 -column 7 
	grid $base.canvasVectors -in $base.frame#4	-row 1 -column 1  \
		-sticky nesw
	grid $base.scrollbar#2 -in $base.frame#4	-row 1 -column 2  \
		-sticky ns

	# Resize behavior management

	grid rowconfigure $base.frame#6 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 5 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 6 -weight 0 -minsize 30
	grid columnconfigure $base.frame#6 7 -weight 0 -minsize 30

	grid rowconfigure $base.frame#4 1 -weight 1 -minsize 30
	grid columnconfigure $base.frame#4 1 -weight 1 -minsize 30
	grid columnconfigure $base.frame#4 2 -weight 0 -minsize 30

	grid rowconfigure $root 1 -weight 0 -minsize 30
	grid rowconfigure $root 2 -weight 0 -minsize 30
	grid rowconfigure $root 3 -weight 1 -minsize 30
	grid columnconfigure $root 1 -weight 0 -minsize 30
	grid columnconfigure $root 2 -weight 0 -minsize 30
	grid columnconfigure $root 3 -weight 1 -minsize 30

	grid rowconfigure $base.frame#5 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 1 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 2 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 3 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 4 -weight 0 -minsize 30
	grid columnconfigure $base.frame#5 5 -weight 1 -minsize 30
	grid columnconfigure $base.frame#5 6 -weight 0 -minsize 30
# additional interface code
if {$base == {}} {
    # testing
    return
}

# get the containing window
set w [lindex $args 0]
global code::Configure
global Vectors

# create a frame for the vectors
set c $base.canvasVectors

set vf [frame $c.f]
set id [$c create window 0 0 -window $vf]

set list [code::ConfigureGetValue System vectors]
set vector 0
foreach "name value description" $list {
    set Vectors($name) $value
    set e [entry $vf.e$vector -width 40 \
        -textvariable Vectors($name)]
    bind $e <FocusOut> "code::ConfigureSetVector $name \$Vectors($name)"
    bind $e <Return> "code::ConfigureSetVector $name \$Vectors($name)"
    help $w $e "The name of the vector entry point"
    if {$description == {}} {
        # no description - reserved
        regexp {__vec(.*)} $name all adr
        set description "Reserved vector at 0x$adr"
    }
    set l [label $vf.l$vector -text "$vector - $description" -anchor w]
    help $w $l "Number and description of the vector"
    grid $e -in $vf -row $vector -column 1
    grid $l -in $vf -row $vector -column 2 -sticky w
    incr vector
}

grid columnconfigure $vf 2 -weight 1

update idletasks
set bbox [$c bbox $id]
set width [expr [lindex $bbox 2] - [lindex $bbox 0]]
$c config -scrollregion $bbox -width $width
$c xview moveto 0
$c yview moveto 0

proc ::VectorsDefault {} {
    global Vectors

    code::Preference System vectors {} 1 
    set default [code::ConfigureGetValue System vectors]
    foreach "name value description" $default {
        set Vectors($name) $value
    }
}

set code::Configure(System,definevectors) \
    [code::Preference System definevectors]
$base.checkbuttonSetupvectors config \
    -command "code::Preference System definevectors \$code::Configure(System,definevectors)"
code::help $w $base.checkbuttonSetupvectors \
    {Initialize the processor vector table}

set code::Configure(System,maxvector) \
    [code::Preference System maxvector]
code::help $w $base.labelHighestvector \
    {Highest vector to set up in the generated startup code (vector number or blank for all)}
code::help $w $base.entryHighestvector \
    {Highest vector to set up in the generated startup code (vector number or blank for all)}
bind $base.entryHighestvector <Return> VectorHighest
bind $base.entryHighestvector <FocusOut> VectorHighest

proc ::VectorHighest {} {
    global code::Configure

    set value $Configure(System,maxvector)
    if {$value != {} && [catch {expr int($value)}]} {
        tk_messageBox \
            -icon error \
            -message "Invalid integer constant" \
            -type ok
        set value {}
    }
    code::PreferenceSetIfChanged System maxvector $value
}

code::help $w $base.buttonRestoredefaults \
    {Restore the default vector table values}

set code::Configure(System,revectors) \
    [code::Preference System revectors]
code::help $w $base.labelRevectorto \
    {Base address where unhandled exceptions should be re-vectored}
code::help $w $base.entryRevectorto \
    {Base address where unhandled exceptions should be re-vectored}
bind $base.entryRevectorto <Return> \
    {code::PreferenceSetIfChanged System revectors \
        $code::Configure(System,revectors)}
bind $base.entryRevectorto <FocusOut> \
    {code::PreferenceSetIfChanged System revectors \
        $code::Configure(System,revectors)}

code::help $w $base.labelUnhandledexceptions \
    {Specify how unhandled exceptions should be handled}
set code::Configure(System,unhandledtraps) \
    [code::Preference System unhandledtraps]
$base.radiobuttonExit config \
    -command "code::Preference System unhandledtraps \$code::Configure(System,unhandledtraps)"
code::help $w $base.radiobuttonExit \
    {Unhandled exceptions go to __exit}
$base.radiobuttonCatch config \
    -command "code::Preference System unhandledtraps \$code::Configure(System,unhandledtraps)"
code::help $w $base.radiobuttonCatch \
    {Unhandled exceptions are trapped individually}
$base.radiobuttonRevector config \
    -command "code::Preference System unhandledtraps \$code::Configure(System,unhandledtraps)"
code::help $w $base.radiobuttonRevector \
    {Unhandled exceptions are re-vectored through another memory location}

return "Set up the program's exception and interrupt vectors"
















# end additional interface code

}


# Allow interface to be run "stand-alone" for testing

catch {
    if [info exists embed_args] {
	# we are running in the plugin
	Vectors_ui .
    } else {
	# we are running in stand-alone mode
	if {$argv0 == [info script]} {
	    wm title . "Testing Vectors_ui"
	    Vectors_ui .
	}
    }
}
